/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.core.json.pointer.JsonPointerIterator;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.common.RefSchema;
import io.vertx.json.schema.common.RouterNode;
import io.vertx.json.schema.common.RouterNodeJsonPointerIterator;
import io.vertx.json.schema.common.SchemaImpl;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.URIUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SchemaRouterImpl
implements SchemaRouter {
    private final Map<URI, RouterNode> absolutePaths;
    private final Map<URI, Object> rootJsons;
    private final HttpClient client;
    private final FileSystem fs;
    private final Map<URI, Future<Schema>> externalSchemasSolving;
    private final SchemaRouterOptions options;

    public SchemaRouterImpl(HttpClient client, FileSystem fs, SchemaRouterOptions options) {
        this.client = client;
        this.fs = fs;
        this.absolutePaths = new HashMap<URI, RouterNode>();
        this.rootJsons = new HashMap<URI, Object>();
        this.externalSchemasSolving = new ConcurrentHashMap<URI, Future<Schema>>();
        this.options = options;
    }

    @Override
    public List<Schema> registeredSchemas() {
        return this.absolutePaths.values().stream().flatMap(RouterNode::flattened).map(RouterNode::getSchema).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Schema resolveCachedSchema(JsonPointer refPointer, JsonPointer scope, SchemaParser parser) {
        return this.resolveParentNode(refPointer, scope).flatMap(parentNode -> {
            Optional<RouterNode> resultNode = Optional.ofNullable((RouterNode)refPointer.query(parentNode, (JsonPointerIterator)RouterNodeJsonPointerIterator.INSTANCE));
            if (resultNode.isPresent()) {
                return resultNode.map(RouterNode::getSchema);
            }
            if (parentNode.getSchema() instanceof SchemaImpl) {
                return Optional.ofNullable(refPointer.queryJson(parentNode.getSchema().getJson())).map(queryResult -> ((SchemaParserInternal)parser).parse(queryResult, URIUtils.replaceFragment(parentNode.getSchema().getScope().getURIWithoutFragment(), refPointer.toString())));
            }
            return Optional.empty();
        }).orElseGet(() -> this.resolveAbsoluteUriAlternatives(refPointer, scope).filter(this.rootJsons::containsKey).map(uriToSolve -> {
            Object realLocation = refPointer.queryJson(this.rootJsons.get(uriToSolve));
            if (realLocation == null) {
                return null;
            }
            return ((SchemaParserInternal)parser).parse(realLocation, JsonPointer.fromURI((URI)URIUtils.replaceFragment(uriToSolve, refPointer.toString())));
        }).filter(Objects::nonNull).findFirst().orElse(null));
    }

    @Override
    public void resolveRef(JsonPointer pointer, JsonPointer scope, SchemaParser schemaParser, Handler<AsyncResult<Schema>> handler) {
        Future<Schema> fut = this.resolveRef(pointer, scope, schemaParser);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Schema> resolveRef(JsonPointer pointer, JsonPointer scope, SchemaParser schemaParser) {
        try {
            Schema cachedSchema = this.resolveCachedSchema(pointer, scope, schemaParser);
            if (cachedSchema == null) {
                return this.resolveExternalRef(pointer, scope, schemaParser);
            }
            return Future.succeededFuture((Object)cachedSchema);
        }
        catch (SchemaException e) {
            return Future.failedFuture((Throwable)((Object)e));
        }
    }

    @Override
    public SchemaRouter addSchema(Schema schema, JsonPointer ... aliasScope) {
        JsonPointer pointer = schema.getScope();
        if (!pointer.getURIWithoutFragment().isAbsolute()) {
            throw new IllegalStateException("Schema scope MUST be a pointer with an absolute URI. Actual: " + pointer.getURIWithoutFragment());
        }
        RouterNode parentNode = this.absolutePaths.computeIfAbsent(pointer.getURIWithoutFragment(), k -> new RouterNode());
        this.insertSchema(pointer, parentNode, schema);
        RouterNode insertedNode = (RouterNode)pointer.query((Object)parentNode, (JsonPointerIterator)RouterNodeJsonPointerIterator.INSTANCE);
        for (JsonPointer alias : aliasScope) {
            if (!alias.getURIWithoutFragment().isAbsolute()) {
                throw new IllegalStateException("Schema scope MUST be a pointer with an absolute URI. Actual: " + alias.getURIWithoutFragment());
            }
            this.insertRouterNode(alias, insertedNode);
        }
        return this;
    }

    @Override
    public SchemaRouter addSchemaWithScope(Schema schema, JsonPointer scope) {
        URIUtils.requireAbsoluteUri(scope.getURIWithoutFragment(), "schema scope");
        RouterNode parentNode = this.absolutePaths.computeIfAbsent(scope.getURIWithoutFragment(), k -> new RouterNode());
        this.insertSchema(scope, parentNode, schema);
        return this;
    }

    @Override
    public SchemaRouter addSchemaAlias(Schema schema, String alias) {
        RouterNode parentNode = this.absolutePaths.get(schema.getScope().getURIWithoutFragment());
        if (parentNode == null) {
            throw new IllegalStateException("Schema parent node does not exists: " + schema.getScope().getURIWithoutFragment());
        }
        RouterNode schemaNode = (RouterNode)schema.getScope().query((Object)parentNode, (JsonPointerIterator)RouterNodeJsonPointerIterator.INSTANCE);
        if (schemaNode == null) {
            throw new IllegalStateException("Schema node does not exists: " + schema.getScope().toURI());
        }
        parentNode.getChilds().put(alias, schemaNode);
        return this;
    }

    @Override
    public SchemaRouter addJson(URI uri, JsonObject object) {
        URIUtils.requireAbsoluteUri(uri);
        this.rootJsons.put(uri, object);
        return this;
    }

    public Future<Void> resolveAllSchemas() {
        return CompositeFuture.all(this.registeredSchemas().stream().map(this::solveAllSchemaReferences).collect(Collectors.toList())).mapEmpty();
    }

    public Future<Schema> solveAllSchemaReferences(Schema schema) {
        if (schema instanceof RefSchema) {
            return ((RefSchema)schema).trySolveSchema().compose(s -> s != schema ? this.solveAllSchemaReferences((Schema)s).map((Object)schema) : Future.succeededFuture((Object)schema));
        }
        if (schema.getScope().getURIWithoutFragment() == null || !schema.getScope().getURIWithoutFragment().isAbsolute()) {
            return Future.succeededFuture((Object)schema);
        }
        RouterNode node = this.absolutePaths.get(schema.getScope().getURIWithoutFragment());
        node = (RouterNode)schema.getScope().query((Object)node, (JsonPointerIterator)RouterNodeJsonPointerIterator.INSTANCE);
        return CompositeFuture.all(node.reverseFlattened().collect(Collectors.toList()).stream().map(RouterNode::getSchema).filter(Objects::nonNull).filter(s -> s instanceof RefSchema).map(s -> (RefSchema)s).map(RefSchema::trySolveSchema).collect(Collectors.toList())).map((Object)schema);
    }

    private Stream<URI> getScopeParentAliases(JsonPointer scope) {
        Stream.Builder uriStreamBuilder = Stream.builder();
        RouterNode startingNode = this.absolutePaths.get(scope.getURIWithoutFragment());
        if (startingNode == null) {
            return Stream.of(scope.getURIWithoutFragment());
        }
        scope.tracedQuery((Object)startingNode, (JsonPointerIterator)RouterNodeJsonPointerIterator.INSTANCE).forEach(node -> this.absolutePaths.forEach((uri, n) -> {
            if (n == node) {
                uriStreamBuilder.accept(uri);
            }
        }));
        return uriStreamBuilder.build();
    }

    private Stream<URI> resolveAbsoluteUriAlternatives(JsonPointer refPointer, JsonPointer scope) {
        URI refURI = refPointer.getURIWithoutFragment();
        if (!refURI.isAbsolute()) {
            if (refURI.getPath() != null && !refURI.getPath().isEmpty()) {
                return Stream.concat(this.getScopeParentAliases(scope).map(e -> URIUtils.resolvePath(e, refURI.getPath())), Stream.of(this.getResourceAbsoluteURIFromClasspath(refURI), refURI)).filter(Objects::nonNull);
            }
            return Stream.of(scope.getURIWithoutFragment());
        }
        return Stream.of(refURI);
    }

    private Optional<RouterNode> resolveParentNode(JsonPointer refPointer, JsonPointer scope) {
        return this.resolveAbsoluteUriAlternatives(refPointer, scope).map(this.absolutePaths::get).filter(Objects::nonNull).findFirst();
    }

    private Future<String> solveRemoteRef(URI ref) {
        String uri = ref.toString();
        if (!this.options.getAuthQueryParams().isEmpty()) {
            QueryStringEncoder encoder = new QueryStringEncoder(uri);
            this.options.getAuthQueryParams().forEach((arg_0, arg_1) -> ((QueryStringEncoder)encoder).addParam(arg_0, arg_1));
            uri = encoder.toString();
        }
        RequestOptions reqOptions = new RequestOptions().setMethod(HttpMethod.GET).setAbsoluteURI(uri).setFollowRedirects(Boolean.valueOf(true)).addHeader(HttpHeaders.ACCEPT.toString(), "application/json, application/schema+json");
        this.options.getAuthHeaders().forEach((arg_0, arg_1) -> ((RequestOptions)reqOptions).addHeader(arg_0, arg_1));
        return this.client.request(reqOptions).compose(req -> req.send().compose(resp -> {
            int statusCode = resp.statusCode();
            if (statusCode < 200 || statusCode > 299) {
                return Future.failedFuture((Throwable)new IllegalStateException("Wrong status " + statusCode + " " + resp.statusMessage() + " received while resolving remote ref"));
            }
            return resp.body().map(Buffer::toString);
        }));
    }

    private Future<String> solveLocalRef(URI ref) {
        Promise promise = Promise.promise();
        String filePath = "jar".equals(ref.getScheme()) ? ref.getSchemeSpecificPart().split("!")[1].substring(1) : ref.getPath();
        this.fs.readFile(filePath, res -> {
            if (res.succeeded()) {
                promise.complete((Object)((Buffer)res.result()).toString());
            } else {
                promise.fail(res.cause());
            }
        });
        return promise.future();
    }

    private Future<Schema> resolveExternalRef(JsonPointer pointer, JsonPointer scope, SchemaParser schemaParser) {
        URI refURI = pointer.getURIWithoutFragment();
        return this.externalSchemasSolving.computeIfAbsent(refURI, r -> {
            Stream<URI> candidatesURIs = refURI.isAbsolute() ? Stream.of(refURI) : Stream.concat(this.getScopeParentAliases(scope).map(u -> URIUtils.resolvePath(u, refURI.getPath())).filter(u -> URIUtils.isRemoteURI(u) || URIUtils.isLocalURI(u)).sorted((u1, u2) -> URIUtils.isLocalURI(u1) && !URIUtils.isLocalURI(u2) ? 1 : (u1.equals(u2) ? 0 : -1)), Stream.of(this.getResourceAbsoluteURIFromClasspath(refURI)));
            URI uriToSolve = candidatesURIs.filter(Objects::nonNull).findFirst().orElse(refURI);
            return (URIUtils.isRemoteURI(uriToSolve) ? this.solveRemoteRef(uriToSolve) : this.solveLocalRef(uriToSolve)).map(s -> {
                Object root = Json.decodeValue((String)s.trim());
                this.rootJsons.put(uriToSolve, root);
                Object realSchema = pointer.queryJson(root);
                ((SchemaParserInternal)schemaParser).parse(realSchema, JsonPointer.fromURI((URI)URIUtils.replaceFragment(uriToSolve, pointer.toString())));
                return this.resolveCachedSchema(pointer, scope, schemaParser);
            });
        });
    }

    private URI getResourceAbsoluteURIFromClasspath(URI u) {
        try {
            return this.getClassLoader().getResource(u.toString()).toURI();
        }
        catch (NullPointerException | URISyntaxException e) {
            return null;
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }

    public void insertSchema(JsonPointer pointer, RouterNode initialNode, Schema schema) {
        if (pointer.isRootPointer()) {
            initialNode.setSchema((SchemaInternal)schema);
        } else {
            pointer.write((Object)initialNode, (JsonPointerIterator)RouterNodeJsonPointerIterator.INSTANCE, (Object)schema, true);
        }
    }

    public void insertRouterNode(JsonPointer pointer, RouterNode nodeToWrite) {
        if (pointer.isRootPointer()) {
            this.absolutePaths.put(pointer.getURIWithoutFragment(), nodeToWrite);
        } else {
            pointer.write((Object)this.absolutePaths.computeIfAbsent(pointer.getURIWithoutFragment(), k -> new RouterNode()), (JsonPointerIterator)RouterNodeJsonPointerIterator.INSTANCE, (Object)nodeToWrite, true);
        }
    }
}

