/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.HashSet;

public class UniqueItemsValidatorFactory
implements ValidatorFactory {
    private static final BaseSyncValidator UNIQUE_VALIDATOR = new BaseSyncValidator(){

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            JsonArray arr;
            if (in instanceof JsonArray && new HashSet((arr = (JsonArray)in).getList()).size() != arr.size()) {
                throw ValidationException.createException("array elements must be unique", "uniqueItems", in);
            }
        }
    };

    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator validator) {
        try {
            Boolean unique = (Boolean)schema.getValue("uniqueItems");
            if (unique.booleanValue()) {
                return UNIQUE_VALIDATOR;
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for uniqueItems keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null uniqueItems keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("uniqueItems");
    }
}

