/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common.dsl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.common.dsl.ObjectKeyword;
import io.vertx.json.schema.common.dsl.SchemaBuilder;
import io.vertx.json.schema.common.dsl.SchemaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public final class ObjectSchemaBuilder
extends SchemaBuilder<ObjectSchemaBuilder, ObjectKeyword> {
    Map<String, SchemaBuilder> properties = new HashMap<String, SchemaBuilder>();
    Map<Pattern, SchemaBuilder> patternProperties;
    Set<String> requiredProperties = new HashSet<String>();

    ObjectSchemaBuilder() {
        super(SchemaType.OBJECT);
        this.patternProperties = new HashMap<Pattern, SchemaBuilder>();
    }

    public ObjectSchemaBuilder property(String name, SchemaBuilder schemaBuilder) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(schemaBuilder);
        this.properties.put(name, schemaBuilder);
        return this;
    }

    public ObjectSchemaBuilder optionalProperty(String name, SchemaBuilder schemaBuilder) {
        return this.property(name, schemaBuilder);
    }

    public Map<String, SchemaBuilder> getProperties() {
        return this.properties;
    }

    public Map<Pattern, SchemaBuilder> getPatternProperties() {
        return this.patternProperties;
    }

    public boolean isPropertyRequired(String property) {
        return this.requiredProperties.contains(property);
    }

    public ObjectSchemaBuilder requiredProperty(String name, SchemaBuilder schemaBuilder) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(schemaBuilder);
        this.requiredProperties.add(name);
        return this.property(name, schemaBuilder);
    }

    public ObjectSchemaBuilder patternProperty(Pattern pattern, SchemaBuilder schemaBuilder) {
        Objects.requireNonNull(pattern);
        Objects.requireNonNull(schemaBuilder);
        this.patternProperties.put(pattern, schemaBuilder);
        return this;
    }

    public ObjectSchemaBuilder additionalProperties(SchemaBuilder schemaBuilder) {
        Objects.requireNonNull(schemaBuilder);
        this.keywords.put("additionalProperties", schemaBuilder::toJson);
        return this;
    }

    public ObjectSchemaBuilder allowAdditionalProperties(boolean allow) {
        this.keywords.put("additionalProperties", () -> allow);
        return this;
    }

    @Override
    public JsonObject toJson() {
        if (!this.properties.isEmpty()) {
            this.keywords.put("properties", () -> this.properties.entrySet().stream().collect(JsonObject::new, (jo, e) -> jo.put((String)e.getKey(), (Object)((SchemaBuilder)e.getValue()).toJson()), JsonObject::mergeIn));
        }
        if (!this.requiredProperties.isEmpty()) {
            this.keywords.put("required", () -> new JsonArray(new ArrayList<String>(this.requiredProperties)));
        }
        if (!this.patternProperties.isEmpty()) {
            this.keywords.put("patternProperties", () -> this.patternProperties.entrySet().stream().collect(JsonObject::new, (jo, e) -> jo.put(((Pattern)e.getKey()).toString(), (Object)((SchemaBuilder)e.getValue()).toJson()), JsonObject::mergeIn));
        }
        return super.toJson();
    }
}

