/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common.dsl;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.common.dsl.ArrayKeyword;
import io.vertx.json.schema.common.dsl.SchemaBuilder;
import io.vertx.json.schema.common.dsl.SchemaType;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class TupleSchemaBuilder
extends SchemaBuilder<TupleSchemaBuilder, ArrayKeyword> {
    private List<SchemaBuilder> itemList = new LinkedList<SchemaBuilder>();
    private SchemaBuilder additionalItems;

    TupleSchemaBuilder() {
        super(SchemaType.ARRAY);
    }

    @Fluent
    public TupleSchemaBuilder item(SchemaBuilder schemaBuilder) {
        Objects.requireNonNull(schemaBuilder);
        this.itemList.add(schemaBuilder);
        return this;
    }

    @Fluent
    public TupleSchemaBuilder additionalItems(SchemaBuilder schemaBuilder) {
        Objects.requireNonNull(schemaBuilder);
        this.additionalItems = schemaBuilder;
        return this;
    }

    public List<SchemaBuilder> getItemList() {
        return this.itemList;
    }

    public SchemaBuilder getAdditionalItems() {
        return this.additionalItems;
    }

    @Override
    public JsonObject toJson() {
        if (!this.itemList.isEmpty()) {
            this.keywords.put("items", () -> this.itemList.stream().collect(JsonArray::new, (ja, s) -> ja.add((Object)s.toJson()), JsonArray::addAll));
        }
        if (this.additionalItems != null) {
            this.keywords.put("additionalItems", this.additionalItems::toJson);
        }
        return super.toJson();
    }
}

