/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft201909;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSingleSchemaValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ContainsValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Object containsSchema = schema.getValue("contains");
            BoundedContainsValidator validator = new BoundedContainsValidator(parent, schema.getInteger("minContains"), schema.getInteger("maxContains"));
            validator.setSchema(parser.parse(containsSchema, scope.append("contains"), (MutableStateValidator)validator));
            return validator;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for maximum or exclusiveMaximum keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null maximum or exclusiveMaximum keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("contains");
    }

    class BoundedContainsValidator
    extends BaseSingleSchemaValidator {
        private final int min;
        private final Integer max;

        public BoundedContainsValidator(MutableStateValidator parent, Integer min, Integer max) {
            super(parent);
            this.min = min == null ? 1 : min;
            this.max = max;
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            if (this.min == 0) {
                return Future.succeededFuture();
            }
            if (in instanceof JsonArray) {
                if (((JsonArray)in).isEmpty()) {
                    return Future.failedFuture((Throwable)((Object)ValidationException.createException("provided array should not be empty", "contains", in)));
                }
                return CompositeFuture.any(((JsonArray)in).stream().map(v -> this.schema.validateAsync(context.lowerLevelContext(), v)).collect(Collectors.toList())).compose(cf -> {
                    IntStream.rangeClosed(0, cf.size()).forEach(i -> {
                        if (cf.succeeded(i)) {
                            context.markEvaluatedItem(i);
                        }
                    });
                    int matches = cf.size();
                    if (matches < this.min) {
                        return Future.failedFuture((Throwable)((Object)ValidationException.createException("provided array doesn't contain " + this.min + " elements matching the contains schema", "contains", in)));
                    }
                    if (this.max != null && matches > this.max) {
                        return Future.failedFuture((Throwable)((Object)ValidationException.createException("provided array contains more than " + this.max + " elements matching the contains schema", "contains", in)));
                    }
                    return Future.succeededFuture();
                }, err -> Future.failedFuture((Throwable)((Object)ValidationException.createException("provided array doesn't contain any element matching the contains schema", "contains", in, err))));
            }
            return Future.succeededFuture();
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            if (this.min == 0) {
                return;
            }
            this.checkSync();
            ValidationException t = null;
            int matches = 0;
            if (in instanceof JsonArray) {
                JsonArray arr = (JsonArray)in;
                for (int i = 0; i < arr.size(); ++i) {
                    try {
                        this.schema.validateSync(context.lowerLevelContext(), arr.getValue(i));
                        context.markEvaluatedItem(i);
                        ++matches;
                        continue;
                    }
                    catch (ValidationException e) {
                        t = e;
                    }
                }
            }
            if (matches < this.min) {
                throw ValidationException.createException("provided array doesn't contain " + this.min + " elements matching the contains schema", "contains", in, (Throwable)((Object)t));
            }
            if (this.max != null && matches > this.max) {
                throw ValidationException.createException("provided array contains more than " + this.max + " elements matching the contains schema", "contains", in, (Throwable)((Object)t));
            }
        }
    }
}

