/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft201909;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSingleSchemaValidator;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.SetUtils;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.json.schema.common.ValidatorPriority;
import java.util.Set;
import java.util.stream.Collectors;

public class UnevaluatedPropertiesValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) throws SchemaException {
        try {
            Object unevaluatedProperties = schema.getValue("unevaluatedProperties");
            if (unevaluatedProperties instanceof Boolean) {
                if (!((Boolean)unevaluatedProperties).booleanValue()) {
                    return new NoUnevaluatedPropertiesValidator();
                }
                return null;
            }
            SchemedUnevaluatedPropertiesValidator validator = new SchemedUnevaluatedPropertiesValidator(parent);
            validator.setSchema(parser.parse(unevaluatedProperties, scope.append("unevaluatedProperties"), (MutableStateValidator)validator));
            return validator;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for unevaluatedProperties keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null unevaluatedProperties keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("unevaluatedProperties");
    }

    class NoUnevaluatedPropertiesValidator
    extends BaseSyncValidator {
        NoUnevaluatedPropertiesValidator() {
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            if (in instanceof JsonObject && !context.evaluatedProperties().containsAll(((JsonObject)in).fieldNames())) {
                throw ValidationException.createException("Expecting no unevaluated properties. Unevaluated properties: " + SetUtils.minus(((JsonObject)in).fieldNames(), context.evaluatedProperties()), "unevaluatedProperties", in);
            }
        }

        @Override
        public ValidatorPriority getPriority() {
            return ValidatorPriority.CONTEXTUAL_VALIDATOR;
        }
    }

    class SchemedUnevaluatedPropertiesValidator
    extends BaseSingleSchemaValidator {
        public SchemedUnevaluatedPropertiesValidator(MutableStateValidator parent) {
            super(parent);
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            if (in instanceof JsonObject) {
                JsonObject obj = (JsonObject)in;
                Set<String> unevaluatedItems = this.computeUnevaluatedProperties(context, obj);
                return CompositeFuture.all(unevaluatedItems.stream().map(key -> this.schema.validateAsync(context.lowerLevelContext(), obj.getValue(key))).collect(Collectors.toList())).recover(t -> Future.failedFuture((Throwable)((Object)ValidationException.createException("one of the unevaluated properties doesn't match the unevaluatedProperties schema", "unevaluatedProperties", in, t)))).mapEmpty();
            }
            return Future.succeededFuture();
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            if (in instanceof JsonObject) {
                JsonObject obj = (JsonObject)in;
                Set<String> unevaluatedProperties = this.computeUnevaluatedProperties(context, obj);
                unevaluatedProperties.forEach(key -> this.schema.validateSync(context.lowerLevelContext(), obj.getValue(key)));
            }
        }

        @Override
        public ValidatorPriority getPriority() {
            return ValidatorPriority.CONTEXTUAL_VALIDATOR;
        }

        private Set<String> computeUnevaluatedProperties(ValidatorContext context, JsonObject in) {
            return SetUtils.minus(in.fieldNames(), context.evaluatedProperties());
        }
    }
}

