/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseCombinatorsValidator;
import io.vertx.json.schema.common.BaseCombinatorsValidatorFactory;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.ValidatorContext;
import java.util.Arrays;
import java.util.stream.Collectors;

public class AllOfValidatorFactory
extends BaseCombinatorsValidatorFactory {
    @Override
    BaseCombinatorsValidator instantiate(MutableStateValidator parent) {
        return new AllOfValidator(parent);
    }

    @Override
    String getKeyword() {
        return "allOf";
    }

    class AllOfValidator
    extends BaseCombinatorsValidator {
        public AllOfValidator(MutableStateValidator parent) {
            super(parent);
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            for (SchemaInternal s : this.schemas) {
                s.validateSync(context, in);
            }
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            return CompositeFuture.all(Arrays.stream(this.schemas).map(s -> s.validateAsync(context, in)).collect(Collectors.toList())).mapEmpty();
        }
    }
}

