/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.common.BaseMutableStateValidator;
import io.vertx.json.schema.common.DefaultApplier;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaImpl;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.ValidatorPriority;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class BaseCombinatorsValidator
extends BaseMutableStateValidator
implements DefaultApplier {
    protected SchemaInternal[] schemas;

    public BaseCombinatorsValidator(MutableStateValidator parent) {
        super(parent);
    }

    @Override
    public boolean calculateIsSync() {
        return Arrays.stream(this.schemas).map(Schema::isSync).reduce(true, Boolean::logicalAnd);
    }

    void setSchemas(List<SchemaInternal> schemas) {
        this.schemas = schemas.toArray(new SchemaInternal[schemas.size()]);
        Arrays.sort(this.schemas, ValidatorPriority.COMPARATOR);
        this.initializeIsSync();
    }

    @Override
    public Future<Void> applyDefaultValue(Object obj) {
        if (!(obj instanceof JsonObject) && !(obj instanceof JsonArray)) {
            return Future.succeededFuture();
        }
        if (this.isSync()) {
            for (SchemaInternal s2 : this.schemas) {
                ((SchemaImpl)s2).getOrApplyDefaultAsync(obj);
            }
            return Future.succeededFuture();
        }
        return CompositeFuture.all(Arrays.stream(this.schemas).map(s -> s.getOrApplyDefaultAsync(obj)).collect(Collectors.toList())).mapEmpty();
    }
}

