/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseMutableStateValidator;
import io.vertx.json.schema.common.DefaultApplier;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;

public class PropertiesValidatorFactory
implements ValidatorFactory {
    private SchemaInternal parseAdditionalProperties(Object obj, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            return parser.parse(obj, scope.copy().append("additionalProperties"), parent);
        }
        catch (ClassCastException e) {
            throw new SchemaException(obj, "Wrong type for additionalProperties keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(obj, "Null additionalProperties keyword", e);
        }
    }

    private Map<String, SchemaInternal> parseProperties(JsonObject obj, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        JsonPointer basePointer = scope.copy().append("properties");
        HashMap<String, SchemaInternal> parsedSchemas = new HashMap<String, SchemaInternal>();
        for (Map.Entry entry : obj) {
            try {
                parsedSchemas.put((String)entry.getKey(), parser.parse(entry.getValue(), basePointer.copy().append((String)entry.getKey()), parent));
            }
            catch (ClassCastException | NullPointerException e) {
                throw new SchemaException(obj, "Property descriptor " + (String)entry.getKey() + " should be a not null JsonObject", e);
            }
        }
        return parsedSchemas;
    }

    private Map<Pattern, SchemaInternal> parsePatternProperties(JsonObject obj, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        JsonPointer basePointer = scope.copy().append("patternProperties");
        HashMap<Pattern, SchemaInternal> parsedSchemas = new HashMap<Pattern, SchemaInternal>();
        for (Map.Entry entry : obj) {
            try {
                parsedSchemas.put(Pattern.compile((String)entry.getKey()), parser.parse(entry.getValue(), basePointer.copy().append((String)entry.getKey()), parent));
            }
            catch (PatternSyntaxException e) {
                throw new SchemaException(obj, "Invalid pattern for pattern keyword", e);
            }
            catch (ClassCastException | NullPointerException e) {
                throw new SchemaException(obj, "Property descriptor " + (String)entry.getKey() + " should be a not null JsonObject", e);
            }
        }
        return parsedSchemas;
    }

    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Map<Pattern, SchemaInternal> parsedPatternProperties;
            JsonObject properties = schema.getJsonObject("properties");
            JsonObject patternProperties = schema.getJsonObject("patternProperties");
            Object additionalProperties = schema.getValue("additionalProperties");
            PropertiesValidator validator = new PropertiesValidator(parent);
            Map<String, SchemaInternal> parsedProperties = properties != null ? this.parseProperties(properties, scope, parser, validator) : null;
            Map<Pattern, SchemaInternal> map = parsedPatternProperties = patternProperties != null ? this.parsePatternProperties(patternProperties, scope, parser, validator) : null;
            if (additionalProperties instanceof JsonObject) {
                validator.configure((Map<String, SchemaInternal>)parsedProperties, (Map<Pattern, SchemaInternal>)parsedPatternProperties, this.parseAdditionalProperties(additionalProperties, scope, parser, validator));
            } else if (additionalProperties instanceof Boolean) {
                validator.configure((Map<String, SchemaInternal>)parsedProperties, (Map<Pattern, SchemaInternal>)parsedPatternProperties, (Boolean)additionalProperties);
            } else {
                validator.configure((Map<String, SchemaInternal>)parsedProperties, (Map<Pattern, SchemaInternal>)parsedPatternProperties, true);
            }
            return validator;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for properties/patternProperties keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("properties") || schema.containsKey("patternProperties") || schema.containsKey("additionalProperties");
    }

    private Future<Void> fillAdditionalPropertyException(Throwable t, Object in) {
        return Future.failedFuture((Throwable)((Object)ValidationException.createException("additionalProperties schema should match", "additionalProperties", in, t)));
    }

    class PropertiesValidator
    extends BaseMutableStateValidator
    implements DefaultApplier {
        private Map<String, SchemaInternal> properties;
        private Map<Pattern, SchemaInternal> patternProperties;
        private boolean allowAdditionalProperties;
        private SchemaInternal additionalPropertiesSchema;

        public PropertiesValidator(MutableStateValidator parent) {
            super(parent);
        }

        private void configure(Map<String, SchemaInternal> properties, Map<Pattern, SchemaInternal> patternProperties, boolean allowAdditionalProperties) {
            this.properties = properties;
            this.patternProperties = patternProperties;
            this.allowAdditionalProperties = allowAdditionalProperties;
            this.additionalPropertiesSchema = null;
            this.initializeIsSync();
        }

        private void configure(Map<String, SchemaInternal> properties, Map<Pattern, SchemaInternal> patternProperties, SchemaInternal additionalPropertiesSchema) {
            this.properties = properties;
            this.patternProperties = patternProperties;
            this.allowAdditionalProperties = true;
            this.additionalPropertiesSchema = additionalPropertiesSchema;
            this.initializeIsSync();
        }

        @Override
        public boolean calculateIsSync() {
            Stream props = this.properties != null ? this.properties.values().stream().map(Schema::isSync) : Stream.empty();
            Stream patternProps = this.patternProperties != null ? this.patternProperties.values().stream().map(Schema::isSync) : Stream.empty();
            Stream additionalProps = this.additionalPropertiesSchema != null ? Stream.of(Boolean.valueOf(this.additionalPropertiesSchema.isSync())) : Stream.empty();
            return Stream.concat(props, Stream.concat(patternProps, additionalProps)).reduce(true, Boolean::logicalAnd);
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            if (in instanceof JsonObject) {
                JsonObject obj = (JsonObject)in;
                ArrayList<Object> futs = new ArrayList<Object>();
                for (String key : obj.fieldNames()) {
                    boolean found = false;
                    if (this.properties != null && this.properties.containsKey(key)) {
                        SchemaInternal s = this.properties.get(key);
                        context.markEvaluatedProperty(key);
                        if (s.isSync()) {
                            try {
                                s.validateSync(context.lowerLevelContext(), obj.getValue(key));
                            }
                            catch (ValidationException validationException) {
                                return Future.failedFuture((Throwable)((Object)validationException));
                            }
                        } else {
                            futs.add(s.validateAsync(context.lowerLevelContext(), obj.getValue(key)));
                        }
                        found = true;
                    }
                    if (this.patternProperties != null) {
                        for (Map.Entry entry : this.patternProperties.entrySet()) {
                            if (!((Pattern)entry.getKey()).matcher(key).find()) continue;
                            SchemaInternal s = (SchemaInternal)entry.getValue();
                            context.markEvaluatedProperty(key);
                            if (s.isSync()) {
                                try {
                                    s.validateSync(context.lowerLevelContext(), obj.getValue(key));
                                }
                                catch (ValidationException e) {
                                    return Future.failedFuture((Throwable)((Object)e));
                                }
                            } else {
                                futs.add(s.validateAsync(context.lowerLevelContext(), obj.getValue(key)));
                            }
                            found = true;
                        }
                    }
                    if (found) continue;
                    if (this.allowAdditionalProperties) {
                        if (this.additionalPropertiesSchema == null) continue;
                        context.markEvaluatedProperty(key);
                        if (this.additionalPropertiesSchema.isSync()) {
                            try {
                                this.additionalPropertiesSchema.validateSync(context.lowerLevelContext(), obj.getValue(key));
                                continue;
                            }
                            catch (ValidationException e) {
                                return PropertiesValidatorFactory.this.fillAdditionalPropertyException((Throwable)((Object)e), in);
                            }
                        }
                        futs.add(this.additionalPropertiesSchema.validateAsync(context.lowerLevelContext(), obj.getValue(key)).recover(t -> PropertiesValidatorFactory.this.fillAdditionalPropertyException(t, in)));
                        continue;
                    }
                    return Future.failedFuture((Throwable)((Object)ValidationException.createException("provided object should not contain additional properties", "additionalProperties", in)));
                }
                if (futs.isEmpty()) {
                    return Future.succeededFuture();
                }
                return CompositeFuture.all(futs).compose(cf -> Future.succeededFuture());
            }
            return Future.succeededFuture();
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            this.checkSync();
            if (in instanceof JsonObject) {
                JsonObject obj = (JsonObject)in;
                for (String key : obj.fieldNames()) {
                    boolean found = false;
                    if (this.properties != null && this.properties.containsKey(key)) {
                        SchemaInternal s = this.properties.get(key);
                        context.markEvaluatedProperty(key);
                        s.validateSync(context.lowerLevelContext(), obj.getValue(key));
                        found = true;
                    }
                    if (this.patternProperties != null) {
                        for (Map.Entry<Pattern, SchemaInternal> patternProperty : this.patternProperties.entrySet()) {
                            if (!patternProperty.getKey().matcher(key).find()) continue;
                            SchemaInternal s = patternProperty.getValue();
                            context.markEvaluatedProperty(key);
                            s.validateSync(context.lowerLevelContext(), obj.getValue(key));
                            found = true;
                        }
                    }
                    if (found) continue;
                    if (this.allowAdditionalProperties) {
                        if (this.additionalPropertiesSchema == null) continue;
                        context.markEvaluatedProperty(key);
                        this.additionalPropertiesSchema.validateSync(context.lowerLevelContext(), obj.getValue(key));
                        continue;
                    }
                    throw ValidationException.createException("provided object should not contain additional properties", "additionalProperties", in);
                }
            }
        }

        @Override
        public Future<Void> applyDefaultValue(Object value) {
            if (!(value instanceof JsonObject) || this.properties == null) {
                return Future.succeededFuture();
            }
            ArrayList<Object> futs = new ArrayList<Object>();
            JsonObject obj = (JsonObject)value;
            for (Map.Entry<String, SchemaInternal> e : this.properties.entrySet()) {
                String key = e.getKey();
                SchemaInternal schema = e.getValue();
                if (!obj.containsKey(key)) {
                    if (schema.isSync()) {
                        Object def2 = schema.getOrApplyDefaultSync(null);
                        if (def2 == null) continue;
                        obj.put(key, def2);
                        continue;
                    }
                    futs.add(schema.getOrApplyDefaultAsync(null).onSuccess(def -> {
                        if (def != null) {
                            obj.put(key, def);
                        }
                    }));
                    continue;
                }
                if (schema.isSync()) {
                    schema.getOrApplyDefaultSync(obj.getValue(key));
                    continue;
                }
                futs.add(schema.getOrApplyDefaultAsync(obj.getValue(key)));
            }
            if (futs.isEmpty()) {
                return Future.succeededFuture();
            }
            return CompositeFuture.all(futs).mapEmpty();
        }
    }
}

