/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.AsyncValidator;
import io.vertx.json.schema.common.BaseMutableStateValidator;
import io.vertx.json.schema.common.DefaultApplier;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.NoopValidatorContext;
import io.vertx.json.schema.common.PriorityGetter;
import io.vertx.json.schema.common.RecursiveAnchorValidatorContextDecorator;
import io.vertx.json.schema.common.RefSchema;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.SyncValidator;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorPriority;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class SchemaImpl
extends BaseMutableStateValidator
implements SchemaInternal {
    private static final Logger log = LoggerFactory.getLogger(SchemaImpl.class);
    private final JsonObject schema;
    private final JsonPointer scope;
    private Validator[] validators;
    protected boolean shouldRecordContext;
    final boolean recursiveAnchor;
    private final Set<RefSchema> referringSchemas;

    public SchemaImpl(JsonObject schema, JsonPointer scope, MutableStateValidator parent) {
        super(parent);
        this.schema = schema;
        this.scope = scope;
        this.shouldRecordContext = false;
        this.recursiveAnchor = schema.getBoolean("$recursiveAnchor", Boolean.valueOf(false));
        this.referringSchemas = new HashSet<RefSchema>();
    }

    @Override
    public Future<Void> validateAsync(Object json) {
        return this.validateAsync(NoopValidatorContext.getInstance(), json);
    }

    @Override
    public void validateSync(Object json) throws ValidationException, NoSyncValidationException {
        this.validateSync(NoopValidatorContext.getInstance(), json);
    }

    @Override
    public JsonPointer getScope() {
        return this.scope;
    }

    public JsonObject getJson() {
        return this.schema;
    }

    private Object getDefaultValue() {
        return this.schema.getValue("default");
    }

    @Override
    public Future<Object> getOrApplyDefaultAsync(Object input) {
        if (this.isSync()) {
            return Future.succeededFuture((Object)this.getOrApplyDefaultSync(input));
        }
        if (input == null) {
            return Future.succeededFuture((Object)this.getDefaultValue());
        }
        return CompositeFuture.all(Arrays.stream(this.validators).filter(v -> v instanceof DefaultApplier).map(v -> ((DefaultApplier)((Object)v)).applyDefaultValue(input)).collect(Collectors.toList())).map(input);
    }

    @Override
    public Object getOrApplyDefaultSync(Object input) {
        this.checkSync();
        if (input == null) {
            return this.getDefaultValue();
        }
        for (Validator v : this.validators) {
            if (!(v instanceof DefaultApplier)) continue;
            ((DefaultApplier)((Object)v)).applyDefaultValue(input);
        }
        return input;
    }

    @Override
    public void triggerUpdateIsSync() {
        boolean calculated = this.calculateIsSync();
        boolean previous = this.isSync;
        this.isSync = calculated;
        if (calculated != previous) {
            if (!this.referringSchemas.isEmpty()) {
                this.referringSchemas.forEach(r -> r.setIsSync(calculated));
            }
            if (this.getParent() != null) {
                this.getParent().triggerUpdateIsSync();
            }
        }
    }

    @Override
    public Future<Void> validateAsync(ValidatorContext context, Object in) {
        if (this.isSync()) {
            return this.validateSyncAsAsync(context, in);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Starting async validation for schema %s and input %s", this.schema, in));
        }
        context = this.generateValidationContext(context);
        return this.runAsyncValidators(context, in);
    }

    @Override
    public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
        this.checkSync();
        context = this.generateValidationContext(context);
        this.runSyncValidator(context, in);
    }

    @Override
    public boolean calculateIsSync() {
        return this.validators.length == 0 || Arrays.stream(this.validators).map(Validator::isSync).reduce(true, Boolean::logicalAnd) != false;
    }

    void setValidators(Set<Validator> validators) {
        this.shouldRecordContext = validators.stream().map(PriorityGetter::getPriority).anyMatch(p -> p == ValidatorPriority.CONTEXTUAL_VALIDATOR);
        this.validators = validators.toArray(new Validator[0]);
        Arrays.sort(this.validators, ValidatorPriority.COMPARATOR);
        this.initializeIsSync();
    }

    private Future<Void> fillException(Throwable e, Object in) {
        if (e instanceof ValidationException) {
            ValidationException ve = (ValidationException)((Object)e);
            ve.setSchema(this);
            ve.setScope(this.scope);
            return Future.failedFuture((Throwable)((Object)ve));
        }
        return Future.failedFuture((Throwable)((Object)ValidationException.createException("Error while validating", null, in, e)));
    }

    void registerReferredSchema(RefSchema ref) {
        this.referringSchemas.add(ref);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Ref schema %s reefers to schema %s", ref, this));
            log.trace((Object)String.format("Ref schemas that refeers to %s: %s", this, this.referringSchemas.size()));
        }
        this.referringSchemas.forEach(RefSchema::prePropagateSyncState);
        this.referringSchemas.forEach(r -> r.setIsSync(this.isSync));
    }

    protected ValidatorContext generateValidationContext(ValidatorContext parent) {
        ValidatorContext context;
        ValidatorContext validatorContext = context = this.shouldRecordContext ? parent.startRecording() : parent;
        if (this.recursiveAnchor) {
            return RecursiveAnchorValidatorContextDecorator.wrap(context, this.scope);
        }
        return context;
    }

    protected Future<Void> runAsyncValidators(ValidatorContext context, Object in) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (Validator validator : this.validators) {
            if (!validator.isSync()) {
                Future asyncValidate = ((AsyncValidator)validator).validateAsync(context, in);
                asyncValidate = asyncValidate.recover(t -> this.fillException((Throwable)t, in));
                futures.add(asyncValidate);
                continue;
            }
            try {
                ((SyncValidator)validator).validateSync(context, in);
            }
            catch (ValidationException e) {
                e.setSchema(this);
                e.setScope(this.scope);
                return Future.failedFuture((Throwable)((Object)e));
            }
        }
        if (!futures.isEmpty()) {
            return CompositeFuture.all(futures).compose(cf -> Future.succeededFuture());
        }
        return Future.succeededFuture();
    }

    protected void runSyncValidator(ValidatorContext context, Object in) {
        for (Validator validator : this.validators) {
            try {
                ((SyncValidator)validator).validateSync(context, in);
            }
            catch (ValidationException e) {
                e.setSchema(this);
                e.setScope(this.scope);
                throw e;
            }
        }
    }
}

