/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.pointer.JsonPointer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class URIUtils {
    public static URI removeFragment(URI oldURI) {
        return URIUtils.replaceFragment(oldURI, null);
    }

    public static URI replaceFragment(URI oldURI, String fragment) {
        try {
            if (oldURI != null) {
                return new URI(oldURI.getScheme(), oldURI.getSchemeSpecificPart(), fragment);
            }
            return new URI(null, null, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isRemoteURI(URI uri) {
        return "http".equals(uri.getScheme()) || "https".equals(uri.getScheme());
    }

    public static boolean isLocalURI(URI uri) {
        return "jar".equals(uri.getScheme()) || "file".equals(uri.getScheme());
    }

    public static URI resolvePath(URI oldURI, String path) {
        try {
            if ("jar".equals(oldURI.getScheme())) {
                String[] splittedJarURI = oldURI.getSchemeSpecificPart().split("!");
                String newInternalJarPath = URI.create(splittedJarURI[1]).resolve(path).toString();
                return new URI(oldURI.getScheme(), splittedJarURI[0] + "!" + newInternalJarPath, oldURI.getFragment());
            }
            if (path.isEmpty()) {
                return oldURI;
            }
            return oldURI.resolve(path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static JsonPointer createJsonPointerFromURI(URI original) {
        String frag = original.getFragment();
        if (frag != null && !frag.isEmpty() && frag.charAt(0) != '/') {
            frag = "/" + frag;
        }
        return JsonPointer.fromURI((URI)URIUtils.replaceFragment(original, frag));
    }

    public static URI requireAbsoluteUri(URI uri) {
        Objects.requireNonNull(uri);
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Provided uri should be absolute. Actual: " + uri.toString());
        }
        return uri;
    }

    public static URI requireAbsoluteUri(URI uri, String name) {
        Objects.requireNonNull(uri);
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Provided " + name + " uri should be absolute. Actual: " + uri.toString());
        }
        return uri;
    }
}

