/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.openapi3;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.common.AllOfValidatorFactory;
import io.vertx.json.schema.common.AnyOfValidatorFactory;
import io.vertx.json.schema.common.BaseSchemaParser;
import io.vertx.json.schema.common.DefinitionsValidatorFactory;
import io.vertx.json.schema.common.EnumValidatorFactory;
import io.vertx.json.schema.common.ItemsValidatorFactory;
import io.vertx.json.schema.common.MaxItemsValidatorFactory;
import io.vertx.json.schema.common.MaxLengthValidatorFactory;
import io.vertx.json.schema.common.MaxPropertiesValidatorFactory;
import io.vertx.json.schema.common.MinItemsValidatorFactory;
import io.vertx.json.schema.common.MinLengthValidatorFactory;
import io.vertx.json.schema.common.MinPropertiesValidatorFactory;
import io.vertx.json.schema.common.MultipleOfValidatorFactory;
import io.vertx.json.schema.common.NotValidatorFactory;
import io.vertx.json.schema.common.OneOfValidatorFactory;
import io.vertx.json.schema.common.PatternValidatorFactory;
import io.vertx.json.schema.common.PropertiesValidatorFactory;
import io.vertx.json.schema.common.RequiredValidatorFactory;
import io.vertx.json.schema.common.UniqueItemsValidatorFactory;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.json.schema.openapi3.FormatValidatorFactory;
import io.vertx.json.schema.openapi3.MaximumValidatorFactory;
import io.vertx.json.schema.openapi3.MinimumValidatorFactory;
import io.vertx.json.schema.openapi3.NullableValidatorFactory;
import io.vertx.json.schema.openapi3.TypeValidatorFactory;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;

public class OpenAPI3SchemaParser
extends BaseSchemaParser {
    protected OpenAPI3SchemaParser(SchemaRouter router) {
        super(router);
    }

    @Override
    protected List<ValidatorFactory> initValidatorFactories() {
        LinkedList<ValidatorFactory> factories = new LinkedList<ValidatorFactory>();
        factories.add(new DefinitionsValidatorFactory("definitions"));
        factories.add(new FormatValidatorFactory());
        factories.add(new MaximumValidatorFactory());
        factories.add(new MinimumValidatorFactory());
        factories.add(new NullableValidatorFactory());
        factories.add(new TypeValidatorFactory());
        factories.add(new AllOfValidatorFactory());
        factories.add(new AnyOfValidatorFactory());
        factories.add(new EnumValidatorFactory());
        factories.add(new ItemsValidatorFactory());
        factories.add(new MaxItemsValidatorFactory());
        factories.add(new MaxLengthValidatorFactory());
        factories.add(new MaxPropertiesValidatorFactory());
        factories.add(new MinItemsValidatorFactory());
        factories.add(new MinLengthValidatorFactory());
        factories.add(new MinPropertiesValidatorFactory());
        factories.add(new MultipleOfValidatorFactory());
        factories.add(new NotValidatorFactory());
        factories.add(new OneOfValidatorFactory());
        factories.add(new PatternValidatorFactory());
        factories.add(new PropertiesValidatorFactory());
        factories.add(new RequiredValidatorFactory());
        factories.add(new UniqueItemsValidatorFactory());
        return factories;
    }

    public static OpenAPI3SchemaParser create(SchemaRouter router) {
        return new OpenAPI3SchemaParser(router);
    }

    public static Schema parse(Vertx vertx, JsonObject schema, URI scope) {
        return new OpenAPI3SchemaParser(SchemaRouter.create(vertx, new SchemaRouterOptions())).parse((Object)schema, scope, null);
    }
}

