/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.common.BaseFormatValidatorFactory;
import io.vertx.json.schema.common.FalseSchema;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.RefSchema;
import io.vertx.json.schema.common.SchemaImpl;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.TrueSchema;
import io.vertx.json.schema.common.URIUtils;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorFactory;
import java.net.URI;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class BaseSchemaParser
implements SchemaParserInternal {
    protected final List<ValidatorFactory> validatorFactories;
    protected final SchemaRouter router;

    protected BaseSchemaParser(SchemaRouter router) {
        this.router = router;
        this.validatorFactories = this.initValidatorFactories();
    }

    @Override
    public SchemaRouter getSchemaRouter() {
        return this.router;
    }

    @Override
    public SchemaInternal parse(Object jsonSchema, JsonPointer scope, MutableStateValidator parent) {
        if (jsonSchema instanceof Map) {
            jsonSchema = new JsonObject((Map)jsonSchema);
        }
        if (jsonSchema instanceof JsonObject) {
            JsonObject json = (JsonObject)jsonSchema;
            HashSet<Validator> validators = new HashSet<Validator>();
            Map.Entry<Optional<JsonPointer>, Optional<String>> e = this.resolveIdAndAlias(json, scope.getURIWithoutFragment());
            SchemaImpl s = e.getKey().map(id -> this.createSchema(json, (JsonPointer)id, parent)).orElseGet(() -> this.createSchema(json, scope, parent));
            if (e.getKey().isPresent()) {
                this.router.addSchema(s, scope);
            } else {
                this.router.addSchema(s, new JsonPointer[0]);
            }
            e.getValue().ifPresent(alias -> this.router.addSchemaAlias(s, (String)alias));
            for (ValidatorFactory factory : this.validatorFactories) {
                Validator v;
                if (!factory.canConsumeSchema(json) || (v = factory.createValidator(json, e.getKey().orElse(scope).copy(), this, s)) == null) continue;
                validators.add(v);
            }
            s.setValidators(validators);
            return s;
        }
        if (jsonSchema instanceof Boolean) {
            SchemaInternal s = (Boolean)jsonSchema != false ? TrueSchema.getInstance() : FalseSchema.getInstance();
            this.router.addSchemaWithScope(s, scope);
            return s;
        }
        throw new SchemaException(jsonSchema, "Schema must be a JsonObject or a Boolean");
    }

    protected SchemaImpl createSchema(JsonObject schema, JsonPointer scope, MutableStateValidator parent) {
        if (schema.containsKey("$ref")) {
            return new RefSchema(schema, scope, this, parent, false);
        }
        return new SchemaImpl(schema, scope, parent);
    }

    protected abstract List<ValidatorFactory> initValidatorFactories();

    protected Map.Entry<Optional<JsonPointer>, Optional<String>> resolveIdAndAlias(JsonObject schema, URI scope) {
        Optional<Object> id = Optional.empty();
        Optional<Object> alias = Optional.empty();
        if (schema.containsKey("$id")) {
            URI originalId = URI.create(schema.getString("$id"));
            URI idWithoutFragment = URIUtils.removeFragment(originalId);
            if (originalId.isAbsolute()) {
                id = Optional.of(JsonPointer.fromURI((URI)idWithoutFragment));
            } else if (originalId.getPath() != null && !originalId.getPath().isEmpty()) {
                id = Optional.of(JsonPointer.fromURI((URI)URIUtils.resolvePath(scope, idWithoutFragment.getPath())));
            }
            if (originalId.getFragment() != null && !originalId.getFragment().isEmpty()) {
                alias = Optional.of(originalId.getFragment());
            }
        }
        return new AbstractMap.SimpleImmutableEntry<Optional<JsonPointer>, Optional<String>>(id, alias);
    }

    @Override
    public BaseSchemaParser withValidatorFactory(ValidatorFactory factory) {
        this.validatorFactories.add(factory);
        return this;
    }

    @Override
    public BaseSchemaParser withStringFormatValidator(String formatName, Predicate<String> predicate) {
        BaseFormatValidatorFactory f = (BaseFormatValidatorFactory)this.validatorFactories.stream().filter(factory -> factory instanceof BaseFormatValidatorFactory).findFirst().orElseThrow(() -> new IllegalStateException("This json schema version doesn't support format keyword"));
        f.addStringFormatValidator(formatName, predicate);
        return this;
    }

    @Override
    public SchemaInternal parseFromString(String unparsedJson, JsonPointer scope, MutableStateValidator parent) {
        return this.parse(Json.decodeValue((String)unparsedJson.trim()), scope, parent);
    }
}

