/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;

public class MinLengthValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Number minimum = (Number)schema.getValue("minLength");
            if (minimum.intValue() < 0) {
                throw new SchemaException(schema, "minLength must be >= 0");
            }
            return new MinLengthValidator(minimum.intValue());
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for minLength keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null minLength keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("minLength");
    }

    public static class MinLengthValidator
    extends BaseSyncValidator {
        private final int minimum;

        public MinLengthValidator(int minimum) {
            this.minimum = minimum;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            if (in instanceof String && ((String)in).codePointCount(0, ((String)in).length()) < this.minimum) {
                throw ValidationException.create("provided string should have size >= " + this.minimum, "minLength", in);
            }
        }
    }
}

