/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.VertxException;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.common.ValidationExceptionImpl;
import java.util.Collection;

public abstract class ValidationException
extends VertxException {
    private final String keyword;
    private final Object input;
    protected Schema schema;
    protected JsonPointer inputScope;

    protected ValidationException(String message, String keyword, Object input) {
        this(message, null, keyword, input);
    }

    protected ValidationException(String message, Throwable cause, String keyword, Object input) {
        super(message, cause);
        this.keyword = keyword;
        this.input = input;
    }

    @Deprecated
    public static ValidationException createException(String message, String keyword, Object input, Collection<Throwable> causes) {
        return new ValidationExceptionImpl(message, causes, keyword, input);
    }

    @Deprecated
    public static ValidationException createException(String message, String keyword, Object input, Throwable cause) {
        return new ValidationExceptionImpl(message, cause, keyword, input);
    }

    @Deprecated
    public static ValidationException createException(String message, String keyword, Object input) {
        return new ValidationExceptionImpl(message, keyword, input);
    }

    public static ValidationException create(String message, String keyword, Object input, Collection<Throwable> causes) {
        return new ValidationExceptionImpl(message, causes, keyword, input);
    }

    public static ValidationException create(String message, String keyword, Object input, Throwable cause) {
        return new ValidationExceptionImpl(message, cause, keyword, input);
    }

    public static ValidationException create(String message, String keyword, Object input) {
        return new ValidationExceptionImpl(message, keyword, input);
    }

    public @Nullable String keyword() {
        return this.keyword;
    }

    public Object input() {
        return this.input;
    }

    public Schema schema() {
        return this.schema;
    }

    @Deprecated
    public JsonPointer scope() {
        return this.schema.getScope();
    }

    public JsonPointer inputScope() {
        return this.inputScope;
    }

    public String toString() {
        return "ValidationException{message='" + this.getMessage() + '\'' + ", keyword='" + this.keyword + '\'' + ", input=" + this.input + ", schema=" + this.schema + (this.inputScope != null ? ", inputScope=" + this.inputScope.toURI() : "") + '}';
    }
}

