/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.impl.URL;
import io.vertx.json.schema.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class Ref {
    private static final Logger LOG = LoggerFactory.getLogger(Ref.class);
    private static final int RESOLVE_LIMIT = Integer.getInteger("io.vertx.json.schema.resolve.limit", 50);
    public static final List<String> POINTER_KEYWORD = Arrays.asList("$ref", "$id", "$anchor", "$dynamicRef", "$dynamicAnchor", "$schema");
    final String ref;
    final JsonObject obj;
    final String prop;
    final String path;
    final String id;

    Ref(String ref, JsonObject obj, String prop, String path, String id) {
        this.ref = ref;
        this.obj = obj;
        this.prop = prop;
        this.path = path;
        this.id = id;
    }

    public static JsonObject resolve(Map<String, JsonSchema> refs, URL baseUri, JsonSchema schema) {
        return Ref.resolve(refs, baseUri, schema, RESOLVE_LIMIT);
    }

    private static JsonObject resolve(Map<String, JsonSchema> refs, URL baseUri, JsonSchema schema, int limit) {
        JsonObject obj;
        String prop;
        String ref;
        if (limit == 0) {
            throw new RuntimeException("Too much recursion resolving schema");
        }
        JsonObject tree = ((JsonObject)schema).copy();
        HashMap<String, List<Ref>> pointers = new HashMap<String, List<Ref>>();
        Ref.findRefsAndClean(tree, "#", "", pointers, limit);
        HashMap<String, JsonObject> anchors = new HashMap<String, JsonObject>();
        anchors.put("", tree);
        JsonObject dynamicAnchors = new JsonObject();
        boolean incomplete = false;
        pointers.computeIfAbsent("$id", key -> Collections.emptyList()).forEach(item -> {
            String ref = item.ref;
            String path = item.path;
            JsonObject obj = item.obj;
            if (anchors.containsKey(ref)) {
                throw new SchemaException(schema, "$id: '" + ref + "' defined more than once at: " + path);
            }
            anchors.put(ref, obj);
        });
        pointers.computeIfAbsent("$anchor", key -> Collections.emptyList()).forEach(item -> {
            String ref = item.ref;
            String path = item.path;
            JsonObject obj = item.obj;
            String id = item.id;
            String fullRef = id + "#" + ref;
            if (anchors.containsKey(fullRef)) {
                throw new SchemaException(schema, "$anchor: '" + ref + "' defined more than once at: " + path);
            }
            anchors.put(fullRef, obj);
        });
        pointers.computeIfAbsent("$dynamicAnchor", key -> Collections.emptyList()).forEach(item -> {
            String ref = item.ref;
            String path = item.path;
            JsonObject obj = item.obj;
            if (dynamicAnchors.containsKey("#" + ref)) {
                throw new SchemaException(schema, "$dynamicAnchor: '" + ref + "' defined more than once at: " + path);
            }
            dynamicAnchors.put("#" + ref, (Object)obj);
        });
        HashMap<String, JsonObject> dejaVu = new HashMap<String, JsonObject>();
        for (Ref item2 : pointers.computeIfAbsent("$ref", key -> Collections.emptyList())) {
            ref = item2.ref;
            prop = item2.prop;
            obj = item2.obj;
            String id = item2.id;
            String decodedRef = URIDecoder.decodeURIComponent((String)ref);
            String fullRef = decodedRef.charAt(0) != '#' ? decodedRef : id + decodedRef;
            JsonObject resolved = dejaVu.computeIfAbsent(fullRef, key -> Ref.resolveUri(refs, baseUri, schema, key, anchors, limit));
            incomplete |= Ref.hasPointers(schema, resolved, fullRef, limit);
            obj.remove(prop);
            obj.mergeIn(new JsonObject(resolved.stream().filter(kv -> !POINTER_KEYWORD.contains(kv.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        }
        for (Ref item2 : pointers.computeIfAbsent("$dynamicRef", key -> Collections.emptyList())) {
            ref = item2.ref;
            prop = item2.prop;
            obj = item2.obj;
            if (!dynamicAnchors.containsKey(ref)) {
                throw new SchemaException(schema, "Can't resolve $dynamicAnchor: '" + ref + "'");
            }
            JsonObject resolved = dynamicAnchors.getJsonObject(ref);
            incomplete |= Ref.hasPointers(schema, resolved, ref, limit);
            obj.remove(prop);
            obj.mergeIn(new JsonObject(resolved.stream().filter(kv -> !POINTER_KEYWORD.contains(kv.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (incomplete) {
            return Ref.resolve(refs, baseUri, JsonSchema.of(tree), limit - 1);
        }
        return tree;
    }

    private static void findRefsAndClean(Object obj, String path, String id, Map<String, List<Ref>> pointers, int limit) {
        JsonArray json;
        if (limit == 0) {
            throw new RuntimeException("Too much recursion resolving schema");
        }
        if (!Utils.Objects.isObject(obj)) {
            return;
        }
        if (obj instanceof JsonArray) {
            json = (JsonArray)obj;
            for (int i = 0; i < json.size(); ++i) {
                Ref.findRefsAndClean(json.getValue(i), path + "/" + i, id, pointers, limit - 1);
            }
        }
        if (obj instanceof JsonObject) {
            json = (JsonObject)obj;
            json.remove("__absolute_uri__");
            json.remove("__absolute_ref__");
            json.remove("__absolute_recursive_ref__");
            if (json.containsKey("$id")) {
                id = json.getString("$id");
            }
            for (String prop : json.fieldNames()) {
                if (POINTER_KEYWORD.contains(prop)) {
                    pointers.computeIfAbsent(prop, key -> new ArrayList()).add(new Ref(json.getString(prop), (JsonObject)json, prop, path, id));
                }
                Ref.findRefsAndClean(json.getValue(prop), path + "/" + Utils.Pointers.encode(prop), id, pointers, limit - 1);
            }
        }
    }

    private static boolean hasPointers(JsonSchema schema, Object obj, String self, int limit) {
        JsonArray json;
        if (limit == 0) {
            throw new RuntimeException("Too much recursion resolving schema");
        }
        if (!Utils.Objects.isObject(obj)) {
            return false;
        }
        if (obj instanceof JsonArray) {
            json = (JsonArray)obj;
            for (int i = 0; i < json.size(); ++i) {
                if (!Ref.hasPointers(schema, json.getValue(i), self, limit - 1)) continue;
                return true;
            }
        }
        if (obj instanceof JsonObject) {
            json = (JsonObject)obj;
            for (String prop : json.fieldNames()) {
                if (POINTER_KEYWORD.contains(prop)) {
                    if (json.getString(prop).equals(self)) {
                        LOG.debug((Object)("Circular pointer detected: '" + self + "' in schema: " + schema));
                        return false;
                    }
                    return true;
                }
                if (!Ref.hasPointers(schema, json.getValue(prop), self, limit - 1)) continue;
                return true;
            }
        }
        return false;
    }

    private static JsonObject resolveUri(Map<String, JsonSchema> refs, URL baseUri, JsonSchema schema, String uri, Map<String, JsonObject> anchors, int limit) {
        String path;
        String[] parts = uri.split("#", 2);
        boolean hashPresent = parts.length == 2 && parts[1] != null;
        String prefix = parts[0];
        String string = path = hashPresent ? parts[1] : null;
        if (hashPresent && path.charAt(0) != '/') {
            if (anchors.containsKey(uri)) {
                return anchors.get(uri);
            }
            throw new SchemaException(schema, "Can't resolve '" + uri + "', only internal refs are supported.");
        }
        if (!anchors.containsKey(prefix)) {
            String resolved;
            if (!refs.isEmpty() && refs.containsKey(resolved = new URL(prefix, baseUri).href())) {
                if (!hashPresent) {
                    return Ref.resolve(refs, baseUri, refs.get(resolved), limit - 1);
                }
                return Ref.reduce(schema, path, Ref.resolve(refs, baseUri, refs.get(resolved), limit - 1));
            }
            throw new SchemaException(schema, "Can't resolve '" + uri + "', only internal refs are supported.");
        }
        if (!hashPresent) {
            return anchors.get(prefix);
        }
        return Ref.reduce(schema, path, anchors.get(prefix));
    }

    private static JsonObject reduce(JsonSchema schema, String path, JsonObject value) {
        String[] paths = path.split("/");
        for (int i = 1; i < paths.length; ++i) {
            if ((value = value.getJsonObject(Utils.Pointers.unescape(paths[i]))) != null) continue;
            throw new SchemaException(schema, "Can't reduce [" + i + "] '" + path + "', value is null.");
        }
        return value.copy();
    }
}

