/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.OutputFormat;
import io.vertx.json.schema.OutputUnit;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.impl.BooleanSchema;
import io.vertx.json.schema.impl.Format;
import io.vertx.json.schema.impl.SchemaRepositoryImpl;
import io.vertx.json.schema.impl.SchemaValidatorInternal;
import io.vertx.json.schema.impl.URL;
import io.vertx.json.schema.impl.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class SchemaValidatorImpl
implements SchemaValidatorInternal {
    private final Map<String, JsonSchema> lookup;
    private final JsonSchema schema;
    private final Draft draft;
    private final OutputFormat outputFormat;

    public SchemaValidatorImpl(JsonSchema schema, JsonSchemaOptions options, Map<String, JsonSchema> lookup) {
        Objects.requireNonNull(schema, "'schema' cannot be null");
        Objects.requireNonNull(options, "'options' cannot be null");
        Objects.requireNonNull(options.getOutputFormat(), "'options.outputFormat' cannot be null");
        Objects.requireNonNull(options.getBaseUri(), "'options.baseUri' cannot be null");
        Objects.requireNonNull(options, "'lookup' cannot be null");
        this.schema = schema;
        this.draft = options.getDraft() == null ? Draft.fromIdentifier((String)schema.get("$schema")) : options.getDraft();
        this.outputFormat = options.getOutputFormat();
        URL baseUri = new URL(options.getBaseUri());
        this.lookup = new HashMap<String, JsonSchema>(lookup);
        SchemaRepositoryImpl.dereference(this.lookup, schema, baseUri, "", true);
    }

    public SchemaValidatorImpl(String ref, JsonSchemaOptions options, Map<String, JsonSchema> lookup) {
        Objects.requireNonNull(ref, "'ref' cannot be null");
        Objects.requireNonNull(options, "'options' cannot be null");
        Objects.requireNonNull(options.getOutputFormat(), "'options.outputFormat' cannot be null");
        Objects.requireNonNull(options.getBaseUri(), "'options.baseUri' cannot be null");
        Objects.requireNonNull(options, "'lookup' cannot be null");
        this.schema = lookup.get(ref);
        this.draft = options.getDraft() == null ? Draft.fromIdentifier((String)this.schema.get("$schema")) : options.getDraft();
        this.outputFormat = options.getOutputFormat();
        this.lookup = lookup;
    }

    @Override
    public JsonSchema schema() {
        return this.schema;
    }

    @Override
    public OutputUnit validate(Object instance) throws SchemaException {
        return this.validate(instance, this.schema, null, "#", "#", "#", new HashSet<Object>());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private OutputUnit validate(Object _instance, JsonSchema schema, JsonSchema _recursiveAnchor, String instanceLocation, String schemaLocation, String baseLocation, Set<Object> evaluated) throws SchemaException {
        ArrayList arrayList;
        ArrayList annotations;
        List<OutputUnit> errors;
        block146: {
            void var17_54;
            boolean stop;
            int length;
            JsonSchema recursiveAnchor;
            Object instance;
            block151: {
                OutputUnit result;
                block145: {
                    void var17_52;
                    block152: {
                        Object result2;
                        String subInstancePointer;
                        String key3;
                        Object propsOrSchema;
                        block155: {
                            boolean stop2;
                            HashSet<String> hashSet;
                            block154: {
                                block153: {
                                    String instanceType;
                                    block149: {
                                        OutputUnit elseResult;
                                        block150: {
                                            OutputUnit thenResult;
                                            OutputUnit result3;
                                            OutputUnit result4;
                                            int i;
                                            block148: {
                                                block147: {
                                                    if (schema instanceof BooleanSchema) {
                                                        if (schema != BooleanSchema.TRUE) return new OutputUnit(false);
                                                        return new OutputUnit(true);
                                                    }
                                                    instance = Utils.JSON.jsonify(_instance);
                                                    instanceType = Utils.JSON.typeOf(instance);
                                                    errors = new ArrayList<OutputUnit>();
                                                    annotations = new ArrayList();
                                                    if (schema.get("$recursiveAnchor", false).booleanValue() && _recursiveAnchor == null) {
                                                        _recursiveAnchor = schema;
                                                    }
                                                    recursiveAnchor = _recursiveAnchor;
                                                    if ("#".equals(schema.get("$recursiveRef"))) {
                                                        JsonSchema refSchema;
                                                        assert (schema.containsKey("__absolute_recursive_ref__"));
                                                        OutputUnit result5 = this.validate(instance, recursiveAnchor == null ? schema : recursiveAnchor, refSchema = recursiveAnchor == null ? this.lookup.get(schema.get("__absolute_recursive_ref__")) : recursiveAnchor, instanceLocation, schemaLocation + "/$recursiveRef", baseLocation + "/$recursiveRef", evaluated);
                                                        if (!result5.getValid().booleanValue()) {
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/$recursiveRef"), baseLocation + "/$recursiveRef", "A sub-schema had errors"));
                                                            if (result5.getErrors() != null) {
                                                                errors.addAll(result5.getErrors());
                                                            }
                                                        }
                                                    }
                                                    if (schema.containsKey("$ref")) {
                                                        String uri = (String)schema.get("__absolute_ref__", schema.get("$ref"));
                                                        if (!this.lookup.containsKey(uri)) {
                                                            String message = "Unresolved $ref " + (String)schema.get("$ref");
                                                            if (schema.containsKey("__absolute_ref__") && !schema.get("__absolute_ref__").equals(schema.get("$ref"))) {
                                                                message = message + ": Absolute URI " + schema.get("__absolute_ref__");
                                                            }
                                                            message = message + "\nKnown schemas:\n- " + String.join((CharSequence)"\n- ", this.lookup.keySet());
                                                            throw new SchemaException(schema, message);
                                                        }
                                                        JsonSchema refSchema = this.lookup.get(uri);
                                                        OutputUnit result6 = this.validate(instance, refSchema, recursiveAnchor, instanceLocation, (String)schema.get("$ref"), baseLocation + "/$ref", evaluated);
                                                        if (!result6.getValid().booleanValue()) {
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/$ref"), baseLocation + "/$ref", "A subschema had errors"));
                                                            if (result6.getErrors() != null) {
                                                                errors.addAll(result6.getErrors());
                                                            }
                                                        }
                                                        if (this.draft == Draft.DRAFT4 || this.draft == Draft.DRAFT7) {
                                                            List<OutputUnit> list;
                                                            OutputUnit outputUnit = new OutputUnit(errors.isEmpty());
                                                            if (this.outputFormat == OutputFormat.Flag) {
                                                                list = null;
                                                                return outputUnit.setErrors(list);
                                                            }
                                                            if (errors.isEmpty()) {
                                                                list = null;
                                                                return outputUnit.setErrors(list);
                                                            }
                                                            list = errors;
                                                            return outputUnit.setErrors(list);
                                                        }
                                                    }
                                                    if (schema.get("type") instanceof JsonArray) break block147;
                                                    if ("integer".equals(schema.get("type"))) {
                                                        if (!"number".equals(instanceType) || !Utils.Numbers.isInteger(instance)) {
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/type"), baseLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + schema.get("type")));
                                                        }
                                                        break block148;
                                                    } else if (schema.containsKey("type") && !instanceType.equals(schema.get("type"))) {
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/type"), baseLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + schema.get("type")));
                                                    }
                                                    break block148;
                                                }
                                                JsonArray type = (JsonArray)schema.get("type");
                                                int length2 = type.size();
                                                boolean valid = false;
                                                for (i = 0; i < length2; ++i) {
                                                    if (!instanceType.equals(type.getString(i)) && (!"integer".equals(type.getString(i)) || !"number".equals(instanceType) || !Utils.Numbers.isInteger(instance))) continue;
                                                    valid = true;
                                                    break;
                                                }
                                                if (!valid) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/type"), baseLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + String.join((CharSequence)", ", type.getList())));
                                                }
                                            }
                                            if (schema.containsKey("const")) {
                                                if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                    if (!Utils.JSON.deepCompare(instance, schema.get("const"))) {
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/const"), baseLocation + "/const", "Instance does not match " + Json.encode(schema.get("const"))));
                                                    }
                                                } else if (!Utils.Objects.equals(schema.get("const"), instance)) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/const"), baseLocation + "/const", "Instance does not match " + Json.encode(schema.get("const"))));
                                                }
                                            }
                                            if (schema.containsKey("enum")) {
                                                if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                    if (((JsonArray)schema.get("enum")).stream().noneMatch(value -> Utils.JSON.deepCompare(instance, value))) {
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/enum"), baseLocation + "/enum", "Instance does not match any of " + Json.encode(schema.get("enum"))));
                                                    }
                                                } else if (((JsonArray)schema.get("enum")).stream().noneMatch(value -> Utils.Objects.equals(instance, value))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/enum"), baseLocation + "/enum", "Instance does not match any of " + Json.encode(schema.get("enum"))));
                                                }
                                            }
                                            if (schema.containsKey("not") && (result4 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "not"), recursiveAnchor, instanceLocation, schemaLocation + "/not", baseLocation + "/not", new HashSet<Object>())).getValid().booleanValue()) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/not"), baseLocation + "/not", "Instance matched \"not\" schema"));
                                            }
                                            HashSet<Object> subEvaluateds = new HashSet<Object>();
                                            if (schema.containsKey("anyOf")) {
                                                int errorsLength = errors.size();
                                                boolean anyValid = false;
                                                for (i = 0; i < ((JsonArray)schema.get("anyOf")).size(); ++i) {
                                                    HashSet<Object> hashSet2 = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("anyOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, schemaLocation + "/anyOf/" + i, baseLocation + "/anyOf/" + i, hashSet2);
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    boolean bl = anyValid = anyValid || result3.getValid() != false;
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    subEvaluateds.addAll(hashSet2);
                                                }
                                                if (anyValid) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/anyOf"), baseLocation + "/anyOf", "Instance does not match any subschemas"));
                                                }
                                            }
                                            if (schema.containsKey("allOf")) {
                                                int errorsLength = errors.size();
                                                boolean allValid = true;
                                                for (i = 0; i < ((JsonArray)schema.get("allOf")).size(); ++i) {
                                                    HashSet<Object> hashSet3 = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("allOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, schemaLocation + "/allOf/" + i, baseLocation + "/allOf/" + i, hashSet3);
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    boolean bl = allValid = allValid && result3.getValid() != false;
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    subEvaluateds.addAll(hashSet3);
                                                }
                                                if (allValid) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/allOf"), baseLocation + "/allOf", "Instance does not match every subschema"));
                                                }
                                            }
                                            if (schema.containsKey("oneOf")) {
                                                int errorsLength = errors.size();
                                                int matches = 0;
                                                for (i = 0; i < ((JsonArray)schema.get("oneOf")).size(); ++i) {
                                                    HashSet<Object> hashSet4 = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("oneOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, schemaLocation + "/oneOf/" + i, baseLocation + "/oneOf/" + i, hashSet4);
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    if (result3.getValid().booleanValue()) {
                                                        subEvaluateds.addAll(hashSet4);
                                                    }
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    ++matches;
                                                }
                                                if (matches == 1) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/oneOf"), baseLocation + "/oneOf", "Instance does not match exactly one subschema (" + matches + " matches)"));
                                                }
                                            }
                                            if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                evaluated.addAll(subEvaluateds);
                                            }
                                            if (!schema.containsKey("if")) break block149;
                                            OutputUnit conditionResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "if"), recursiveAnchor, instanceLocation, schemaLocation + "/if", baseLocation + "/if", evaluated);
                                            if (!conditionResult.getValid().booleanValue()) break block150;
                                            if (schema.containsKey("then") && !(thenResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "then"), recursiveAnchor, instanceLocation, schemaLocation + "/then", baseLocation + "/then", evaluated)).getValid().booleanValue()) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/if"), baseLocation + "/if", "Instance does not match \"then\" schema"));
                                                if (thenResult.getErrors() != null) {
                                                    errors.addAll(thenResult.getErrors());
                                                }
                                            }
                                            break block149;
                                        }
                                        if (schema.containsKey("else") && !(elseResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "else"), recursiveAnchor, instanceLocation, schemaLocation + "/else", baseLocation + "/else", evaluated)).getValid().booleanValue()) {
                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/else"), baseLocation + "/else", "Instance does not match \"else\" schema"));
                                            if (elseResult.getErrors() != null) {
                                                errors.addAll(elseResult.getErrors());
                                            }
                                        }
                                    }
                                    switch (instanceType) {
                                        case "object": {
                                            Object result7;
                                            if (schema.containsKey("required")) {
                                                for (Object e : (JsonArray)schema.get("required")) {
                                                    if (((JsonObject)instance).containsKey((String)e)) continue;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/required"), baseLocation + "/required", "Instance does not have required property \"" + e + "\""));
                                                }
                                            }
                                            Set keys = ((JsonObject)instance).fieldNames();
                                            if (schema.containsKey("minProperties") && keys.size() < (Integer)schema.get("minProperties")) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minProperties"), baseLocation + "/minProperties", "Instance does not have at least " + schema.get("minProperties") + " properties"));
                                            }
                                            if (schema.containsKey("maxProperties") && keys.size() > (Integer)schema.get("maxProperties")) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maxProperties"), baseLocation + "/maxProperties", "Instance does not have at least " + schema.get("maxProperties") + " properties"));
                                            }
                                            if (schema.containsKey("propertyNames")) {
                                                for (String key2 : ((JsonObject)instance).fieldNames()) {
                                                    String subInstancePointer2 = instanceLocation + "/" + Utils.Pointers.encode(key2);
                                                    result7 = this.validate(key2, Utils.Schemas.wrap((JsonObject)schema, "propertyNames"), recursiveAnchor, subInstancePointer2, schemaLocation + "/propertyNames", baseLocation + "/propertyNames", new HashSet<Object>());
                                                    if (((OutputUnit)result7).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/propertyNames"), baseLocation + "/propertyNames", "Property name \"" + key2 + "\" does not match schema"));
                                                    if (((OutputUnit)result7).getErrors() == null) continue;
                                                    errors.addAll(((OutputUnit)result7).getErrors());
                                                }
                                            }
                                            if (schema.containsKey("dependentRequired")) {
                                                for (String key2 : ((JsonObject)schema.get("dependentRequired")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key2)) continue;
                                                    JsonArray required = ((JsonObject)schema.get("dependentRequired")).getJsonArray(key2);
                                                    for (Object dependantKey : required) {
                                                        if (((JsonObject)instance).containsKey((String)dependantKey)) continue;
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/dependentRequired"), baseLocation + "/dependentRequired", "Instance has \"" + key2 + "\" but does not have \"" + dependantKey + "\""));
                                                    }
                                                }
                                            }
                                            if (schema.containsKey("dependentSchemas")) {
                                                for (String key2 : ((JsonObject)schema.get("dependentSchemas")).fieldNames()) {
                                                    OutputUnit result8;
                                                    if (!((JsonObject)instance).containsKey(key2) || (result8 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema.get("dependentSchemas"), key2), recursiveAnchor, instanceLocation, schemaLocation + "/dependentSchemas/" + Utils.Pointers.encode(key2), baseLocation + "/dependentSchemas/" + Utils.Pointers.encode(key2), evaluated)).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/dependentSchemas"), baseLocation + "/dependentSchemas", "Instance has \"" + key2 + "\" but does not match dependant schema"));
                                                    if (result8.getErrors() == null) continue;
                                                    errors.addAll(result8.getErrors());
                                                }
                                            }
                                            if (schema.containsKey("dependencies")) {
                                                for (String key2 : ((JsonObject)schema.get("dependencies")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key2)) continue;
                                                    propsOrSchema = ((JsonObject)schema.get("dependencies")).getValue(key2);
                                                    if (propsOrSchema instanceof JsonArray) {
                                                        for (Object dependantKey : (JsonArray)propsOrSchema) {
                                                            if (((JsonObject)instance).containsKey((String)dependantKey)) continue;
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/dependencies"), baseLocation + "/dependencies", "Instance has \"" + key2 + "\" but does not have \"" + dependantKey + "\""));
                                                        }
                                                        continue;
                                                    }
                                                    result7 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema.get("dependencies"), key2), recursiveAnchor, instanceLocation, schemaLocation + "/dependencies/" + Utils.Pointers.encode(key2), baseLocation + "/dependencies/" + Utils.Pointers.encode(key2), new HashSet<Object>());
                                                    if (((OutputUnit)result7).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/dependencies"), baseLocation + "/dependencies", "Instance has \"" + key2 + "\" but does not match dependant schema"));
                                                    if (((OutputUnit)result7).getErrors() == null) continue;
                                                    errors.addAll(((OutputUnit)result7).getErrors());
                                                }
                                            }
                                            hashSet = new HashSet<String>();
                                            stop2 = false;
                                            if (schema.containsKey("properties")) {
                                                for (String key3 : ((JsonObject)schema.get("properties")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key3)) continue;
                                                    subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key3);
                                                    result2 = this.validate(((JsonObject)instance).getValue(key3), Utils.Schemas.wrap((JsonObject)schema.get("properties"), key3), recursiveAnchor, subInstancePointer, schemaLocation + "/properties/" + Utils.Pointers.encode(key3), baseLocation + "/properties/" + Utils.Pointers.encode(key3), new HashSet<Object>());
                                                    if (((OutputUnit)result2).getValid().booleanValue()) {
                                                        evaluated.add(key3);
                                                        hashSet.add(key3);
                                                        continue;
                                                    }
                                                    stop2 = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(subInstancePointer, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/properties"), baseLocation + "/properties", "Property \"" + key3 + "\" does not match schema"));
                                                    if (((OutputUnit)result2).getErrors() != null) {
                                                        errors.addAll(((OutputUnit)result2).getErrors());
                                                    }
                                                    if (!stop2) continue;
                                                }
                                            }
                                            if (stop2 || !schema.containsKey("patternProperties")) break;
                                            for (String pattern : ((JsonObject)schema.get("patternProperties")).fieldNames()) {
                                                Pattern regex = Pattern.compile(pattern);
                                                for (String key4 : ((JsonObject)instance).fieldNames()) {
                                                    if (!regex.matcher(key4).find()) continue;
                                                    String subInstancePointer3 = instanceLocation + "/" + Utils.Pointers.encode(key4);
                                                    OutputUnit result9 = this.validate(((JsonObject)instance).getValue(key4), Utils.Schemas.wrap((JsonObject)schema.get("patternProperties"), pattern), recursiveAnchor, subInstancePointer3, schemaLocation + "/patternProperties/" + Utils.Pointers.encode(pattern), baseLocation + "/patternProperties/" + Utils.Pointers.encode(pattern), new HashSet<Object>());
                                                    if (result9.getValid().booleanValue()) {
                                                        evaluated.add(key4);
                                                        hashSet.add(key4);
                                                        continue;
                                                    }
                                                    stop2 = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(subInstancePointer3, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/patternProperties"), baseLocation + "/patternProperties", "Property \"" + key4 + "\" matches pattern \"" + pattern + "\" but does not match associated schema"));
                                                    if (result9.getErrors() == null) continue;
                                                    errors.addAll(result9.getErrors());
                                                }
                                            }
                                            break;
                                        }
                                        case "array": {
                                            void var17_51;
                                            int length2;
                                            if (schema.containsKey("maxItems") && ((JsonArray)instance).size() > (Integer)schema.get("maxItems")) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maxItems"), baseLocation + "/maxItems", "Array has too many items ( + " + ((JsonArray)instance).size() + " > " + schema.get("maxItems") + ")"));
                                            }
                                            if (schema.containsKey("minItems") && ((JsonArray)instance).size() < (Integer)schema.get("minItems")) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minItems"), baseLocation + "/minItems", "Array has too few items ( + " + ((JsonArray)instance).size() + " < " + schema.get("minItems") + ")"));
                                            }
                                            length = ((JsonArray)instance).size();
                                            boolean bl = false;
                                            stop = false;
                                            if (schema.containsKey("prefixItems")) {
                                                void var17_50;
                                                length2 = Math.min(((JsonArray)schema.get("prefixItems")).size(), length);
                                                while (var17_50 < length2) {
                                                    result = this.validate(((JsonArray)instance).getValue((int)var17_50), Utils.Schemas.wrap((JsonArray)schema.get("prefixItems"), (int)var17_50), recursiveAnchor, instanceLocation + "/" + (int)var17_50, schemaLocation + "/prefixItems/" + (int)var17_50, baseLocation + "/prefixItems/" + (int)var17_50, new HashSet<Object>());
                                                    evaluated.add((int)var17_50);
                                                    if (!result.getValid().booleanValue()) {
                                                        stop = this.outputFormat == OutputFormat.Flag;
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/prefixItems"), baseLocation + "/prefixItems", "Items did not match schema"));
                                                        if (result.getErrors() != null) {
                                                            errors.addAll(result.getErrors());
                                                        }
                                                        if (stop) break;
                                                    }
                                                    ++var17_50;
                                                }
                                            }
                                            if (!schema.containsKey("items")) break block151;
                                            if (!(schema.get("items") instanceof JsonArray)) break block152;
                                            length2 = Math.min(((JsonArray)schema.get("items")).size(), length);
                                            while (var17_51 < length2) {
                                                result = this.validate(((JsonArray)instance).getValue((int)var17_51), Utils.Schemas.wrap((JsonArray)schema.get("items"), (int)var17_51), recursiveAnchor, instanceLocation + "/" + (int)var17_51, schemaLocation + "/items/" + (int)var17_51, baseLocation + "/items/" + (int)var17_51, new HashSet<Object>());
                                                evaluated.add((int)var17_51);
                                                if (!result.getValid().booleanValue()) {
                                                    stop = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/items"), baseLocation + "/items", "Items did not match schema"));
                                                    if (result.getErrors() != null) {
                                                        errors.addAll(result.getErrors());
                                                    }
                                                    if (stop) break block145;
                                                }
                                                ++var17_51;
                                            }
                                            break block145;
                                        }
                                        case "number": {
                                            double remainder;
                                            if (this.draft == Draft.DRAFT4) {
                                                if (schema.containsKey("minimum") && (schema.get("exclusiveMinimum", false).booleanValue() && Utils.Numbers.lte((Number)instance, schema.get("minimum")) || Utils.Numbers.lt((Number)instance, schema.get("minimum")))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minimum"), baseLocation + "/minimum", instance + " is less than " + (schema.get("exclusiveMinimum", false) != false ? "or equal to " : "") + schema.get("minimum")));
                                                }
                                                if (schema.containsKey("maximum") && (schema.get("exclusiveMaximum", false).booleanValue() && Utils.Numbers.gte((Number)instance, schema.get("maximum")) || Utils.Numbers.gt((Number)instance, schema.get("maximum")))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maximum"), baseLocation + "/maximum", instance + " is greater than " + (schema.get("exclusiveMaximum", false) != false ? "or equal to " : "") + schema.get("maximum")));
                                                }
                                            } else {
                                                if (schema.containsKey("minimum") && Utils.Numbers.lt((Number)instance, schema.get("minimum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minimum"), baseLocation + "/minimum", instance + " is less than " + schema.get("minimum")));
                                                }
                                                if (schema.containsKey("maximum") && Utils.Numbers.gt((Number)instance, schema.get("maximum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maximum"), baseLocation + "/maximum", instance + " is greater than " + schema.get("maximum")));
                                                }
                                                if (schema.containsKey("exclusiveMinimum") && Utils.Numbers.lte((Number)instance, schema.get("exclusiveMinimum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/exclusiveMinimum"), baseLocation + "/exclusiveMinimum", instance + " is less than or equal to " + schema.get("exclusiveMinimum")));
                                                }
                                                if (schema.containsKey("exclusiveMaximum") && Utils.Numbers.gte((Number)instance, schema.get("exclusiveMaximum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/exclusiveMaximum"), baseLocation + "/exclusiveMaximum", instance + " is greater than or equal to " + schema.get("exclusiveMaximum")));
                                                }
                                            }
                                            if (schema.containsKey("multipleOf") && Math.abs(0.0 - (remainder = Utils.Numbers.remainder((Number)instance, (Number)schema.get("multipleOf")))) >= 1.1920929E-7 && Math.abs(((Number)schema.get("multipleOf")).doubleValue() - remainder) >= 1.1920929E-7) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/multipleOf"), baseLocation + "/multipleOf", instance + " is not a multiple of " + schema.get("multipleOf")));
                                            }
                                            break block146;
                                        }
                                        case "string": {
                                            int n = length = !schema.containsKey("minLength") && !schema.containsKey("maxLength") ? 0 : Utils.Strings.ucs2length((String)instance);
                                            if (schema.containsKey("minLength") && Utils.Numbers.lt(length, schema.get("minLength"))) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minLength"), baseLocation + "/minLength", "String is too short (" + length + " < " + schema.get("minLength") + ")"));
                                            }
                                            if (schema.containsKey("maxLength") && Utils.Numbers.gt(length, schema.get("maxLength"))) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maxLength"), baseLocation + "/maxLength", "String is too long (" + length + " > " + schema.get("maxLength") + ")"));
                                            }
                                            if (schema.containsKey("pattern") && !Pattern.compile((String)schema.get("pattern")).matcher((String)instance).find()) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/pattern"), baseLocation + "/pattern", "String does not match pattern"));
                                            }
                                            if (schema.containsKey("format") && !Format.fastFormat((String)schema.get("format"), (String)instance)) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/format"), baseLocation + "/format", "String does not match format \"" + schema.get("format") + "\""));
                                            }
                                            break block146;
                                        }
                                        default: {
                                            break block146;
                                        }
                                    }
                                    if (stop2 || !schema.containsKey("additionalProperties")) break block153;
                                    propsOrSchema = ((JsonObject)instance).fieldNames().iterator();
                                    break block154;
                                }
                                if (stop2 || !schema.containsKey("unevaluatedProperties")) break block146;
                                propsOrSchema = ((JsonObject)instance).fieldNames().iterator();
                                break block155;
                            }
                            while (propsOrSchema.hasNext()) {
                                key3 = (String)propsOrSchema.next();
                                if (hashSet.contains(key3)) continue;
                                subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key3);
                                result2 = this.validate(((JsonObject)instance).getValue(key3), Utils.Schemas.wrap((JsonObject)schema, "additionalProperties"), recursiveAnchor, subInstancePointer, schemaLocation + "/additionalProperties", baseLocation + "/additionalProperties", new HashSet<Object>());
                                if (((OutputUnit)result2).getValid().booleanValue()) {
                                    evaluated.add(key3);
                                    continue;
                                }
                                stop2 = this.outputFormat == OutputFormat.Flag;
                                errors.add(new OutputUnit(subInstancePointer, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/additionalProperties"), baseLocation + "/additionalProperties", "Property \"" + key3 + "\" does not match additional properties schema"));
                                if (((OutputUnit)result2).getErrors() != null) {
                                    errors.addAll(((OutputUnit)result2).getErrors());
                                }
                                if (!stop2) continue;
                                break block146;
                            }
                            break block146;
                        }
                        while (propsOrSchema.hasNext()) {
                            key3 = (String)propsOrSchema.next();
                            if (evaluated.contains(key3)) continue;
                            subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key3);
                            result2 = this.validate(((JsonObject)instance).getValue(key3), Utils.Schemas.wrap((JsonObject)schema, "unevaluatedProperties"), recursiveAnchor, subInstancePointer, schemaLocation + "/unevaluatedProperties", baseLocation + "/unevaluatedProperties", new HashSet<Object>());
                            if (((OutputUnit)result2).getValid().booleanValue()) {
                                evaluated.add(key3);
                                continue;
                            }
                            errors.add(new OutputUnit(subInstancePointer, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/unevaluatedProperties"), baseLocation + "/unevaluatedProperties", "Property \"" + key3 + "\" does not match unevaluated properties schema"));
                            if (((OutputUnit)result2).getErrors() == null) continue;
                            errors.addAll(((OutputUnit)result2).getErrors());
                        }
                        break block146;
                    }
                    while (var17_52 < length) {
                        OutputUnit result10 = this.validate(((JsonArray)instance).getValue((int)var17_52), Utils.Schemas.wrap((JsonObject)schema, "items"), recursiveAnchor, instanceLocation + "/" + (int)var17_52, schemaLocation + "/items", baseLocation + "/items", new HashSet<Object>());
                        evaluated.add((int)var17_52);
                        if (!result10.getValid().booleanValue()) {
                            stop = this.outputFormat == OutputFormat.Flag;
                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/items"), baseLocation + "/items", "Items did not match schema"));
                            if (result10.getErrors() != null) {
                                errors.addAll(result10.getErrors());
                            }
                            if (stop) break;
                        }
                        ++var17_52;
                    }
                }
                if (!stop && schema.containsKey("additionalItems")) {
                    String keywordLocation2 = schemaLocation + "/additionalItems";
                    while (var17_54 < length) {
                        result = this.validate(((JsonArray)instance).getValue((int)var17_54), Utils.Schemas.wrap((JsonObject)schema, "additionalItems"), recursiveAnchor, instanceLocation + "/" + (int)var17_54, keywordLocation2, baseLocation + "/additionalItems", new HashSet<Object>());
                        evaluated.add((int)var17_54);
                        if (!result.getValid().booleanValue()) {
                            stop = this.outputFormat == OutputFormat.Flag;
                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/additionalItems"), schemaLocation + "/additionalItems", "Items did not match additional items schema"));
                            if (result.getErrors() != null) {
                                errors.addAll(result.getErrors());
                            }
                        }
                        ++var17_54;
                    }
                }
            }
            if (schema.containsKey("contains")) {
                if (length == 0 && !schema.containsKey("minContains")) {
                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/contains"), baseLocation + "/contains", "Array is empty. It must contain at least one item matching the schema"));
                } else if (schema.containsKey("minContains") && length < (Integer)schema.get("minContains")) {
                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minContains"), baseLocation + "/minContains", "Array has less items (" + length + ") than minContains (" + schema.get("minContains") + ")"));
                } else {
                    int errorsLength = errors.size();
                    int contained = 0;
                    for (int j = 0; j < length; ++j) {
                        OutputUnit result = this.validate(((JsonArray)instance).getValue(j), Utils.Schemas.wrap((JsonObject)schema, "contains"), recursiveAnchor, instanceLocation + "/" + (int)var17_54, schemaLocation + "/contains", baseLocation + "/contains", new HashSet<Object>());
                        if (result.getValid().booleanValue()) {
                            evaluated.add(j);
                            ++contained;
                            continue;
                        }
                        if (result.getErrors() == null) continue;
                        errors.addAll(result.getErrors());
                    }
                    if (contained >= schema.get("minContains", 0)) {
                        errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                    }
                    if (!schema.containsKey("minContains") && !schema.containsKey("maxContains") && contained == 0) {
                        errors.add(errorsLength, new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/contains"), baseLocation + "/contains", "Array does not contain item matching schema"));
                    } else if (schema.containsKey("minContains") && contained < (Integer)schema.get("minContains")) {
                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minContains"), baseLocation + "/minContains", "Array must contain at least " + schema.get("minContains") + " items matching schema. Only " + contained + " items were found"));
                    } else if (schema.containsKey("maxContains") && contained > (Integer)schema.get("maxContains")) {
                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maxContains"), baseLocation + "/maxContains", "Array may contain at most " + schema.get("minContains") + " items matching schema. " + contained + " items were found"));
                    }
                }
            }
            if (!stop && schema.containsKey("unevaluatedItems")) {
                void var17_55;
                while (var17_55 < length) {
                    if (!evaluated.contains((int)var17_55)) {
                        OutputUnit result = this.validate(((JsonArray)instance).getValue((int)var17_55), Utils.Schemas.wrap((JsonObject)schema, "unevaluatedItems"), recursiveAnchor, instanceLocation + "/" + (int)var17_55, schemaLocation + "/unevaluatedItems", baseLocation + "/unevaluatedItems", new HashSet<Object>());
                        evaluated.add((int)var17_55);
                        if (!result.getValid().booleanValue()) {
                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/unevaluatedItems"), baseLocation + "/unevaluatedItems", "Items did not match unevaluated items schema"));
                            if (result.getErrors() != null) {
                                errors.addAll(result.getErrors());
                            }
                        }
                    }
                    ++var17_55;
                }
            }
            if (schema.containsKey("uniqueItems") && Utils.Objects.truthy(schema.get("uniqueItems"))) {
                for (int j = 0; j < length; ++j) {
                    Object a = ((JsonArray)instance).getValue(j);
                    boolean ao = "object".equals(Utils.JSON.typeOf(a)) && a != null;
                    for (int k = 0; k < length; ++k) {
                        boolean bo;
                        if (j == k) continue;
                        Object b = ((JsonArray)instance).getValue(k);
                        boolean bl = bo = "object".equals(Utils.JSON.typeOf(b)) && b != null;
                        if (!Utils.Objects.equals(a, b) && (!ao || !bo || !Utils.JSON.deepCompare(a, b))) continue;
                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/uniqueItems"), baseLocation + "/uniqueItems", "Duplicate items at indexes " + j + " and " + k));
                        break block146;
                    }
                }
            }
        }
        OutputUnit outputUnit = new OutputUnit(errors.isEmpty()).setErrors(this.outputFormat == OutputFormat.Flag ? null : (errors.isEmpty() ? null : errors));
        if (this.outputFormat == OutputFormat.Flag) {
            arrayList = null;
            return outputUnit.setAnnotations(arrayList);
        }
        if (annotations.isEmpty()) {
            arrayList = null;
            return outputUnit.setAnnotations(arrayList);
        }
        arrayList = annotations;
        return outputUnit.setAnnotations(arrayList);
    }

    private String computeAbsoluteKeywordLocation(JsonSchema schema, String schemaKeywordLocation) {
        if (schemaKeywordLocation == null) {
            return null;
        }
        String absoluteUri = (String)schema.get("__absolute_uri__");
        if (absoluteUri == null) {
            return null;
        }
        return new URL(schemaKeywordLocation, absoluteUri).href();
    }
}

