/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.openapi3;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;

public class NullableValidatorFactory
implements ValidatorFactory {
    private static final BaseSyncValidator NULL_VALIDATOR = new BaseSyncValidator(){

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            if (in == null) {
                throw ValidationException.create("input cannot be null", "nullable", null);
            }
        }
    };

    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Boolean nullable = (Boolean)schema.getValue("nullable");
            if (nullable == null || !nullable.booleanValue()) {
                return NULL_VALIDATOR;
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for nullable keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null nullable keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return !schema.containsKey("$ref");
    }
}

