/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseCombinatorsValidator;
import io.vertx.json.schema.common.BaseCombinatorsValidatorFactory;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.ValidatorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AnyOfValidatorFactory
extends BaseCombinatorsValidatorFactory {
    @Override
    BaseCombinatorsValidator instantiate(MutableStateValidator parent) {
        return new AnyOfValidator(parent);
    }

    @Override
    String getKeyword() {
        return "anyOf";
    }

    static class AnyOfValidator
    extends BaseCombinatorsValidator {
        public AnyOfValidator(MutableStateValidator parent) {
            super(parent);
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            ArrayList<ValidationException> res = null;
            for (SchemaInternal s : this.schemas) {
                try {
                    s.validateSync(context, in);
                    return;
                }
                catch (ValidationException e) {
                    if (res == null) {
                        res = new ArrayList<ValidationException>();
                    }
                    res.add(e);
                }
            }
            throw ValidationException.create("anyOf subschemas don't match", "anyOf", in, res);
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            return CompositeFuture.any(Arrays.stream(this.schemas).map(s -> s.validateAsync(context, in)).collect(Collectors.toList())).compose(cf -> {
                if (cf.succeeded()) {
                    return Future.succeededFuture();
                }
                return Future.failedFuture((Throwable)((Object)ValidationException.create("anyOf subschemas don't match", "anyOf", in, IntStream.range(0, cf.size()).mapToObj(arg_0 -> ((CompositeFuture)cf).cause(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()))));
            });
        }
    }
}

