/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonSchemaOptionsConverter;
import io.vertx.json.schema.OutputFormat;
import java.util.Map;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class JsonSchemaOptions {
    private String baseUri;
    private Draft draft;
    private OutputFormat outputFormat = OutputFormat.Flag;

    public JsonSchemaOptions() {
    }

    public JsonSchemaOptions(JsonObject json) {
        JsonSchemaOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonSchemaOptions(JsonSchemaOptions other) {
        Objects.requireNonNull(other, "'other' cannot be null");
        this.baseUri = other.baseUri;
        this.draft = other.draft;
        this.outputFormat = other.outputFormat;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public JsonSchemaOptions setBaseUri(String baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public Draft getDraft() {
        return this.draft;
    }

    public JsonSchemaOptions setDraft(Draft draft) {
        this.draft = draft;
        return this;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public JsonSchemaOptions setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonSchemaOptionsConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

