/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft201909;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSingleSchemaValidator;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.JsonUtil;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.SetUtils;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.json.schema.common.ValidatorPriority;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UnevaluatedItemsValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) throws SchemaException {
        try {
            Object unevaluatedItems = schema.getValue("unevaluatedItems");
            if (unevaluatedItems instanceof Boolean) {
                if (!((Boolean)unevaluatedItems).booleanValue()) {
                    return new NoUnevaluatedItemsValidator();
                }
                return null;
            }
            SchemedUnevaluatedItemsValidator validator = new SchemedUnevaluatedItemsValidator(parent);
            validator.setSchema(parser.parse(unevaluatedItems, scope.append("unevaluatedItems"), (MutableStateValidator)validator));
            return validator;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for unevaluatedItems keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null unevaluatedItems keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("unevaluatedItems");
    }

    static class NoUnevaluatedItemsValidator
    extends BaseSyncValidator {
        NoUnevaluatedItemsValidator() {
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            List arr;
            Object o = JsonUtil.unwrap(in);
            if (o instanceof List && (arr = (List)o).size() != context.evaluatedItems().size()) {
                throw ValidationException.create("Expecting no unevaluated items. Unevaluated items: " + SetUtils.minus(SetUtils.range(0, arr.size()), context.evaluatedItems()), "unevaluatedItems", in);
            }
        }

        @Override
        public ValidatorPriority getPriority() {
            return ValidatorPriority.CONTEXTUAL_VALIDATOR;
        }
    }

    static class SchemedUnevaluatedItemsValidator
    extends BaseSingleSchemaValidator {
        public SchemedUnevaluatedItemsValidator(MutableStateValidator parent) {
            super(parent);
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            Object o = JsonUtil.unwrap(in);
            if (o instanceof List) {
                List arr = (List)o;
                Set<Integer> unevaluatedItems = this.computeUnevaluatedItems(context, arr);
                return CompositeFuture.all(unevaluatedItems.stream().map(index -> this.schema.validateAsync(context.lowerLevelContext((int)index), arr.get((int)index))).collect(Collectors.toList())).recover(t -> Future.failedFuture((Throwable)((Object)ValidationException.create("one of the unevaluated items doesn't match the unevaluatedItems schema", "unevaluatedItems", in, t)))).mapEmpty();
            }
            return Future.succeededFuture();
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            in = JsonUtil.unwrap(in);
            if (in instanceof List) {
                List arr = (List)in;
                Set<Integer> unevaluatedProperties = this.computeUnevaluatedItems(context, arr);
                unevaluatedProperties.forEach(index -> this.schema.validateSync(context.lowerLevelContext((int)index), arr.get((int)index)));
            }
        }

        @Override
        public ValidatorPriority getPriority() {
            return ValidatorPriority.CONTEXTUAL_VALIDATOR;
        }

        private Set<Integer> computeUnevaluatedItems(ValidatorContext context, List<?> in) {
            return SetUtils.minus(SetUtils.range(0, in.size()), context.evaluatedItems());
        }
    }
}

