/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft7;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.common.ExclusiveMinimumValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorFactory;

public class ExclusiveMinimumValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Number maximum = (Number)schema.getValue("exclusiveMinimum");
            return new ExclusiveMinimumValidator(maximum.doubleValue());
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for exclusiveMinimum keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null exclusiveMinimum keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("exclusiveMinimum");
    }
}

