/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonFormatValidator;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.OutputErrorType;
import io.vertx.json.schema.OutputFormat;
import io.vertx.json.schema.OutputUnit;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.impl.BooleanSchema;
import io.vertx.json.schema.impl.Format;
import io.vertx.json.schema.impl.SchemaRepositoryImpl;
import io.vertx.json.schema.impl.SchemaValidatorInternal;
import io.vertx.json.schema.impl.URL;
import io.vertx.json.schema.impl.Utils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class SchemaValidatorImpl
implements SchemaValidatorInternal {
    private final Map<String, JsonSchema> lookup;
    private final JsonSchema schema;
    private final Draft draft;
    private final OutputFormat outputFormat;
    private final JsonFormatValidator formatValidator;

    public SchemaValidatorImpl(JsonSchema schema, JsonSchemaOptions options, Map<String, JsonSchema> lookup, boolean dereference, JsonFormatValidator formatValidator) {
        Objects.requireNonNull(schema, "'schema' cannot be null");
        Objects.requireNonNull(options, "'options' cannot be null");
        Objects.requireNonNull(options.getOutputFormat(), "'options.outputFormat' cannot be null");
        Objects.requireNonNull(lookup, "'lookup' cannot be null");
        Objects.requireNonNull(formatValidator, "'formatValidator' cannot be null");
        this.formatValidator = formatValidator;
        this.schema = schema;
        this.draft = options.getDraft() == null ? Draft.fromIdentifier((String)schema.get("$schema")) : options.getDraft();
        this.outputFormat = options.getOutputFormat();
        this.lookup = new HashMap<String, JsonSchema>(lookup);
        if (dereference) {
            URL baseUri = new URL(options.getBaseUri());
            SchemaRepositoryImpl.dereference(this.lookup, schema, baseUri, "", true);
        }
    }

    @Override
    public JsonSchema schema() {
        return this.schema;
    }

    @Override
    public OutputUnit validate(Object instance) throws SchemaException {
        return this.validate(instance, this.schema, null, "#", "#", "#", new HashSet<Object>(), new HashMap<String, Deque<JsonSchema>>());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private OutputUnit validate(Object _instance, JsonSchema schema, JsonSchema _recursiveAnchor, String instanceLocation, String schemaLocation, String baseLocation, Set<Object> evaluated, Map<String, Deque<JsonSchema>> dynamicContext) throws SchemaException {
        OutputErrorType outputErrorType;
        String dynamicAnchor;
        ArrayList<OutputUnit> annotations;
        List<OutputUnit> errors;
        String instanceType;
        Object instance;
        block159: {
            void var19_65;
            boolean stop;
            int length;
            JsonSchema recursiveAnchor;
            block164: {
                OutputUnit result;
                block158: {
                    void var19_63;
                    block165: {
                        Object result2;
                        String subInstancePointer;
                        String key3;
                        Object propsOrSchema;
                        block168: {
                            boolean stop2;
                            HashSet<String> hashSet;
                            block167: {
                                block166: {
                                    block162: {
                                        OutputUnit elseResult;
                                        block163: {
                                            OutputUnit thenResult;
                                            OutputUnit result3;
                                            OutputUnit result4;
                                            block161: {
                                                block160: {
                                                    JsonSchema head;
                                                    Deque<JsonSchema> deque;
                                                    if (schema instanceof BooleanSchema) {
                                                        if (schema != BooleanSchema.TRUE) return new OutputUnit(false).setErrorType(OutputErrorType.INVALID_VALUE);
                                                        return new OutputUnit(true);
                                                    }
                                                    instance = Utils.JSON.jsonify(_instance);
                                                    instanceType = Utils.JSON.typeOf(instance);
                                                    errors = new ArrayList<OutputUnit>();
                                                    annotations = new ArrayList<OutputUnit>();
                                                    if (schema.containsKey("$dynamicAnchor")) {
                                                        dynamicAnchor = "#" + schema.get("$dynamicAnchor");
                                                        dynamicContext.computeIfAbsent(dynamicAnchor, k -> new LinkedList()).add(schema);
                                                    } else {
                                                        dynamicAnchor = null;
                                                    }
                                                    recursiveAnchor = _recursiveAnchor == null && schema.get("$recursiveAnchor", false) != false ? schema : _recursiveAnchor;
                                                    if ("#".equals(schema.get("$recursiveRef"))) {
                                                        JsonSchema refSchema;
                                                        assert (schema.containsKey("__absolute_recursive_ref__"));
                                                        OutputUnit result5 = this.validate(instance, recursiveAnchor == null ? schema : recursiveAnchor, refSchema = recursiveAnchor == null ? this.lookup.get(schema.get("__absolute_recursive_ref__")) : recursiveAnchor, instanceLocation, schemaLocation + "/$recursiveRef", baseLocation + "/$recursiveRef", evaluated, dynamicContext);
                                                        if (!result5.getValid().booleanValue()) {
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/$recursiveRef"), baseLocation + "/$recursiveRef", "A sub-schema had errors", result5.getErrorType()));
                                                            if (result5.getErrors() != null) {
                                                                errors.addAll(result5.getErrors());
                                                            }
                                                        }
                                                    }
                                                    if (schema.containsKey("$dynamicRef") && (deque = dynamicContext.get(schema.get("$dynamicRef"))) != null && (head = deque.peekFirst()) != null) {
                                                        JsonSchema refSchema;
                                                        String uri = new URL((String)schema.get("$dynamicRef"), (String)head.get("__absolute_uri__")).href();
                                                        if (!this.lookup.containsKey(uri)) {
                                                            String message = "Unresolved $dynamicRef " + (String)schema.get("$dynamicRef");
                                                            message = message + "\nKnown schemas:\n- " + String.join((CharSequence)"\n- ", this.lookup.keySet());
                                                            throw new SchemaException(schema, message);
                                                        }
                                                        OutputUnit outputUnit = this.validate(instance, recursiveAnchor == null ? schema : recursiveAnchor, refSchema = this.lookup.get(uri), instanceLocation, schemaLocation + "/$dynamicRef", baseLocation + "/$dynamicRef", evaluated, dynamicContext);
                                                        if (!outputUnit.getValid().booleanValue()) {
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/$dynamicRef"), baseLocation + "/$dynamicRef", "A sub-schema had errors", outputUnit.getErrorType()));
                                                            if (outputUnit.getErrors() != null) {
                                                                errors.addAll(outputUnit.getErrors());
                                                            }
                                                        }
                                                        if (this.draft == Draft.DRAFT4 || this.draft == Draft.DRAFT7) {
                                                            OutputErrorType outputErrorType2;
                                                            if (dynamicAnchor != null) {
                                                                dynamicContext.get(dynamicAnchor).removeLast();
                                                            }
                                                            OutputUnit outputUnit2 = new OutputUnit(errors.isEmpty()).setErrors(errors);
                                                            if (errors.isEmpty()) {
                                                                outputErrorType2 = OutputErrorType.NONE;
                                                                return outputUnit2.setErrorType(outputErrorType2);
                                                            }
                                                            outputErrorType2 = errors.get(0).getErrorType();
                                                            return outputUnit2.setErrorType(outputErrorType2);
                                                        }
                                                    }
                                                    if (schema.containsKey("$ref")) {
                                                        String uri = schema.get("__absolute_ref__", (String)schema.get("$ref"));
                                                        if (!this.lookup.containsKey(uri)) {
                                                            String message = "Unresolved $ref " + (String)schema.get("$ref");
                                                            if (schema.containsKey("__absolute_ref__") && !schema.get("__absolute_ref__").equals(schema.get("$ref"))) {
                                                                message = message + ": Absolute URI " + schema.get("__absolute_ref__");
                                                            }
                                                            message = message + "\nKnown schemas:\n- " + String.join((CharSequence)"\n- ", this.lookup.keySet());
                                                            throw new SchemaException(schema, message);
                                                        }
                                                        JsonSchema refSchema = this.lookup.get(uri);
                                                        OutputUnit result6 = this.validate(instance, refSchema, recursiveAnchor, instanceLocation, (String)schema.get("$ref"), baseLocation + "/$ref", evaluated, dynamicContext);
                                                        if (!result6.getValid().booleanValue()) {
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/$ref"), baseLocation + "/$ref", "A subschema had errors", result6.getErrorType()));
                                                            if (result6.getErrors() != null) {
                                                                errors.addAll(result6.getErrors());
                                                            }
                                                        }
                                                        if (this.draft == Draft.DRAFT4 || this.draft == Draft.DRAFT7) {
                                                            OutputErrorType outputErrorType3;
                                                            OutputUnit outputUnit = new OutputUnit(errors.isEmpty()).setErrors(this.outputFormat == OutputFormat.Flag ? null : (errors.isEmpty() ? null : errors));
                                                            if (this.outputFormat == OutputFormat.Flag) {
                                                                outputErrorType3 = null;
                                                                return outputUnit.setErrorType(outputErrorType3);
                                                            }
                                                            if (errors.isEmpty()) {
                                                                outputErrorType3 = OutputErrorType.NONE;
                                                                return outputUnit.setErrorType(outputErrorType3);
                                                            }
                                                            outputErrorType3 = ((OutputUnit)errors.get(0)).getErrorType();
                                                            return outputUnit.setErrorType(outputErrorType3);
                                                        }
                                                    }
                                                    if (schema.get("type") instanceof JsonArray) break block160;
                                                    if ("integer".equals(schema.get("type"))) {
                                                        if (!"number".equals(instanceType) || !Utils.Numbers.isInteger(instance)) {
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/type"), baseLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + schema.get("type"), OutputErrorType.INVALID_VALUE));
                                                        }
                                                        break block161;
                                                    } else if (schema.containsKey("type") && !instanceType.equals(schema.get("type"))) {
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/type"), baseLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + schema.get("type"), OutputErrorType.INVALID_VALUE));
                                                    }
                                                    break block161;
                                                }
                                                JsonArray type = (JsonArray)schema.get("type");
                                                int length2 = type.size();
                                                boolean valid = false;
                                                for (int i = 0; i < length2; ++i) {
                                                    if (!instanceType.equals(type.getString(i)) && (!"integer".equals(type.getString(i)) || !"number".equals(instanceType) || !Utils.Numbers.isInteger(instance))) continue;
                                                    valid = true;
                                                    break;
                                                }
                                                if (!valid) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/type"), baseLocation + "/type", "Instance type " + instanceType + " is invalid. Expected " + String.join((CharSequence)", ", type.getList()), OutputErrorType.INVALID_VALUE));
                                                }
                                            }
                                            if (schema.containsKey("const")) {
                                                if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                    if (!Utils.JSON.deepCompare(instance, schema.get("const"))) {
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/const"), baseLocation + "/const", "Instance does not match " + Json.encode(schema.get("const")), OutputErrorType.INVALID_VALUE));
                                                    }
                                                } else if (!Utils.Objects.equals(schema.get("const"), instance)) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/const"), baseLocation + "/const", "Instance does not match " + Json.encode(schema.get("const")), OutputErrorType.INVALID_VALUE));
                                                }
                                            }
                                            if (schema.containsKey("enum")) {
                                                if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                    if (((JsonArray)schema.get("enum")).stream().noneMatch(value -> Utils.JSON.deepCompare(instance, value))) {
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/enum"), baseLocation + "/enum", "Instance does not match any of " + Json.encode(schema.get("enum")), OutputErrorType.INVALID_VALUE));
                                                    }
                                                } else if (((JsonArray)schema.get("enum")).stream().noneMatch(value -> Utils.Objects.equals(instance, value))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/enum"), baseLocation + "/enum", "Instance does not match any of " + Json.encode(schema.get("enum")), OutputErrorType.INVALID_VALUE));
                                                }
                                            }
                                            if (schema.containsKey("not") && (result4 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "not"), recursiveAnchor, instanceLocation, schemaLocation + "/not", baseLocation + "/not", new HashSet<Object>(), dynamicContext)).getValid().booleanValue()) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/not"), baseLocation + "/not", "Instance matched \"not\" schema", result4.getErrorType()));
                                            }
                                            HashSet<Object> subEvaluateds = new HashSet<Object>();
                                            if (schema.containsKey("anyOf")) {
                                                int errorsLength = errors.size();
                                                boolean anyValid = false;
                                                for (int i = 0; i < ((JsonArray)schema.get("anyOf")).size(); ++i) {
                                                    HashSet<Object> hashSet2 = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("anyOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, schemaLocation + "/anyOf/" + i, baseLocation + "/anyOf/" + i, hashSet2, dynamicContext);
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    boolean bl = anyValid = anyValid || result3.getValid() != false;
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    subEvaluateds.addAll(hashSet2);
                                                }
                                                if (anyValid) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/anyOf"), baseLocation + "/anyOf", "Instance does not match any subschemas", OutputErrorType.INVALID_VALUE));
                                                }
                                            }
                                            if (schema.containsKey("allOf")) {
                                                int errorsLength = errors.size();
                                                boolean allValid = true;
                                                for (int i = 0; i < ((JsonArray)schema.get("allOf")).size(); ++i) {
                                                    HashSet<Object> hashSet3 = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("allOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, schemaLocation + "/allOf/" + i, baseLocation + "/allOf/" + i, hashSet3, dynamicContext);
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    boolean bl = allValid = allValid && result3.getValid() != false;
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    subEvaluateds.addAll(hashSet3);
                                                }
                                                if (allValid) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/allOf"), baseLocation + "/allOf", "Instance does not match every subschema", OutputErrorType.INVALID_VALUE));
                                                }
                                            }
                                            if (schema.containsKey("oneOf")) {
                                                int errorsLength = errors.size();
                                                int matches = 0;
                                                for (int i = 0; i < ((JsonArray)schema.get("oneOf")).size(); ++i) {
                                                    HashSet<Object> hashSet4 = new HashSet<Object>(evaluated);
                                                    result3 = this.validate(instance, Utils.Schemas.wrap((JsonArray)schema.get("oneOf"), i), schema.get("$recursiveAnchor", false) != false ? recursiveAnchor : null, instanceLocation, schemaLocation + "/oneOf/" + i, baseLocation + "/oneOf/" + i, hashSet4, dynamicContext);
                                                    if (result3.getErrors() != null) {
                                                        errors.addAll(result3.getErrors());
                                                    }
                                                    if (result3.getValid().booleanValue()) {
                                                        subEvaluateds.addAll(hashSet4);
                                                    }
                                                    if (!result3.getValid().booleanValue()) continue;
                                                    ++matches;
                                                }
                                                if (matches == 1) {
                                                    errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                                                } else {
                                                    errors.add(errorsLength, new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/oneOf"), baseLocation + "/oneOf", "Instance does not match exactly one subschema (" + matches + " matches)", OutputErrorType.INVALID_VALUE));
                                                }
                                            }
                                            if ("object".equals(instanceType) || "array".equals(instanceType)) {
                                                evaluated.addAll(subEvaluateds);
                                            }
                                            if (!schema.containsKey("if")) break block162;
                                            OutputUnit conditionResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "if"), recursiveAnchor, instanceLocation, schemaLocation + "/if", baseLocation + "/if", evaluated, dynamicContext);
                                            if (!conditionResult.getValid().booleanValue()) break block163;
                                            if (schema.containsKey("then") && !(thenResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "then"), recursiveAnchor, instanceLocation, schemaLocation + "/then", baseLocation + "/then", evaluated, dynamicContext)).getValid().booleanValue()) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/if"), baseLocation + "/if", "Instance does not match \"then\" schema", thenResult.getErrorType()));
                                                if (thenResult.getErrors() != null) {
                                                    errors.addAll(thenResult.getErrors());
                                                }
                                            }
                                            break block162;
                                        }
                                        if (schema.containsKey("else") && !(elseResult = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema, "else"), recursiveAnchor, instanceLocation, schemaLocation + "/else", baseLocation + "/else", evaluated, dynamicContext)).getValid().booleanValue()) {
                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/else"), baseLocation + "/else", "Instance does not match \"else\" schema", elseResult.getErrorType()));
                                            if (elseResult.getErrors() != null) {
                                                errors.addAll(elseResult.getErrors());
                                            }
                                        }
                                    }
                                    switch (instanceType) {
                                        case "object": {
                                            Object result7;
                                            if (schema.containsKey("required")) {
                                                for (Object e : (JsonArray)schema.get("required")) {
                                                    if (((JsonObject)instance).containsKey((String)e)) continue;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/required"), baseLocation + "/required", "Instance does not have required property \"" + e + "\"", OutputErrorType.MISSING_VALUE));
                                                }
                                            }
                                            Set keys = ((JsonObject)instance).fieldNames();
                                            if (schema.containsKey("minProperties") && keys.size() < (Integer)schema.get("minProperties")) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minProperties"), baseLocation + "/minProperties", "Instance does not have at least " + schema.get("minProperties") + " properties", OutputErrorType.MISSING_VALUE));
                                            }
                                            if (schema.containsKey("maxProperties") && keys.size() > (Integer)schema.get("maxProperties")) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maxProperties"), baseLocation + "/maxProperties", "Instance does not have at least " + schema.get("maxProperties") + " properties", OutputErrorType.INVALID_VALUE));
                                            }
                                            if (schema.containsKey("propertyNames")) {
                                                for (String key2 : ((JsonObject)instance).fieldNames()) {
                                                    String subInstancePointer2 = instanceLocation + "/" + Utils.Pointers.encode(key2);
                                                    result7 = this.validate(key2, Utils.Schemas.wrap((JsonObject)schema, "propertyNames"), recursiveAnchor, subInstancePointer2, schemaLocation + "/propertyNames", baseLocation + "/propertyNames", new HashSet<Object>(), dynamicContext);
                                                    if (((OutputUnit)result7).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/propertyNames"), baseLocation + "/propertyNames", "Property name \"" + key2 + "\" does not match schema", OutputErrorType.INVALID_VALUE));
                                                    if (((OutputUnit)result7).getErrors() == null) continue;
                                                    errors.addAll(((OutputUnit)result7).getErrors());
                                                }
                                            }
                                            if (schema.containsKey("dependentRequired")) {
                                                for (String key2 : ((JsonObject)schema.get("dependentRequired")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key2)) continue;
                                                    JsonArray required = ((JsonObject)schema.get("dependentRequired")).getJsonArray(key2);
                                                    for (Object dependantKey : required) {
                                                        if (((JsonObject)instance).containsKey((String)dependantKey)) continue;
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/dependentRequired"), baseLocation + "/dependentRequired", "Instance has \"" + key2 + "\" but does not have \"" + dependantKey + "\"", OutputErrorType.MISSING_VALUE));
                                                    }
                                                }
                                            }
                                            if (schema.containsKey("dependentSchemas")) {
                                                for (String key2 : ((JsonObject)schema.get("dependentSchemas")).fieldNames()) {
                                                    OutputUnit result8;
                                                    if (!((JsonObject)instance).containsKey(key2) || (result8 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema.get("dependentSchemas"), key2), recursiveAnchor, instanceLocation, schemaLocation + "/dependentSchemas/" + Utils.Pointers.encode(key2), baseLocation + "/dependentSchemas/" + Utils.Pointers.encode(key2), evaluated, dynamicContext)).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/dependentSchemas"), baseLocation + "/dependentSchemas", "Instance has \"" + key2 + "\" but does not match dependant schema", OutputErrorType.MISSING_VALUE));
                                                    if (result8.getErrors() == null) continue;
                                                    errors.addAll(result8.getErrors());
                                                }
                                            }
                                            if (schema.containsKey("dependencies")) {
                                                for (String key2 : ((JsonObject)schema.get("dependencies")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key2)) continue;
                                                    propsOrSchema = ((JsonObject)schema.get("dependencies")).getValue(key2);
                                                    if (propsOrSchema instanceof JsonArray) {
                                                        for (Object dependantKey : (JsonArray)propsOrSchema) {
                                                            if (((JsonObject)instance).containsKey((String)dependantKey)) continue;
                                                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/dependencies"), baseLocation + "/dependencies", "Instance has \"" + key2 + "\" but does not have \"" + dependantKey + "\"", OutputErrorType.MISSING_VALUE));
                                                        }
                                                        continue;
                                                    }
                                                    result7 = this.validate(instance, Utils.Schemas.wrap((JsonObject)schema.get("dependencies"), key2), recursiveAnchor, instanceLocation, schemaLocation + "/dependencies/" + Utils.Pointers.encode(key2), baseLocation + "/dependencies/" + Utils.Pointers.encode(key2), new HashSet<Object>(), dynamicContext);
                                                    if (((OutputUnit)result7).getValid().booleanValue()) continue;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/dependencies"), baseLocation + "/dependencies", "Instance has \"" + key2 + "\" but does not match dependant schema", OutputErrorType.MISSING_VALUE));
                                                    if (((OutputUnit)result7).getErrors() == null) continue;
                                                    errors.addAll(((OutputUnit)result7).getErrors());
                                                }
                                            }
                                            hashSet = new HashSet<String>();
                                            stop2 = false;
                                            if (schema.containsKey("properties")) {
                                                for (String key3 : ((JsonObject)schema.get("properties")).fieldNames()) {
                                                    if (!((JsonObject)instance).containsKey(key3)) continue;
                                                    subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key3);
                                                    result2 = this.validate(((JsonObject)instance).getValue(key3), Utils.Schemas.wrap((JsonObject)schema.get("properties"), key3), recursiveAnchor, subInstancePointer, schemaLocation + "/properties/" + Utils.Pointers.encode(key3), baseLocation + "/properties/" + Utils.Pointers.encode(key3), new HashSet<Object>(), dynamicContext);
                                                    if (((OutputUnit)result2).getValid().booleanValue()) {
                                                        evaluated.add(key3);
                                                        hashSet.add(key3);
                                                        continue;
                                                    }
                                                    stop2 = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(subInstancePointer, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/properties"), baseLocation + "/properties", "Property \"" + key3 + "\" does not match schema", ((OutputUnit)result2).getErrorType()));
                                                    if (((OutputUnit)result2).getErrors() != null) {
                                                        errors.addAll(((OutputUnit)result2).getErrors());
                                                    }
                                                    if (!stop2) continue;
                                                }
                                            }
                                            if (stop2 || !schema.containsKey("patternProperties")) break;
                                            for (String pattern : ((JsonObject)schema.get("patternProperties")).fieldNames()) {
                                                Pattern regex = Pattern.compile(pattern);
                                                for (String key4 : ((JsonObject)instance).fieldNames()) {
                                                    if (!regex.matcher(key4).find()) continue;
                                                    String subInstancePointer3 = instanceLocation + "/" + Utils.Pointers.encode(key4);
                                                    OutputUnit result9 = this.validate(((JsonObject)instance).getValue(key4), Utils.Schemas.wrap((JsonObject)schema.get("patternProperties"), pattern), recursiveAnchor, subInstancePointer3, schemaLocation + "/patternProperties/" + Utils.Pointers.encode(pattern), baseLocation + "/patternProperties/" + Utils.Pointers.encode(pattern), new HashSet<Object>(), dynamicContext);
                                                    if (result9.getValid().booleanValue()) {
                                                        evaluated.add(key4);
                                                        hashSet.add(key4);
                                                        continue;
                                                    }
                                                    stop2 = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(subInstancePointer3, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/patternProperties"), baseLocation + "/patternProperties", "Property \"" + key4 + "\" matches pattern \"" + pattern + "\" but does not match associated schema", OutputErrorType.INVALID_VALUE));
                                                    if (result9.getErrors() == null) continue;
                                                    errors.addAll(result9.getErrors());
                                                }
                                            }
                                            break;
                                        }
                                        case "array": {
                                            void var19_62;
                                            int length2;
                                            if (schema.containsKey("maxItems") && ((JsonArray)instance).size() > (Integer)schema.get("maxItems")) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maxItems"), baseLocation + "/maxItems", "Array has too many items ( + " + ((JsonArray)instance).size() + " > " + schema.get("maxItems") + ")", OutputErrorType.INVALID_VALUE));
                                            }
                                            if (schema.containsKey("minItems") && ((JsonArray)instance).size() < (Integer)schema.get("minItems")) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minItems"), baseLocation + "/minItems", "Array has too few items ( + " + ((JsonArray)instance).size() + " < " + schema.get("minItems") + ")", OutputErrorType.MISSING_VALUE));
                                            }
                                            length = ((JsonArray)instance).size();
                                            boolean bl = false;
                                            stop = false;
                                            if (schema.containsKey("prefixItems")) {
                                                void var19_61;
                                                length2 = Math.min(((JsonArray)schema.get("prefixItems")).size(), length);
                                                while (var19_61 < length2) {
                                                    result = this.validate(((JsonArray)instance).getValue((int)var19_61), Utils.Schemas.wrap((JsonArray)schema.get("prefixItems"), (int)var19_61), recursiveAnchor, instanceLocation + "/" + (int)var19_61, schemaLocation + "/prefixItems/" + (int)var19_61, baseLocation + "/prefixItems/" + (int)var19_61, new HashSet<Object>(), dynamicContext);
                                                    evaluated.add((int)var19_61);
                                                    if (!result.getValid().booleanValue()) {
                                                        stop = this.outputFormat == OutputFormat.Flag;
                                                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/prefixItems"), baseLocation + "/prefixItems", "Items did not match schema", result.getErrorType()));
                                                        if (result.getErrors() != null) {
                                                            errors.addAll(result.getErrors());
                                                        }
                                                        if (stop) break;
                                                    }
                                                    ++var19_61;
                                                }
                                            }
                                            if (!schema.containsKey("items")) break block164;
                                            if (!(schema.get("items") instanceof JsonArray)) break block165;
                                            length2 = Math.min(((JsonArray)schema.get("items")).size(), length);
                                            while (var19_62 < length2) {
                                                result = this.validate(((JsonArray)instance).getValue((int)var19_62), Utils.Schemas.wrap((JsonArray)schema.get("items"), (int)var19_62), recursiveAnchor, instanceLocation + "/" + (int)var19_62, schemaLocation + "/items/" + (int)var19_62, baseLocation + "/items/" + (int)var19_62, new HashSet<Object>(), dynamicContext);
                                                evaluated.add((int)var19_62);
                                                if (!result.getValid().booleanValue()) {
                                                    stop = this.outputFormat == OutputFormat.Flag;
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/items"), baseLocation + "/items", "Items did not match schema", result.getErrorType()));
                                                    if (result.getErrors() != null) {
                                                        errors.addAll(result.getErrors());
                                                    }
                                                    if (stop) break block158;
                                                }
                                                ++var19_62;
                                            }
                                            break block158;
                                        }
                                        case "number": {
                                            double remainder;
                                            if (this.draft == Draft.DRAFT4) {
                                                if (schema.containsKey("minimum") && (schema.get("exclusiveMinimum", false).booleanValue() && Utils.Numbers.lte((Number)instance, schema.get("minimum")) || Utils.Numbers.lt((Number)instance, schema.get("minimum")))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minimum"), baseLocation + "/minimum", instance + " is less than " + (schema.get("exclusiveMinimum", false) != false ? "or equal to " : "") + schema.get("minimum"), OutputErrorType.INVALID_VALUE));
                                                }
                                                if (schema.containsKey("maximum") && (schema.get("exclusiveMaximum", false).booleanValue() && Utils.Numbers.gte((Number)instance, schema.get("maximum")) || Utils.Numbers.gt((Number)instance, schema.get("maximum")))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maximum"), baseLocation + "/maximum", instance + " is greater than " + (schema.get("exclusiveMaximum", false) != false ? "or equal to " : "") + schema.get("maximum"), OutputErrorType.INVALID_VALUE));
                                                }
                                            } else {
                                                if (schema.containsKey("minimum") && Utils.Numbers.lt((Number)instance, schema.get("minimum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minimum"), baseLocation + "/minimum", instance + " is less than " + schema.get("minimum"), OutputErrorType.INVALID_VALUE));
                                                }
                                                if (schema.containsKey("maximum") && Utils.Numbers.gt((Number)instance, schema.get("maximum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maximum"), baseLocation + "/maximum", instance + " is greater than " + schema.get("maximum"), OutputErrorType.INVALID_VALUE));
                                                }
                                                if (schema.containsKey("exclusiveMinimum") && Utils.Numbers.lte((Number)instance, schema.get("exclusiveMinimum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/exclusiveMinimum"), baseLocation + "/exclusiveMinimum", instance + " is less than or equal to " + schema.get("exclusiveMinimum"), OutputErrorType.INVALID_VALUE));
                                                }
                                                if (schema.containsKey("exclusiveMaximum") && Utils.Numbers.gte((Number)instance, schema.get("exclusiveMaximum"))) {
                                                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/exclusiveMaximum"), baseLocation + "/exclusiveMaximum", instance + " is greater than or equal to " + schema.get("exclusiveMaximum"), OutputErrorType.INVALID_VALUE));
                                                }
                                            }
                                            if (schema.containsKey("multipleOf") && Math.abs(0.0 - (remainder = Utils.Numbers.remainder((Number)instance, (Number)schema.get("multipleOf")))) >= 1.1920929E-7 && Math.abs(((Number)schema.get("multipleOf")).doubleValue() - remainder) >= 1.1920929E-7) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/multipleOf"), baseLocation + "/multipleOf", instance + " is not a multiple of " + schema.get("multipleOf"), OutputErrorType.INVALID_VALUE));
                                            }
                                            break block159;
                                        }
                                        case "string": {
                                            int length3;
                                            int n = length3 = !schema.containsKey("minLength") && !schema.containsKey("maxLength") ? 0 : Utils.Strings.ucs2length((String)instance);
                                            if (schema.containsKey("minLength") && Utils.Numbers.lt(length3, schema.get("minLength"))) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minLength"), baseLocation + "/minLength", "String is too short (" + length3 + " < " + schema.get("minLength") + ")", OutputErrorType.INVALID_VALUE));
                                            }
                                            if (schema.containsKey("maxLength") && Utils.Numbers.gt(length3, schema.get("maxLength"))) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maxLength"), baseLocation + "/maxLength", "String is too long (" + length3 + " > " + schema.get("maxLength") + ")", OutputErrorType.INVALID_VALUE));
                                            }
                                            if (schema.containsKey("pattern") && !Pattern.compile((String)schema.get("pattern")).matcher((String)instance).find()) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/pattern"), baseLocation + "/pattern", "String does not match pattern", OutputErrorType.INVALID_VALUE));
                                            }
                                            if (schema.containsKey("format") && !Format.fastFormat((String)schema.get("format"), (String)instance)) {
                                                errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/format"), baseLocation + "/format", "String does not match format \"" + schema.get("format") + "\"", OutputErrorType.INVALID_VALUE));
                                            }
                                            if (this.draft.isAfter(Draft.DRAFT4) && schema.containsKey("contentEncoding") && !Format.testContentEncoding((String)schema.get("contentEncoding"), (String)instance)) {
                                                OutputUnit outputUnit = new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/contentEncoding"), baseLocation + "/contentEncoding", "String does not match the content encoding \"" + schema.get("contentEncoding") + "\"", OutputErrorType.INVALID_VALUE);
                                                if (this.draft.isAfter(Draft.DRAFT7)) {
                                                    annotations.add(outputUnit);
                                                    break block159;
                                                } else {
                                                    errors.add(outputUnit);
                                                }
                                            }
                                            break block159;
                                        }
                                        default: {
                                            break block159;
                                        }
                                    }
                                    if (stop2 || !schema.containsKey("additionalProperties")) break block166;
                                    propsOrSchema = ((JsonObject)instance).fieldNames().iterator();
                                    break block167;
                                }
                                if (stop2 || !schema.containsKey("unevaluatedProperties")) break block159;
                                propsOrSchema = ((JsonObject)instance).fieldNames().iterator();
                                break block168;
                            }
                            while (propsOrSchema.hasNext()) {
                                key3 = (String)propsOrSchema.next();
                                if (hashSet.contains(key3)) continue;
                                subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key3);
                                result2 = this.validate(((JsonObject)instance).getValue(key3), Utils.Schemas.wrap((JsonObject)schema, "additionalProperties"), recursiveAnchor, subInstancePointer, schemaLocation + "/additionalProperties", baseLocation + "/additionalProperties", new HashSet<Object>(), dynamicContext);
                                if (((OutputUnit)result2).getValid().booleanValue()) {
                                    evaluated.add(key3);
                                    continue;
                                }
                                stop2 = this.outputFormat == OutputFormat.Flag;
                                errors.add(new OutputUnit(subInstancePointer, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/additionalProperties"), baseLocation + "/additionalProperties", "Property \"" + key3 + "\" does not match additional properties schema", ((OutputUnit)result2).getErrorType()));
                                if (((OutputUnit)result2).getErrors() != null) {
                                    errors.addAll(((OutputUnit)result2).getErrors());
                                }
                                if (!stop2) continue;
                                break block159;
                            }
                            break block159;
                        }
                        while (propsOrSchema.hasNext()) {
                            key3 = (String)propsOrSchema.next();
                            if (evaluated.contains(key3)) continue;
                            subInstancePointer = instanceLocation + "/" + Utils.Pointers.encode(key3);
                            result2 = this.validate(((JsonObject)instance).getValue(key3), Utils.Schemas.wrap((JsonObject)schema, "unevaluatedProperties"), recursiveAnchor, subInstancePointer, schemaLocation + "/unevaluatedProperties", baseLocation + "/unevaluatedProperties", new HashSet<Object>(), dynamicContext);
                            if (((OutputUnit)result2).getValid().booleanValue()) {
                                evaluated.add(key3);
                                continue;
                            }
                            errors.add(new OutputUnit(subInstancePointer, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/unevaluatedProperties"), baseLocation + "/unevaluatedProperties", "Property \"" + key3 + "\" does not match unevaluated properties schema", ((OutputUnit)result2).getErrorType()));
                            if (((OutputUnit)result2).getErrors() == null) continue;
                            errors.addAll(((OutputUnit)result2).getErrors());
                        }
                        break block159;
                    }
                    while (var19_63 < length) {
                        OutputUnit result10 = this.validate(((JsonArray)instance).getValue((int)var19_63), Utils.Schemas.wrap((JsonObject)schema, "items"), recursiveAnchor, instanceLocation + "/" + (int)var19_63, schemaLocation + "/items", baseLocation + "/items", new HashSet<Object>(), dynamicContext);
                        evaluated.add((int)var19_63);
                        if (!result10.getValid().booleanValue()) {
                            stop = this.outputFormat == OutputFormat.Flag;
                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/items"), baseLocation + "/items", "Items did not match schema", result10.getErrorType()));
                            if (result10.getErrors() != null) {
                                errors.addAll(result10.getErrors());
                            }
                            if (stop) break;
                        }
                        ++var19_63;
                    }
                }
                if (!stop && schema.containsKey("additionalItems")) {
                    String keywordLocation2 = schemaLocation + "/additionalItems";
                    while (var19_65 < length) {
                        result = this.validate(((JsonArray)instance).getValue((int)var19_65), Utils.Schemas.wrap((JsonObject)schema, "additionalItems"), recursiveAnchor, instanceLocation + "/" + (int)var19_65, keywordLocation2, baseLocation + "/additionalItems", new HashSet<Object>(), dynamicContext);
                        evaluated.add((int)var19_65);
                        if (!result.getValid().booleanValue()) {
                            stop = this.outputFormat == OutputFormat.Flag;
                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/additionalItems"), schemaLocation + "/additionalItems", "Items did not match additional items schema", result.getErrorType()));
                            if (result.getErrors() != null) {
                                errors.addAll(result.getErrors());
                            }
                        }
                        ++var19_65;
                    }
                }
            }
            if (schema.containsKey("contains")) {
                if (length == 0 && !schema.containsKey("minContains")) {
                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/contains"), baseLocation + "/contains", "Array is empty. It must contain at least one item matching the schema", OutputErrorType.MISSING_VALUE));
                } else if (schema.containsKey("minContains") && length < (Integer)schema.get("minContains")) {
                    errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minContains"), baseLocation + "/minContains", "Array has less items (" + length + ") than minContains (" + schema.get("minContains") + ")", OutputErrorType.MISSING_VALUE));
                } else {
                    int errorsLength = errors.size();
                    int contained = 0;
                    for (int j = 0; j < length; ++j) {
                        OutputUnit result = this.validate(((JsonArray)instance).getValue(j), Utils.Schemas.wrap((JsonObject)schema, "contains"), recursiveAnchor, instanceLocation + "/" + (int)var19_65, schemaLocation + "/contains", baseLocation + "/contains", new HashSet<Object>(), dynamicContext);
                        if (result.getValid().booleanValue()) {
                            evaluated.add(j);
                            ++contained;
                            continue;
                        }
                        if (result.getErrors() == null) continue;
                        errors.addAll(result.getErrors());
                    }
                    if (contained >= schema.get("minContains", 0)) {
                        errors = errors.subList(0, Math.min(errors.size(), errorsLength));
                    }
                    if (!schema.containsKey("minContains") && !schema.containsKey("maxContains") && contained == 0) {
                        errors.add(errorsLength, new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/contains"), baseLocation + "/contains", "Array does not contain item matching schema", OutputErrorType.INVALID_VALUE));
                    } else if (schema.containsKey("minContains") && contained < (Integer)schema.get("minContains")) {
                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/minContains"), baseLocation + "/minContains", "Array must contain at least " + schema.get("minContains") + " items matching schema. Only " + contained + " items were found", OutputErrorType.MISSING_VALUE));
                    } else if (schema.containsKey("maxContains") && contained > (Integer)schema.get("maxContains")) {
                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/maxContains"), baseLocation + "/maxContains", "Array may contain at most " + schema.get("minContains") + " items matching schema. " + contained + " items were found", OutputErrorType.INVALID_VALUE));
                    }
                }
            }
            if (!stop && schema.containsKey("unevaluatedItems")) {
                void var19_66;
                while (var19_66 < length) {
                    if (!evaluated.contains((int)var19_66)) {
                        OutputUnit result = this.validate(((JsonArray)instance).getValue((int)var19_66), Utils.Schemas.wrap((JsonObject)schema, "unevaluatedItems"), recursiveAnchor, instanceLocation + "/" + (int)var19_66, schemaLocation + "/unevaluatedItems", baseLocation + "/unevaluatedItems", new HashSet<Object>(), dynamicContext);
                        evaluated.add((int)var19_66);
                        if (!result.getValid().booleanValue()) {
                            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/unevaluatedItems"), baseLocation + "/unevaluatedItems", "Items did not match unevaluated items schema", result.getErrorType()));
                            if (result.getErrors() != null) {
                                errors.addAll(result.getErrors());
                            }
                        }
                    }
                    ++var19_66;
                }
            }
            if (schema.containsKey("uniqueItems") && Utils.Objects.truthy(schema.get("uniqueItems"))) {
                for (int j = 0; j < length; ++j) {
                    Object a = ((JsonArray)instance).getValue(j);
                    boolean ao = "object".equals(Utils.JSON.typeOf(a)) && a != null;
                    for (int k2 = 0; k2 < length; ++k2) {
                        boolean bo;
                        if (j == k2) continue;
                        Object b = ((JsonArray)instance).getValue(k2);
                        boolean bl = bo = "object".equals(Utils.JSON.typeOf(b)) && b != null;
                        if (!Utils.Objects.equals(a, b) && (!ao || !bo || !Utils.JSON.deepCompare(a, b))) continue;
                        errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/uniqueItems"), baseLocation + "/uniqueItems", "Duplicate items at indexes " + j + " and " + k2, OutputErrorType.INVALID_VALUE));
                        break block159;
                    }
                }
            }
        }
        String error = this.formatValidator.validateFormat(instanceType, (String)schema.get("format"), instance);
        if (error != null) {
            errors.add(new OutputUnit(instanceLocation, this.computeAbsoluteKeywordLocation(schema, schemaLocation + "/format"), baseLocation + "/format", error, OutputErrorType.INVALID_VALUE));
        }
        if (dynamicAnchor != null) {
            dynamicContext.get(dynamicAnchor).removeLast();
        }
        OutputUnit outputUnit = new OutputUnit(errors.isEmpty()).setErrors(this.outputFormat == OutputFormat.Flag ? null : (errors.isEmpty() ? null : errors)).setAnnotations(this.outputFormat == OutputFormat.Flag ? null : (annotations.isEmpty() ? null : annotations));
        if (this.outputFormat == OutputFormat.Flag) {
            outputErrorType = OutputErrorType.NONE;
            return outputUnit.setErrorType(outputErrorType);
        }
        if (errors.isEmpty()) {
            outputErrorType = OutputErrorType.NONE;
            return outputUnit.setErrorType(outputErrorType);
        }
        outputErrorType = errors.get(0).getErrorType();
        return outputUnit.setErrorType(outputErrorType);
    }

    private String computeAbsoluteKeywordLocation(JsonSchema schema, String schemaKeywordLocation) {
        if (schemaKeywordLocation == null) {
            return null;
        }
        String absoluteUri = (String)schema.get("__absolute_uri__");
        if (absoluteUri == null) {
            return null;
        }
        return new URL(schemaKeywordLocation, absoluteUri).href();
    }
}

