/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import io.vertx.core.json.JsonArray;
import io.vertx.json.schema.internal.JsonProxyEncoder;
import java.io.StringWriter;
import java.util.Objects;

public class JsonArrayProxy
extends JsonArray
implements JsonProxyEncoder {
    public String encode() {
        StringWriter sw = new StringWriter();
        JsonGenerator generator = this.createGenerator(sw, false);
        return this.encode(sw, generator);
    }

    public String encodePrettily() {
        StringWriter sw = new StringWriter();
        JsonGenerator generator = this.createGenerator(sw, true);
        return this.encode(sw, generator);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonArray)) {
            return false;
        }
        JsonArray other = (JsonArray)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object otherValue;
            Object thisValue = this.getValue(i);
            if (thisValue == (otherValue = other.getValue(i))) continue;
            if (thisValue instanceof Number && otherValue instanceof Number && thisValue.getClass() != otherValue.getClass()) {
                Number n1 = (Number)thisValue;
                Number n2 = (Number)otherValue;
                if ((thisValue instanceof Float || thisValue instanceof Double || otherValue instanceof Float || otherValue instanceof Double) && n1.doubleValue() == n2.doubleValue() || (thisValue instanceof Integer || thisValue instanceof Long || otherValue instanceof Integer || otherValue instanceof Long) && n1.longValue() == n2.longValue()) continue;
            }
            if (thisValue instanceof CharSequence && otherValue instanceof CharSequence && thisValue.getClass() != otherValue.getClass()) {
                CharSequence s1 = (CharSequence)thisValue;
                CharSequence s2 = (CharSequence)otherValue;
                if (Objects.equals(s1.toString(), s2.toString())) continue;
            }
            if (Objects.equals(thisValue, otherValue)) continue;
            return false;
        }
        return true;
    }
}

