/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.OutputErrorType;
import io.vertx.json.schema.OutputUnit;
import java.util.ArrayList;
import java.util.Map;

public class OutputUnitConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, OutputUnit obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "valid": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setValid((Boolean)member.getValue());
                    break;
                }
                case "absoluteKeywordLocation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAbsoluteKeywordLocation((String)member.getValue());
                    break;
                }
                case "keywordLocation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKeywordLocation((String)member.getValue());
                    break;
                }
                case "instanceLocation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setInstanceLocation((String)member.getValue());
                    break;
                }
                case "error": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setError((String)member.getValue());
                    break;
                }
                case "errors": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<OutputUnit> list = new ArrayList<OutputUnit>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new OutputUnit((JsonObject)item));
                        }
                    });
                    obj.setErrors(list);
                    break;
                }
                case "annotations": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<OutputUnit> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new OutputUnit((JsonObject)item));
                        }
                    });
                    obj.setAnnotations(list);
                    break;
                }
                case "errorType": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setErrorType(OutputErrorType.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(OutputUnit obj, JsonObject json) {
        OutputUnitConverter.toJson(obj, json.getMap());
    }

    static void toJson(OutputUnit obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getValid() != null) {
            json.put("valid", obj.getValid());
        }
        if (obj.getAbsoluteKeywordLocation() != null) {
            json.put("absoluteKeywordLocation", obj.getAbsoluteKeywordLocation());
        }
        if (obj.getKeywordLocation() != null) {
            json.put("keywordLocation", obj.getKeywordLocation());
        }
        if (obj.getInstanceLocation() != null) {
            json.put("instanceLocation", obj.getInstanceLocation());
        }
        if (obj.getError() != null) {
            json.put("error", obj.getError());
        }
        if (obj.getErrors() != null) {
            array = new JsonArray();
            obj.getErrors().forEach(item -> array.add((Object)item.toJson()));
            json.put("errors", array);
        }
        if (obj.getAnnotations() != null) {
            array = new JsonArray();
            obj.getAnnotations().forEach(item -> array.add((Object)item.toJson()));
            json.put("annotations", array);
        }
        if (obj.getErrorType() != null) {
            json.put("errorType", obj.getErrorType().name());
        }
    }
}

