/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.json.schema.impl.Utils;
import java.net.IDN;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;

public class Format {
    private static final Pattern BASE16 = Pattern.compile("[0-9a-f]", 2);
    private static final Pattern BASE32 = Pattern.compile("^(?:[A-Z2-7]{8})*(?:[A-Z2-7]{2}={6}|[A-Z2-7]{4}={4}|[A-Z2-7]{5}={3}|[A-Z2-7]{7}=)?$");
    private static final Pattern BASE64 = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
    private static final Pattern RELATIVE_JSON_POINTER = Pattern.compile("^(?:0|[1-9][0-9]*)(?:#|(?:\\/(?:[^~/]|~0|~1)*)*)$");
    private static final Pattern JSON_POINTER_URI_FRAGMENT = Pattern.compile("^#(?:\\/(?:[a-z0-9_\\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$", 2);
    private static final Pattern JSON_POINTER = Pattern.compile("^(?:\\/(?:[^~/]|~0|~1)*)*$");
    private static final Pattern UUID = Pattern.compile("^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$", 2);
    private static final Pattern Z_ANCHOR = Pattern.compile("[^\\\\]\\\\Z");
    private static final Pattern IPV6 = Pattern.compile("^((([0-9a-f]{1,4}:){7}([0-9a-f]{1,4}|:))|(([0-9a-f]{1,4}:){6}(:[0-9a-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9a-f]{1,4}:){5}(((:[0-9a-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9a-f]{1,4}:){4}(((:[0-9a-f]{1,4}){1,3})|((:[0-9a-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){3}(((:[0-9a-f]{1,4}){1,4})|((:[0-9a-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){2}(((:[0-9a-f]{1,4}){1,5})|((:[0-9a-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){1}(((:[0-9a-f]{1,4}){1,6})|((:[0-9a-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9a-f]{1,4}){1,7})|((:[0-9a-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))$", 2);
    private static final Pattern IPV4 = Pattern.compile("^(?:(?:25[0-5]|2[0-4]\\d|[1]?\\d\\d?)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$");
    private static final Pattern HOSTNAME = Pattern.compile("^(?=.{1,253}\\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\\.?$", 2);
    private static final Pattern EMAIL_HOST = Pattern.compile("^[a-z0-9.-]+$", 2);
    private static final Pattern EMAIL_NAME = Pattern.compile("^[a-z0-9.!#$%&'*+/=?^_`\\{|\\}~-]+$", 2);
    private static final Pattern EMAIL_HOST_PART = Pattern.compile("^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$", 2);
    private static final Pattern URL_ = Pattern.compile("^(?:(?:https?|ftp):\\/\\/)(?:\\S+(?::\\S*)?@)?(?:(?!10(?:\\.\\d{1,3}){3})(?!127(?:\\.\\d{1,3}){3})(?!169\\.254(?:\\.\\d{1,3}){2})(?!192\\.168(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))(?::\\d{2,5})?(?:\\/[^\\s]*)?$", 66);
    private static final Pattern IDN_EMAIL_PUNY = Pattern.compile("^xn--[a-z0-9-.]*@[a-z0-9-.]*$");
    private static final Pattern IDN_EMAIL_HOST = Pattern.compile("^[a-z0-9-.]*");
    private static final Pattern IDN_EMAIL_NAME = Pattern.compile("^xn--[a-z0-9-.]*$");
    private static final Pattern IDN_EMAIL_HOST_PART = Pattern.compile("^[a-z0-9-]([a-z0-9-]{0,61}[a-z0-9-])?$");
    private static final Pattern NOT_URI_FRAGMENT = Pattern.compile("\\/|:");
    private static final Pattern URI_PATTERN = Pattern.compile("^(?:[a-z][a-z0-9+\\-.]*:)(?:\\/?\\/(?:(?:[a-z0-9\\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\\.[a-z0-9\\-._~!$&'()*+,;=:]+)\\]|(?:(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)|(?:[a-z0-9\\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\\d*)?(?:\\/(?:[a-z0-9\\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\\/(?:(?:[a-z0-9\\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\\/(?:[a-z0-9\\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\\/(?:[a-z0-9\\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\\?(?:[a-z0-9\\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$", 2);
    private static final Pattern URIREF = Pattern.compile("^(?:[a-z][a-z0-9+\\-.]*:)?(?:\\/?\\/(?:(?:[a-z0-9\\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\\.[a-z0-9\\-._~!$&'()*+,;=:]+)\\]|(?:(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d\\d?)|(?:[a-z0-9\\-._~!$&'\"()*+,;=]|%[0-9a-f]{2})*)(?::\\d*)?(?:\\/(?:[a-z0-9\\-._~!$&'\"()*+,;=:@]|%[0-9a-f]{2})*)*|\\/(?:(?:[a-z0-9\\-._~!$&'\"()*+,;=:@]|%[0-9a-f]{2})+(?:\\/(?:[a-z0-9\\-._~!$&'\"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\\-._~!$&'\"()*+,;=:@]|%[0-9a-f]{2})+(?:\\/(?:[a-z0-9\\-._~!$&'\"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\\?(?:[a-z0-9\\-._~!$&'\"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\\-._~!$&'\"()*+,;=:@/?]|%[0-9a-f]{2})*)?$", 2);
    private static final Pattern URITEMPLATE = Pattern.compile("^(?:(?:[^\\x00-\\x20\"'<>%\\\\^`\\{|\\}]|%[0-9a-f]{2})|\\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\\*)?)*\\})*$", 2);
    private static final Pattern DURATION_A = Pattern.compile("^P\\d+([.,]\\d+)?W$");
    private static final Pattern DURATION_B = Pattern.compile("^P[\\dYMDTHS]*(\\d[.,]\\d+)?[YMDHS]$");
    private static final Pattern DURATION_C = Pattern.compile("^P([.,\\d]+Y)?([.,\\d]+M)?([.,\\d]+D)?(T([.,\\d]+H)?([.,\\d]+M)?([.,\\d]+S)?)?$");
    private static final Pattern FASTDATETIME = Pattern.compile("^\\d\\d\\d\\d-[0-1]\\d-[0-3]\\d[t\\s](?:[0-2]\\d:[0-5]\\d:[0-5]\\d|23:59:60)(?:\\.\\d+)?(?:z?|[+-]\\d\\d(?::?\\d\\d)?)$", 2);
    private static final Pattern IDN_HOSTNAME_PUNY = Pattern.compile("^xn--[a-z0-9-.]*$");
    private static final Pattern IDN_HOSTNAME_UNICODE = Pattern.compile("^.*\\u302e.*|(^.*?[^l]\\u00b7.|.*l\\u00b7[^l]|\\u00b7$|^\\u00b7.)|(.*\\u30fB[^\\u3041\\u30A1\\u4e08].*|^\\u30fB$)|(^[\\u05f3\\u05f4].*)$", 256);
    private static final Pattern IDN_HOSTNAME_STARTING_ERRORS = Pattern.compile("^\\p{gc=Mc}|^\\p{gc=Me}|^\\p{gc=Mn}(?!\\u094d)", 256);
    private static final Pattern FASTTIME = Pattern.compile("^(?:[0-2]\\d:[0-5]\\d:[0-5]\\d|23:59:60)(?:\\.\\d+)?(?:z|[+-]\\d\\d(?::?\\d\\d)?)?$", 2);
    private static final Pattern VALID_LEAP_SECONDS = Pattern.compile("^23:59:60(?:\\.\\d+)?(?:z|[+-]00(?::?00)?)?$", 2);
    private static final Pattern FASTDATE = Pattern.compile("^\\d\\d\\d\\d-[0-1]\\d-[0-3]\\d$");

    public static boolean fastFormat(String format, String value) {
        switch (format) {
            case "byte": {
                return Format.checkPattern(value, BASE64);
            }
            case "date": {
                return Format.testDate(value);
            }
            case "time": {
                return Format.testTime(value);
            }
            case "date-time": {
                return Format.testDateTime(value);
            }
            case "duration": {
                return Format.testDuration(value);
            }
            case "uri": {
                return Format.checkPattern(value, NOT_URI_FRAGMENT) && Format.checkPattern(value, URI_PATTERN);
            }
            case "uri-reference": {
                return Format.checkPattern(value, URIREF);
            }
            case "uri-template": {
                return Format.checkPattern(value, URITEMPLATE);
            }
            case "url": {
                return Format.checkPattern(value, URL_);
            }
            case "email": {
                return Format.testEmail(value);
            }
            case "hostname": {
                return Format.checkPattern(value, HOSTNAME);
            }
            case "ipv4": {
                return Format.checkPattern(value, IPV4);
            }
            case "ipv6": {
                return Format.checkPattern(value, IPV6);
            }
            case "regex": {
                return Format.testRegex(value);
            }
            case "uuid": {
                return Format.checkPattern(value, UUID);
            }
            case "json-pointer": {
                return Format.checkPattern(value, JSON_POINTER);
            }
            case "json-pointer-uri-fragment": {
                return Format.checkPattern(value, JSON_POINTER_URI_FRAGMENT);
            }
            case "relative-json-pointer": {
                return Format.checkPattern(value, RELATIVE_JSON_POINTER);
            }
            case "idn-hostname": {
                return Format.testIdnHostname(value);
            }
            case "idn-email": {
                return Format.testIdnEmail(value);
            }
        }
        return true;
    }

    public static boolean testContentEncoding(String format, String value) {
        switch (format) {
            case "base64": {
                return Format.checkPattern(value, BASE64);
            }
            case "base32": {
                return Format.checkPattern(value, BASE32);
            }
            case "base16": {
                return Format.checkPattern(value, BASE16);
            }
        }
        return true;
    }

    private static boolean checkPattern(String value, Pattern p) {
        return p.matcher(value).find();
    }

    private static boolean testRegex(String value) {
        if (Format.checkPattern(value, Z_ANCHOR)) {
            return false;
        }
        try {
            Pattern.compile(value);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static boolean testEmail(String value) {
        return Format.testEmail(value, EMAIL_HOST, EMAIL_NAME, EMAIL_HOST_PART);
    }

    private static boolean testEmail(String value, Pattern emailHostMatcher, Pattern emailNameMatcher, Pattern emailHostPartMatcher) {
        if (value.charAt(0) == '\"') {
            return false;
        }
        String[] parts = value.split("@");
        if (parts.length != 2 || Utils.Strings.empty(parts[0]) || Utils.Strings.empty(parts[1]) || parts[0].length() > 64 || parts[1].length() > 253) {
            return false;
        }
        if (parts[0].charAt(0) == '.' || parts[0].endsWith(".") || parts[0].contains("..")) {
            return false;
        }
        if (!Format.checkPattern(parts[1], emailHostMatcher) || !Format.checkPattern(parts[0], emailNameMatcher)) {
            return false;
        }
        for (String part : parts[1].split("\\.")) {
            if (Format.checkPattern(part, emailHostPartMatcher)) continue;
            return false;
        }
        return true;
    }

    private static boolean testDuration(String value) {
        return value.length() > 1 && value.length() < 80 && (Format.checkPattern(value, DURATION_A) || Format.checkPattern(value, DURATION_B) && Format.checkPattern(value, DURATION_C));
    }

    private static boolean testDateTime(String value) {
        if (!Format.checkPattern(value, FASTDATETIME)) {
            return false;
        }
        return Format.validateISOTime(DateTimeFormatter.ISO_DATE_TIME, value);
    }

    private static boolean testTime(String value) {
        if (!Format.checkPattern(value, FASTTIME)) {
            return false;
        }
        if (Format.checkPattern(value, VALID_LEAP_SECONDS)) {
            return true;
        }
        return Format.validateISOTime(DateTimeFormatter.ISO_TIME, value);
    }

    private static boolean testDate(String value) {
        if (!Format.checkPattern(value, FASTDATE)) {
            return false;
        }
        return Format.validateISOTime(DateTimeFormatter.ISO_DATE, value);
    }

    private static boolean validateISOTime(DateTimeFormatter formatter, String value) {
        try {
            formatter.parse(value);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private static boolean testIdnHostname(String value) {
        try {
            return !Format.checkPattern(value, IDN_HOSTNAME_STARTING_ERRORS) && !Format.checkPattern(value, IDN_HOSTNAME_UNICODE) && Format.checkPattern(IDN.toASCII(value), IDN_HOSTNAME_PUNY);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean testIdnEmail(String value) {
        try {
            String asciiVersion = IDN.toASCII(value);
            if (asciiVersion.equals(value)) {
                return Format.testEmail(asciiVersion);
            }
            return Format.checkPattern(asciiVersion, IDN_EMAIL_PUNY) && Format.testEmail(asciiVersion, IDN_EMAIL_HOST, IDN_EMAIL_NAME, IDN_EMAIL_HOST_PART);
        }
        catch (Exception e) {
            return false;
        }
    }
}

