/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.VertxException;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.common.ValidationExceptionImpl;
import java.util.Collection;

public abstract class ValidationException
extends VertxException {
    private final String keyword;
    private final Object input;
    protected JsonPointer inputScope;

    protected ValidationException(String message, String keyword, Object input) {
        this(message, null, keyword, input);
    }

    protected ValidationException(String message, String keyword, Object input, boolean noStackTrace) {
        this(message, null, keyword, input, noStackTrace);
    }

    protected ValidationException(String message, Throwable cause, String keyword, Object input) {
        super(message, cause);
        this.keyword = keyword;
        this.input = input;
    }

    protected ValidationException(String message, Throwable cause, String keyword, Object input, boolean noStackTrace) {
        super(message, cause, noStackTrace);
        this.keyword = keyword;
        this.input = input;
    }

    public static ValidationException create(String message, String keyword, Object input, Collection<Throwable> causes) {
        return new ValidationExceptionImpl(message, causes, keyword, input);
    }

    public static ValidationException create(String message, String keyword, Object input, Throwable cause) {
        return new ValidationExceptionImpl(message, cause, keyword, input);
    }

    public static ValidationException create(String message, String keyword, Object input) {
        return new ValidationExceptionImpl(message, keyword, input);
    }

    public @Nullable String keyword() {
        return this.keyword;
    }

    public Object input() {
        return this.input;
    }

    public JsonPointer inputScope() {
        return this.inputScope;
    }

    public String toString() {
        return "ValidationException{message='" + this.getMessage() + "', keyword='" + this.keyword + "', input=" + String.valueOf(this.input) + (String)(this.inputScope != null ? ", inputScope=" + String.valueOf(this.inputScope.toURI()) : "") + "}";
    }
}

