/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.VertxGen;

@VertxGen
public enum Draft {
    DRAFT4("http://json-schema.org/draft-04/schema#", 0),
    DRAFT7("http://json-schema.org/draft-07/schema#", 1),
    DRAFT201909("https://json-schema.org/draft/2019-09/schema", 2),
    DRAFT202012("https://json-schema.org/draft/2020-12/schema", 3);

    private final String identifier;
    private final int order;

    private Draft(String identifier, int order) {
        this.identifier = identifier;
        this.order = order;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static Draft from(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid draft: null");
        }
        switch (string) {
            case "4": {
                return DRAFT4;
            }
            case "7": {
                return DRAFT7;
            }
            case "8": 
            case "2019-09": {
                return DRAFT201909;
            }
            case "2020-12": {
                return DRAFT202012;
            }
        }
        throw new IllegalArgumentException("Unsupported draft: " + string);
    }

    public static Draft fromIdentifier(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid draft identifier: null");
        }
        if (Draft.DRAFT4.identifier.equals(string)) {
            return DRAFT4;
        }
        if (Draft.DRAFT7.identifier.equals(string)) {
            return DRAFT7;
        }
        if (Draft.DRAFT201909.identifier.equals(string)) {
            return DRAFT201909;
        }
        if (Draft.DRAFT202012.identifier.equals(string)) {
            return DRAFT202012;
        }
        throw new IllegalArgumentException("Unsupported draft identifier: " + string);
    }

    public boolean isAfter(Draft draft) {
        return draft.order < this.order;
    }

    public boolean isBefore(Draft draft) {
        return draft.order > this.order;
    }
}

