/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.impl.JsonObjectRef;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface JsonProxyEncoder {
    public static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    public static final JsonFactory factory = new JsonFactory().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    public static final String KEY_ABS_URI = "__absolute_uri__";

    default public JsonGenerator createGenerator(Writer out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
    }

    default public String encode(StringWriter sw, JsonGenerator generator) {
        this.encodeJson(this, generator);
        try {
            generator.flush();
            return sw.toString();
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage(), (Throwable)e);
        }
    }

    default public void encodeJson(Object json, JsonGenerator generator) throws EncodeException {
        block34: {
            try {
                JsonObjectRef ref;
                String string;
                if (json instanceof JsonObjectRef && (string = (ref = (JsonObjectRef)((Object)json)).getString(KEY_ABS_URI)) != null) {
                    generator.writeStartObject();
                    generator.writeStringField("$ref", string);
                    generator.writeEndObject();
                    return;
                }
                if (json instanceof JsonObject) {
                    Iterator properties = ((JsonObject)json).getMap();
                    json = properties.entrySet().stream().filter(JsonSchema.EXCLUDE_ANNOTATION_ENTRIES).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                } else if (json instanceof JsonArray) {
                    json = ((JsonArray)json).getList();
                }
                if (json instanceof Map) {
                    generator.writeStartObject();
                    for (Map.Entry entry : ((Map)json).entrySet()) {
                        generator.writeFieldName((String)entry.getKey());
                        this.encodeJson(entry.getValue(), generator);
                    }
                    generator.writeEndObject();
                    break block34;
                }
                if (json instanceof List) {
                    generator.writeStartArray();
                    for (Object e : (List)((Object)json)) {
                        this.encodeJson(e, generator);
                    }
                    generator.writeEndArray();
                    break block34;
                }
                if (json instanceof String) {
                    generator.writeString((String)((Object)json));
                    break block34;
                }
                if (json instanceof Number) {
                    if (json instanceof Short) {
                        generator.writeNumber(((Short)((Object)json)).shortValue());
                    } else if (json instanceof Integer) {
                        generator.writeNumber(((Integer)((Object)json)).intValue());
                    } else if (json instanceof Long) {
                        generator.writeNumber(((Long)((Object)json)).longValue());
                    } else if (json instanceof Float) {
                        generator.writeNumber(((Float)((Object)json)).floatValue());
                    } else if (json instanceof Double) {
                        generator.writeNumber(((Double)((Object)json)).doubleValue());
                    } else if (json instanceof Byte) {
                        generator.writeNumber((short)((Byte)((Object)json)).byteValue());
                    } else if (json instanceof BigInteger) {
                        generator.writeNumber((BigInteger)((Object)json));
                    } else if (json instanceof BigDecimal) {
                        generator.writeNumber((BigDecimal)((Object)json));
                    } else {
                        generator.writeNumber(((Number)((Object)json)).doubleValue());
                    }
                    break block34;
                }
                if (json instanceof Boolean) {
                    generator.writeBoolean(((Boolean)((Object)json)).booleanValue());
                    break block34;
                }
                if (json instanceof Instant) {
                    generator.writeString(DateTimeFormatter.ISO_INSTANT.format((Instant)((Object)json)));
                    break block34;
                }
                if (json instanceof byte[]) {
                    generator.writeString(BASE64_ENCODER.encodeToString((byte[])json));
                    break block34;
                }
                if (json instanceof Buffer) {
                    generator.writeString(BASE64_ENCODER.encodeToString(((Buffer)json).getBytes()));
                    break block34;
                }
                if (json instanceof Enum) {
                    generator.writeString(((Enum)((Object)json)).name());
                    break block34;
                }
                if (json == null) {
                    generator.writeNull();
                    break block34;
                }
                throw new EncodeException("Mapping " + json.getClass().getName() + "  is not available without Jackson Databind on the classpath");
            }
            catch (IOException e) {
                throw new EncodeException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

