/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5.web;

import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.web.WebClientOptionsInject;
import io.vertx.rxjava.ext.web.client.WebClient;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class VertxWebClientExtension
implements ParameterResolver {
    private static String WEB_CLIENT = "WebClient";
    private static String RX1_WEB_CLIENT = "Rx1WebClient";
    private static String RX2_WEB_CLIENT = "Rx2WebClient";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return type.equals(io.vertx.ext.web.client.WebClient.class) || type.equals(io.vertx.reactivex.ext.web.client.WebClient.class) || type.equals(WebClient.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        ExtensionContext.Store store = extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{VertxWebClientExtension.class, extensionContext}));
        if (io.vertx.ext.web.client.WebClient.class.equals(type)) {
            return this.getWebClient(parameterContext, extensionContext, store);
        }
        if (WebClient.class.equals(type)) {
            return this.getRx1WebClient(parameterContext, extensionContext, store);
        }
        if (io.vertx.reactivex.ext.web.client.WebClient.class.equals(type)) {
            return this.getRx2WebClient(parameterContext, extensionContext, store);
        }
        throw new IllegalStateException("Looks like the ParameterResolver needs a fix...");
    }

    private io.vertx.ext.web.client.WebClient getWebClient(ParameterContext parameterContext, ExtensionContext extensionContext, ExtensionContext.Store myStore) {
        Vertx vertx = VertxExtension.retrieveVertx((Executable)parameterContext.getDeclaringExecutable(), (ExtensionContext)extensionContext);
        WebClientOptions webClientOptions = this.getWebClientOptions(extensionContext).orElse(new WebClientOptions());
        return (io.vertx.ext.web.client.WebClient)myStore.getOrComputeIfAbsent((Object)WEB_CLIENT, s -> io.vertx.ext.web.client.WebClient.create((Vertx)vertx, (WebClientOptions)webClientOptions), io.vertx.ext.web.client.WebClient.class);
    }

    private WebClient getRx1WebClient(ParameterContext parameterContext, ExtensionContext extensionContext, ExtensionContext.Store myStore) {
        io.vertx.rxjava.core.Vertx vertx = VertxExtension.retrieveRxJava1Vertx((Executable)parameterContext.getDeclaringExecutable(), (ExtensionContext)extensionContext);
        WebClientOptions webClientOptions = this.getWebClientOptions(extensionContext).orElse(new WebClientOptions());
        return (WebClient)myStore.getOrComputeIfAbsent((Object)RX1_WEB_CLIENT, s -> WebClient.create((io.vertx.rxjava.core.Vertx)vertx, (WebClientOptions)webClientOptions), WebClient.class);
    }

    private io.vertx.reactivex.ext.web.client.WebClient getRx2WebClient(ParameterContext parameterContext, ExtensionContext extensionContext, ExtensionContext.Store myStore) {
        io.vertx.reactivex.core.Vertx vertx = VertxExtension.retrieveRxJava2Vertx((Executable)parameterContext.getDeclaringExecutable(), (ExtensionContext)extensionContext);
        WebClientOptions webClientOptions = this.getWebClientOptions(extensionContext).orElse(new WebClientOptions());
        return (io.vertx.reactivex.ext.web.client.WebClient)myStore.getOrComputeIfAbsent((Object)RX2_WEB_CLIENT, s -> io.vertx.reactivex.ext.web.client.WebClient.create((io.vertx.reactivex.core.Vertx)vertx, (WebClientOptions)webClientOptions), io.vertx.reactivex.ext.web.client.WebClient.class);
    }

    private Optional<WebClientOptions> getWebClientOptions(ExtensionContext context) {
        Optional thisTestClass = context.getTestClass();
        if (!thisTestClass.isPresent()) {
            return Optional.empty();
        }
        List webClientOptionsField = AnnotationUtils.findPublicAnnotatedFields((Class)((Class)thisTestClass.get()), WebClientOptions.class, WebClientOptionsInject.class);
        if (webClientOptionsField.isEmpty()) {
            return Optional.empty();
        }
        return ReflectionUtils.tryToReadFieldValue((Field)((Field)webClientOptionsField.get(0)), context.getTestInstance().get()).toOptional().map(o -> (WebClientOptions)o);
    }
}

