/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.junit5.Checkpoint;
import java.util.Objects;
import java.util.function.Consumer;

final class CountingCheckpoint
implements Checkpoint {
    private final Consumer<Checkpoint> satisfactionTrigger;
    private final Consumer<Throwable> overuseTrigger;
    private final int requiredNumberOfPasses;
    private int numberOfPasses = 0;

    static CountingCheckpoint laxCountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, int requiredNumberOfPasses) {
        return new CountingCheckpoint(satisfactionTrigger, null, requiredNumberOfPasses);
    }

    static CountingCheckpoint strictCountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, Consumer<Throwable> overuseTrigger, int requiredNumberOfPasses) {
        Objects.requireNonNull(overuseTrigger);
        return new CountingCheckpoint(satisfactionTrigger, overuseTrigger, requiredNumberOfPasses);
    }

    private CountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, Consumer<Throwable> overuseTrigger, int requiredNumberOfPasses) {
        Objects.requireNonNull(satisfactionTrigger);
        if (requiredNumberOfPasses <= 0) {
            throw new IllegalArgumentException("A checkpoint needs at least 1 pass");
        }
        this.satisfactionTrigger = satisfactionTrigger;
        this.overuseTrigger = overuseTrigger;
        this.requiredNumberOfPasses = requiredNumberOfPasses;
    }

    private boolean isStrict() {
        return this.overuseTrigger != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flag() {
        boolean callOveruseTrigger;
        boolean callSatisfactionTrigger;
        CountingCheckpoint countingCheckpoint = this;
        synchronized (countingCheckpoint) {
            ++this.numberOfPasses;
            callSatisfactionTrigger = this.numberOfPasses == this.requiredNumberOfPasses;
            callOveruseTrigger = this.isStrict() && this.numberOfPasses > this.requiredNumberOfPasses;
        }
        if (callSatisfactionTrigger) {
            this.satisfactionTrigger.accept(this);
        } else if (callOveruseTrigger) {
            this.overuseTrigger.accept(new IllegalStateException("Strict checkpoint flagged too many times"));
        }
    }
}

