/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;

public final class VertxExtension
implements ParameterResolver,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final int DEFAULT_TIMEOUT_DURATION = 30;
    private static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final String TEST_CONTEXT_KEY = "VertxTestContext";
    private final String VERTX_INSTANCE_KEY = "VertxInstance";
    private final String VERTX_INSTANCE_CREATOR_KEY = "VertxInstanceCreator";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = this.parameterType(parameterContext);
        return type == VertxTestContext.class || type == Vertx.class;
    }

    private Class<?> parameterType(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = this.parameterType(parameterContext);
        ExtensionContext.Store store = this.store(extensionContext);
        if (type == Vertx.class) {
            ExtensionContext.Store parentStore;
            if (extensionContext.getParent().isPresent() && (parentStore = this.store((ExtensionContext)extensionContext.getParent().get())).get((Object)"VertxInstance") != null) {
                return parentStore.get((Object)"VertxInstance");
            }
            if (store.get((Object)"VertxInstance") == null) {
                Executable injectionTarget = parameterContext.getDeclaringExecutable();
                if (AnnotationUtils.isAnnotated((AnnotatedElement)injectionTarget, BeforeAll.class)) {
                    store.put((Object)"VertxInstanceCreator", (Object)VertxInstanceCreator.BEFORE_ALL);
                } else if (AnnotationUtils.isAnnotated((AnnotatedElement)injectionTarget, BeforeEach.class)) {
                    store.put((Object)"VertxInstanceCreator", (Object)VertxInstanceCreator.BEFORE_EACH);
                } else {
                    store.put((Object)"VertxInstanceCreator", (Object)VertxInstanceCreator.TEST);
                }
            }
            return store.getOrComputeIfAbsent((Object)"VertxInstance", key -> Vertx.vertx());
        }
        if (type == VertxTestContext.class) {
            ContextList contexts = (ContextList)store.getOrComputeIfAbsent((Object)"VertxTestContext", key -> new ContextList());
            VertxTestContext newTestContext = new VertxTestContext();
            contexts.add(newTestContext);
            return newTestContext;
        }
        throw new IllegalStateException("Looks like the ParameterResolver needs a fix...");
    }

    private ExtensionContext.Store store(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{VertxExtension.class, extensionContext}));
    }

    public void beforeAll(ExtensionContext context) throws Exception {
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
        this.checkAndRemoveVertxInstance(context, VertxInstanceCreator.BEFORE_ALL);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
        this.checkAndRemoveVertxInstance(context, VertxInstanceCreator.BEFORE_EACH);
    }

    private void checkAndRemoveVertxInstance(ExtensionContext context, VertxInstanceCreator stage) throws Exception {
        ExtensionContext.Store store = this.store(context);
        if (store.get((Object)"VertxInstanceCreator") == stage) {
            store.remove((Object)"VertxInstanceCreator");
            Vertx vertx = (Vertx)store.remove((Object)"VertxInstance", Vertx.class);
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        }
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
        this.checkAndRemoveVertxInstance(context, VertxInstanceCreator.TEST);
    }

    private void joinActiveTestContexts(ExtensionContext extensionContext) throws Exception {
        if (extensionContext.getExecutionException().isPresent()) {
            return;
        }
        ContextList currentContexts = (ContextList)this.store(extensionContext).remove((Object)"VertxTestContext", ContextList.class);
        if (currentContexts != null) {
            for (VertxTestContext context : currentContexts) {
                Timeout annotation;
                int timeoutDuration = 30;
                TimeUnit timeoutUnit = DEFAULT_TIMEOUT_UNIT;
                Optional testMethod = extensionContext.getTestMethod();
                if (testMethod.isPresent() && ((Method)testMethod.get()).isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestMethod().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                } else if (extensionContext.getRequiredTestClass().isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestClass().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                }
                if (context.awaitCompletion(timeoutDuration, timeoutUnit)) {
                    if (!context.failed()) continue;
                    Throwable throwable = context.causeOfFailure();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw new AssertionError((Object)throwable);
                }
                throw new TimeoutException("The test execution timed out");
            }
        }
        if (extensionContext.getParent().isPresent()) {
            this.joinActiveTestContexts((ExtensionContext)extensionContext.getParent().get());
        }
    }

    private static enum VertxInstanceCreator {
        BEFORE_ALL,
        BEFORE_EACH,
        TEST;

    }

    private static class ContextList
    extends ArrayList<VertxTestContext> {
        private ContextList() {
        }
    }
}

