/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;

public final class VertxExtension
implements ParameterResolver,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final int DEFAULT_TIMEOUT_DURATION = 30;
    private static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final String TEST_CONTEXT_KEY = "VertxTestContext";
    private final String VERTX_INSTANCE_KEY = "VertxInstance";
    private final String VERTX_INSTANCE_CREATOR_KEY = "VertxInstanceCreator";
    private final String VERTX_RX1_INSTANCE_KEY = "VertxRx1Instance";
    private final String VERTX_RX1_INSTANCE_CREATOR_KEY = "VertxRx1InstanceCreator";
    private final String VERTX_RX2_INSTANCE_KEY = "VertxRx2Instance";
    private final String VERTX_RX2_INSTANCE_CREATOR_KEY = "VertxRx2InstanceCreator";
    private static final HashSet<Class> INJECTABLE_TYPES = new HashSet<Class>(){
        {
            this.add(Vertx.class);
            this.add(VertxTestContext.class);
            this.add(io.vertx.rxjava.core.Vertx.class);
            this.add(io.vertx.reactivex.core.Vertx.class);
        }
    };

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return INJECTABLE_TYPES.contains(this.parameterType(parameterContext));
    }

    private Class<?> parameterType(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = this.parameterType(parameterContext);
        if (type == Vertx.class) {
            return this.getOrCreateScopedObject(parameterContext, extensionContext, "VertxInstance", "VertxInstanceCreator", key -> new ScopedObject<Vertx>(Vertx.vertx(), this.closeRegularVertx()));
        }
        if (type == io.vertx.rxjava.core.Vertx.class) {
            return this.getOrCreateScopedObject(parameterContext, extensionContext, "VertxRx1Instance", "VertxRx1InstanceCreator", key -> new ScopedObject<io.vertx.rxjava.core.Vertx>(io.vertx.rxjava.core.Vertx.vertx(), this.closeRx1Vertx()));
        }
        if (type == io.vertx.reactivex.core.Vertx.class) {
            return this.getOrCreateScopedObject(parameterContext, extensionContext, "VertxRx2Instance", "VertxRx2InstanceCreator", key -> new ScopedObject<io.vertx.reactivex.core.Vertx>(io.vertx.reactivex.core.Vertx.vertx(), this.closeRx2Vertx()));
        }
        if (type == VertxTestContext.class) {
            return this.newTestContext(extensionContext);
        }
        throw new IllegalStateException("Looks like the ParameterResolver needs a fix...");
    }

    private Object getOrCreateScopedObject(ParameterContext parameterContext, ExtensionContext extensionContext, String instanceKey, String phaseCreatorKey, Function<String, Object> creatorFunction) {
        ExtensionContext.Store parentStore;
        ExtensionContext.Store store = this.store(extensionContext);
        if (extensionContext.getParent().isPresent() && (parentStore = this.store((ExtensionContext)extensionContext.getParent().get())).get((Object)instanceKey) != null) {
            return this.unpack(parentStore.get((Object)instanceKey));
        }
        if (store.get((Object)instanceKey) == null) {
            store.put((Object)phaseCreatorKey, (Object)this.scopeFor(parameterContext.getDeclaringExecutable()));
        }
        return this.unpack(store.getOrComputeIfAbsent((Object)instanceKey, creatorFunction));
    }

    private Object unpack(Object object) {
        if (object instanceof Supplier) {
            return ((Supplier)object).get();
        }
        return object;
    }

    private VertxTestContext newTestContext(ExtensionContext extensionContext) {
        ExtensionContext.Store store = this.store(extensionContext);
        ContextList contexts = (ContextList)store.getOrComputeIfAbsent((Object)"VertxTestContext", key -> new ContextList());
        VertxTestContext newTestContext = new VertxTestContext();
        contexts.add(newTestContext);
        return newTestContext;
    }

    private CreationScope scopeFor(Executable injectionTarget) {
        if (AnnotationUtils.isAnnotated((AnnotatedElement)injectionTarget, BeforeAll.class)) {
            return CreationScope.BEFORE_ALL;
        }
        if (AnnotationUtils.isAnnotated((AnnotatedElement)injectionTarget, BeforeEach.class)) {
            return CreationScope.BEFORE_EACH;
        }
        return CreationScope.TEST;
    }

    private ExtensionContext.Store store(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{VertxExtension.class, extensionContext}));
    }

    public void beforeAll(ExtensionContext context) throws Exception {
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    private void joinActiveTestContexts(ExtensionContext extensionContext) throws Exception {
        if (extensionContext.getExecutionException().isPresent()) {
            return;
        }
        ContextList currentContexts = (ContextList)this.store(extensionContext).remove((Object)"VertxTestContext", ContextList.class);
        if (currentContexts != null) {
            for (VertxTestContext context : currentContexts) {
                Timeout annotation;
                int timeoutDuration = 30;
                TimeUnit timeoutUnit = DEFAULT_TIMEOUT_UNIT;
                Optional testMethod = extensionContext.getTestMethod();
                if (testMethod.isPresent() && ((Method)testMethod.get()).isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestMethod().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                } else if (extensionContext.getRequiredTestClass().isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestClass().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                }
                if (context.awaitCompletion(timeoutDuration, timeoutUnit)) {
                    if (!context.failed()) continue;
                    Throwable throwable = context.causeOfFailure();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw new AssertionError((Object)throwable);
                }
                throw new TimeoutException("The test execution timed out. Make sure your asynchronous code includes calls to either VertxTestContext#completeNow(), VertxTestContext#failNow() or Checkpoint#flag()");
            }
        }
        if (extensionContext.getParent().isPresent()) {
            this.joinActiveTestContexts((ExtensionContext)extensionContext.getParent().get());
        }
    }

    private ThrowingConsumer<Vertx> closeRegularVertx() {
        return vertx -> {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    private ThrowingConsumer<io.vertx.rxjava.core.Vertx> closeRx1Vertx() {
        return vertx -> {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    private ThrowingConsumer<io.vertx.reactivex.core.Vertx> closeRx2Vertx() {
        return vertx -> {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    private static class ScopedObject<T>
    implements Supplier<T>,
    ExtensionContext.Store.CloseableResource {
        private final T object;
        private final ThrowingConsumer<T> cleaner;

        ScopedObject(T object, ThrowingConsumer<T> cleaner) {
            this.object = object;
            this.cleaner = cleaner;
        }

        public void close() throws Throwable {
            this.cleaner.accept(this.object);
        }

        @Override
        public T get() {
            return this.object;
        }
    }

    @FunctionalInterface
    private static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    private static enum CreationScope {
        BEFORE_ALL,
        BEFORE_EACH,
        TEST;

    }

    private static class ContextList
    extends ArrayList<VertxTestContext> {
        private ContextList() {
        }
    }
}

