/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.CountingCheckpoint;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class VertxTestContext {
    private Throwable throwableReference = null;
    private final CountDownLatch releaseLatch = new CountDownLatch(1);
    private final HashSet<Checkpoint> checkpoints = new HashSet();

    public synchronized boolean failed() {
        return this.throwableReference != null;
    }

    public synchronized Throwable causeOfFailure() {
        return this.throwableReference;
    }

    public synchronized boolean completed() {
        return !this.failed() && this.releaseLatch.getCount() == 0L;
    }

    public synchronized void completeNow() {
        this.releaseLatch.countDown();
    }

    public synchronized void failNow(Throwable t) {
        Objects.requireNonNull(t, "The exception cannot be null");
        if (!this.completed()) {
            this.throwableReference = t;
            this.releaseLatch.countDown();
        }
    }

    private synchronized void checkpointSatisfied(Checkpoint checkpoint) {
        this.checkpoints.remove(checkpoint);
        if (this.checkpoints.isEmpty()) {
            this.completeNow();
        }
    }

    public Checkpoint laxCheckpoint() {
        return this.laxCheckpoint(1);
    }

    public synchronized Checkpoint laxCheckpoint(int requiredNumberOfPasses) {
        CountingCheckpoint checkpoint = CountingCheckpoint.laxCountingCheckpoint(this::checkpointSatisfied, requiredNumberOfPasses);
        this.checkpoints.add(checkpoint);
        return checkpoint;
    }

    public Checkpoint checkpoint() {
        return this.checkpoint(1);
    }

    public synchronized Checkpoint checkpoint(int requiredNumberOfPasses) {
        CountingCheckpoint checkpoint = CountingCheckpoint.strictCountingCheckpoint(this::checkpointSatisfied, this::failNow, requiredNumberOfPasses);
        this.checkpoints.add(checkpoint);
        return checkpoint;
    }

    public <T> Handler<AsyncResult<T>> succeeding() {
        return ar -> {
            if (!ar.succeeded()) {
                this.failNow(ar.cause());
            }
        };
    }

    public <T> Handler<AsyncResult<T>> succeeding(Handler<T> nextHandler) {
        Objects.requireNonNull(nextHandler, "The handler cannot be null");
        return ar -> {
            if (ar.succeeded()) {
                nextHandler.handle(ar.result());
            } else {
                this.failNow(ar.cause());
            }
        };
    }

    public <T> Handler<AsyncResult<T>> failing() {
        return ar -> {
            if (ar.succeeded()) {
                this.failNow((Throwable)((Object)new AssertionError((Object)"The asynchronous result was expected to have failed")));
            }
        };
    }

    public <T> Handler<AsyncResult<T>> failing(Handler<Throwable> nextHandler) {
        Objects.requireNonNull(nextHandler, "The handler cannot be null");
        return ar -> {
            if (ar.succeeded()) {
                this.failNow((Throwable)((Object)new AssertionError((Object)"The asynchronous result was expected to have failed")));
            } else {
                nextHandler.handle((Object)ar.cause());
            }
        };
    }

    public <T> Handler<AsyncResult<T>> completing() {
        return ar -> {
            if (ar.succeeded()) {
                this.completeNow();
            } else {
                this.failNow(ar.cause());
            }
        };
    }

    public <T> Future<T> assertComplete(Future<T> fut) {
        Promise newPromise = Promise.promise();
        fut.setHandler(ar -> {
            if (ar.succeeded()) {
                newPromise.complete(ar.result());
            } else {
                AssertionError ex = new AssertionError("Future failed with exception: " + ar.cause().getMessage(), ar.cause());
                this.failNow((Throwable)((Object)ex));
                newPromise.fail((Throwable)((Object)ex));
            }
        });
        return newPromise.future();
    }

    public <T> Future<T> assertFailure(Future<T> fut) {
        Promise newPromise = Promise.promise();
        fut.setHandler(ar -> {
            if (ar.succeeded()) {
                AssertionError ex = new AssertionError((Object)("Future completed with value: " + ar.result()));
                this.failNow((Throwable)((Object)ex));
                newPromise.fail((Throwable)((Object)ex));
            } else {
                newPromise.fail(ar.cause());
            }
        });
        return newPromise.future();
    }

    public VertxTestContext verify(ExecutionBlock block) {
        Objects.requireNonNull(block, "The block cannot be null");
        try {
            block.apply();
        }
        catch (Throwable t) {
            this.failNow(t);
        }
        return this;
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.failed() || this.releaseLatch.await(timeout, unit);
    }

    @FunctionalInterface
    public static interface ExecutionBlock {
        public void apply() throws Throwable;
    }
}

