/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;

public final class VertxExtension
implements ParameterResolver,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final int DEFAULT_TIMEOUT_DURATION = 30;
    private static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final String TEST_CONTEXT_KEY = "VertxTestContext";
    private static final String VERTX_INSTANCE_KEY = "VertxInstance";
    private static final String VERTX_INSTANCE_CREATOR_KEY = "VertxInstanceCreator";
    private static final String VERTX_RX1_INSTANCE_KEY = "VertxRx1Instance";
    private static final String VERTX_RX1_INSTANCE_CREATOR_KEY = "VertxRx1InstanceCreator";
    private static final String VERTX_RX2_INSTANCE_KEY = "VertxRx2Instance";
    private static final String VERTX_RX2_INSTANCE_CREATOR_KEY = "VertxRx2InstanceCreator";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String parameterType = this.parameterType(parameterContext);
        return parameterType.equals("io.vertx.core.Vertx") || parameterType.equals("io.vertx.junit5.VertxTestContext") || parameterType.equals("io.vertx.rxjava.core.Vertx") || parameterType.equals("io.vertx.reactivex.core.Vertx");
    }

    private String parameterType(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().getName();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        switch (this.parameterType(parameterContext)) {
            case "io.vertx.core.Vertx": {
                return VertxExtension.retrieveVertx(parameterContext.getDeclaringExecutable(), extensionContext);
            }
            case "io.vertx.rxjava.core.Vertx": {
                return VertxExtension.retrieveRxJava1Vertx(parameterContext.getDeclaringExecutable(), extensionContext);
            }
            case "io.vertx.reactivex.core.Vertx": {
                return VertxExtension.retrieveRxJava2Vertx(parameterContext.getDeclaringExecutable(), extensionContext);
            }
            case "io.vertx.junit5.VertxTestContext": {
                return this.newTestContext(extensionContext);
            }
        }
        throw new IllegalStateException("Looks like the ParameterResolver needs a fix...");
    }

    private static Object getOrCreateScopedObject(Executable declaringExecutable, ExtensionContext extensionContext, String instanceKey, String phaseCreatorKey, Function<String, Object> creatorFunction) {
        ExtensionContext.Store parentStore;
        ExtensionContext.Store store = VertxExtension.store(extensionContext);
        if (extensionContext.getParent().isPresent() && (parentStore = VertxExtension.store((ExtensionContext)extensionContext.getParent().get())).get((Object)instanceKey) != null) {
            return VertxExtension.unpack(parentStore.get((Object)instanceKey));
        }
        if (store.get((Object)phaseCreatorKey) == null) {
            store.put((Object)phaseCreatorKey, (Object)VertxExtension.scopeFor(declaringExecutable));
        }
        return VertxExtension.unpack(store.getOrComputeIfAbsent((Object)instanceKey, creatorFunction));
    }

    private static Object unpack(Object object) {
        if (object instanceof Supplier) {
            return ((Supplier)object).get();
        }
        return object;
    }

    private void putScopedObject(ExtensionContext extensionContext, String instanceKey, Function<String, Object> creatorObject) {
        VertxExtension.store(extensionContext).getOrComputeIfAbsent((Object)instanceKey, creatorObject);
    }

    private VertxTestContext newTestContext(ExtensionContext extensionContext) {
        ExtensionContext.Store store = VertxExtension.store(extensionContext);
        ContextList contexts = (ContextList)store.getOrComputeIfAbsent((Object)TEST_CONTEXT_KEY, key -> new ContextList());
        VertxTestContext newTestContext = new VertxTestContext();
        contexts.add(newTestContext);
        return newTestContext;
    }

    private static CreationScope scopeFor(Executable injectionTarget) {
        if (AnnotationUtils.isAnnotated((AnnotatedElement)injectionTarget, BeforeAll.class)) {
            return CreationScope.BEFORE_ALL;
        }
        if (AnnotationUtils.isAnnotated((AnnotatedElement)injectionTarget, BeforeEach.class)) {
            return CreationScope.BEFORE_EACH;
        }
        return CreationScope.TEST;
    }

    private static ExtensionContext.Store store(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.GLOBAL);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    private void joinActiveTestContexts(ExtensionContext extensionContext) throws Exception {
        if (extensionContext.getExecutionException().isPresent()) {
            return;
        }
        ContextList currentContexts = (ContextList)VertxExtension.store(extensionContext).remove((Object)TEST_CONTEXT_KEY, ContextList.class);
        if (currentContexts != null) {
            for (VertxTestContext context : currentContexts) {
                Timeout annotation;
                int timeoutDuration = 30;
                TimeUnit timeoutUnit = DEFAULT_TIMEOUT_UNIT;
                Optional testMethod = extensionContext.getTestMethod();
                if (testMethod.isPresent() && ((Method)testMethod.get()).isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestMethod().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                } else if (extensionContext.getRequiredTestClass().isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestClass().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                }
                if (context.awaitCompletion(timeoutDuration, timeoutUnit)) {
                    if (!context.failed()) continue;
                    Throwable throwable = context.causeOfFailure();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw new AssertionError((Object)throwable);
                }
                throw new TimeoutException("The test execution timed out. Make sure your asynchronous code includes calls to either VertxTestContext#completeNow(), VertxTestContext#failNow() or Checkpoint#flag()");
            }
        }
        if (extensionContext.getParent().isPresent()) {
            this.joinActiveTestContexts((ExtensionContext)extensionContext.getParent().get());
        }
    }

    private static ThrowingConsumer<Vertx> closeRegularVertx() {
        return vertx -> {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    private static ThrowingConsumer<io.vertx.rxjava.core.Vertx> closeRx1Vertx() {
        return vertx -> {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    private static ThrowingConsumer<io.vertx.reactivex.core.Vertx> closeRx2Vertx() {
        return vertx -> {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    public static Vertx retrieveVertx(Executable declaringExecutable, ExtensionContext context) {
        return (Vertx)VertxExtension.getOrCreateScopedObject(declaringExecutable, context, VERTX_INSTANCE_KEY, VERTX_INSTANCE_CREATOR_KEY, key -> new ScopedObject<Vertx>(Vertx::vertx, VertxExtension.closeRegularVertx()));
    }

    public static io.vertx.rxjava.core.Vertx retrieveRxJava1Vertx(Executable declaringExecutable, ExtensionContext context) {
        return (io.vertx.rxjava.core.Vertx)VertxExtension.getOrCreateScopedObject(declaringExecutable, context, VERTX_RX1_INSTANCE_KEY, VERTX_RX1_INSTANCE_CREATOR_KEY, key -> new ScopedObject<io.vertx.rxjava.core.Vertx>(io.vertx.rxjava.core.Vertx::vertx, VertxExtension.closeRx1Vertx()));
    }

    public static io.vertx.reactivex.core.Vertx retrieveRxJava2Vertx(Executable declaringExecutable, ExtensionContext context) {
        return (io.vertx.reactivex.core.Vertx)VertxExtension.getOrCreateScopedObject(declaringExecutable, context, VERTX_RX2_INSTANCE_KEY, VERTX_RX2_INSTANCE_CREATOR_KEY, key -> new ScopedObject<io.vertx.reactivex.core.Vertx>(io.vertx.reactivex.core.Vertx::vertx, VertxExtension.closeRx2Vertx()));
    }

    private static class ScopedObject<T>
    implements Supplier<T>,
    ExtensionContext.Store.CloseableResource {
        private final Supplier<T> supplier;
        private T object;
        private final ThrowingConsumer<T> cleaner;

        ScopedObject(Supplier<T> supplier, ThrowingConsumer<T> cleaner) {
            this.supplier = supplier;
            this.cleaner = cleaner;
        }

        public void close() throws Throwable {
            if (this.object != null) {
                this.cleaner.accept(this.object);
            }
        }

        @Override
        public T get() {
            if (this.object == null) {
                this.object = this.supplier.get();
            }
            return this.object;
        }
    }

    @FunctionalInterface
    private static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    private static enum CreationScope {
        BEFORE_ALL,
        BEFORE_EACH,
        TEST;

    }

    private static class ContextList
    extends ArrayList<VertxTestContext> {
        private ContextList() {
        }
    }
}

