/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.ParameterClosingConsumer;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxExtensionParameterProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;

public class VertxParameterProvider
implements VertxExtensionParameterProvider<Vertx> {
    public static final String VERTX_PARAMETER_FILENAME = "vertx.parameter.filename";

    @Override
    public Class<Vertx> type() {
        return Vertx.class;
    }

    @Override
    public String key() {
        return "Vertx";
    }

    @Override
    public Vertx newInstance(ExtensionContext extensionContext, ParameterContext parameterContext) {
        JsonObject parameters = this.getVertxOptions();
        VertxOptions options = new VertxOptions(parameters);
        return Vertx.vertx((VertxOptions)options);
    }

    @Override
    public ParameterClosingConsumer<Vertx> parameterClosingConsumer() {
        return vertx -> {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(30L, VertxExtension.DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    public JsonObject getVertxOptions() {
        JsonObject parameters = new JsonObject();
        String optionFileName = System.getenv(VERTX_PARAMETER_FILENAME);
        if (optionFileName != null) {
            Path path = Paths.get(optionFileName, new String[0]);
            try {
                String read = Files.readAllLines(path, StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
                parameters.mergeIn(new JsonObject(read));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return parameters;
    }
}

