/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.VertxTestContext;
import java.util.Objects;
import java.util.function.Consumer;

public final class CountingCheckpoint
implements Checkpoint {
    private final Consumer<Checkpoint> satisfactionTrigger;
    private final Consumer<Throwable> overuseTrigger;
    private final int requiredNumberOfPasses;
    private final StackTraceElement creationCallSite;
    private int numberOfPasses = 0;
    private boolean satisfied = false;

    public static CountingCheckpoint laxCountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, int requiredNumberOfPasses) {
        return new CountingCheckpoint(satisfactionTrigger, null, requiredNumberOfPasses);
    }

    public static CountingCheckpoint strictCountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, Consumer<Throwable> overuseTrigger, int requiredNumberOfPasses) {
        Objects.requireNonNull(overuseTrigger);
        return new CountingCheckpoint(satisfactionTrigger, overuseTrigger, requiredNumberOfPasses);
    }

    private CountingCheckpoint(Consumer<Checkpoint> satisfactionTrigger, Consumer<Throwable> overuseTrigger, int requiredNumberOfPasses) {
        Objects.requireNonNull(satisfactionTrigger);
        if (requiredNumberOfPasses <= 0) {
            throw new IllegalArgumentException("A checkpoint needs at least 1 pass");
        }
        this.creationCallSite = this.findCallSite();
        this.satisfactionTrigger = satisfactionTrigger;
        this.overuseTrigger = overuseTrigger;
        this.requiredNumberOfPasses = requiredNumberOfPasses;
    }

    private StackTraceElement findCallSite() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            if (!stackTrace[i].getClassName().equals(VertxTestContext.class.getName())) continue;
            return stackTrace[i + 1];
        }
        return stackTrace[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flag() {
        boolean callSatisfactionTrigger = false;
        boolean callOveruseTrigger = false;
        CountingCheckpoint countingCheckpoint = this;
        synchronized (countingCheckpoint) {
            if (this.satisfied) {
                callOveruseTrigger = true;
            } else {
                ++this.numberOfPasses;
                if (this.numberOfPasses == this.requiredNumberOfPasses) {
                    callSatisfactionTrigger = true;
                    this.satisfied = true;
                }
            }
        }
        if (callSatisfactionTrigger) {
            this.satisfactionTrigger.accept(this);
        } else if (callOveruseTrigger && this.overuseTrigger != null) {
            this.overuseTrigger.accept(new IllegalStateException("Strict checkpoint flagged too many times"));
        }
    }

    public boolean satisfied() {
        return this.satisfied;
    }

    public StackTraceElement creationCallSite() {
        return this.creationCallSite;
    }
}

