/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.internal.VertxInternal;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class RunTestOnContext
implements BeforeAllCallback,
InvocationInterceptor,
AfterEachCallback,
AfterAllCallback {
    private volatile boolean staticExtension;
    private volatile Vertx vertx;
    private volatile Context context;
    private final Supplier<Future<Vertx>> supplier;
    private final Function<Vertx, Future<Void>> shutdown;

    public RunTestOnContext() {
        this(new VertxOptions(), false);
    }

    public RunTestOnContext(VertxOptions options, boolean clustered) {
        this(() -> clustered ? Vertx.clusteredVertx((VertxOptions)options) : Future.succeededFuture((Object)Vertx.vertx((VertxOptions)options)));
    }

    public RunTestOnContext(Supplier<Future<Vertx>> supplier) {
        this(supplier, Vertx::close);
    }

    public RunTestOnContext(Supplier<Future<Vertx>> supplier, Function<Vertx, Future<Void>> shutdown) {
        this.supplier = supplier;
        this.shutdown = shutdown;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public void beforeAll(ExtensionContext context) {
        this.staticExtension = true;
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runOnContext(invocation);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runOnContext(invocation);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runOnContext(invocation);
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return this.runOnContext(invocation);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runOnContext(invocation);
    }

    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        this.runOnContext(invocation);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runOnContext(invocation);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runOnContext(invocation);
    }

    private <T> T runOnContext(InvocationInterceptor.Invocation<T> invocation) throws Throwable {
        Future vertxFuture = this.vertx != null ? Future.succeededFuture((Object)this.vertx) : this.supplier.get().onSuccess(vertx -> {
            this.vertx = vertx;
            this.context = ((VertxInternal)vertx).createEventLoopContext();
        });
        CompletableFuture cf = vertxFuture.compose(ignore -> {
            Promise promise = Promise.promise();
            this.context.runOnContext(v -> {
                try {
                    promise.complete(invocation.proceed());
                }
                catch (Throwable e) {
                    promise.fail(e);
                }
            });
            return promise.future();
        }).toCompletionStage().toCompletableFuture();
        try {
            return cf.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.staticExtension) {
            return;
        }
        this.cleanUp();
    }

    private void cleanUp() throws Exception {
        this.context = null;
        if (this.vertx == null) {
            return;
        }
        Future<Void> closeFuture = this.shutdown.apply(this.vertx);
        this.vertx = null;
        try {
            closeFuture.toCompletionStage().toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.cleanUp();
    }
}

