/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.ext.auth.jwt.Crypto;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

final class CryptoPrivateKey
implements Crypto {
    private final Signature sig;
    private final PrivateKey privateKey;

    CryptoPrivateKey(String algorithm, PrivateKey privateKey) {
        Signature signature;
        this.privateKey = privateKey;
        try {
            signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.sig = signature;
    }

    @Override
    public synchronized byte[] sign(byte[] payload) {
        try {
            this.sig.initSign(this.privateKey);
            this.sig.update(payload);
            return this.sig.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean verify(byte[] signature, byte[] payload) {
        throw new RuntimeException("CryptoPrivateKey cannot verify");
    }
}

