/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.serialization.BufferDeserializer;
import io.vertx.kafka.client.serialization.BufferSerializer;
import io.vertx.kafka.client.serialization.JsonArrayDeserializer;
import io.vertx.kafka.client.serialization.JsonArraySerializer;
import io.vertx.kafka.client.serialization.JsonObjectDeserializer;
import io.vertx.kafka.client.serialization.JsonObjectSerializer;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.ByteBufferSerializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;

public class KafkaCodecs {
    private static final ConcurrentMap<Class<?>, Serializer<?>> serializers = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Deserializer<?>> deserializers = new ConcurrentHashMap();

    public static <T> Serializer<T> serializer(Class<T> type) {
        return (Serializer)serializers.get(type);
    }

    public static <T> Deserializer<T> deserializer(Class<T> type) {
        return (Deserializer)deserializers.get(type);
    }

    static {
        serializers.put(JsonObject.class, new JsonObjectSerializer());
        serializers.put(JsonArray.class, new JsonArraySerializer());
        serializers.put(Buffer.class, new BufferSerializer());
        serializers.put(Double.class, (Serializer<?>)new DoubleSerializer());
        serializers.put(Integer.class, (Serializer<?>)new IntegerSerializer());
        serializers.put(String.class, (Serializer<?>)new StringSerializer());
        serializers.put(byte[].class, (Serializer<?>)new ByteArraySerializer());
        serializers.put(Long.class, (Serializer<?>)new LongSerializer());
        serializers.put(Bytes.class, (Serializer<?>)new BytesSerializer());
        serializers.put(ByteBuffer.class, (Serializer<?>)new ByteBufferSerializer());
        deserializers.put(JsonObject.class, new JsonObjectDeserializer());
        deserializers.put(JsonArray.class, new JsonArrayDeserializer());
        deserializers.put(Buffer.class, new BufferDeserializer());
        deserializers.put(Double.class, (Deserializer<?>)new DoubleDeserializer());
        deserializers.put(Integer.class, (Deserializer<?>)new IntegerDeserializer());
        deserializers.put(String.class, (Deserializer<?>)new StringDeserializer());
        deserializers.put(byte[].class, (Deserializer<?>)new ByteArrayDeserializer());
        deserializers.put(Long.class, (Deserializer<?>)new LongDeserializer());
        deserializers.put(Bytes.class, (Deserializer<?>)new BytesDeserializer());
        deserializers.put(ByteBuffer.class, (Deserializer<?>)new ByteBufferDeserializer());
    }
}

