/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.WriteStream;
import io.vertx.kafka.client.producer.impl.KafkaWriteStreamImpl;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;

public interface KafkaWriteStream<K, V>
extends WriteStream<ProducerRecord<K, V>> {
    public static final int DEFAULT_MAX_SIZE = 0x100000;

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Properties config) {
        return KafkaWriteStreamImpl.create(vertx, config);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        return KafkaWriteStreamImpl.create(vertx, config, keyType, valueType);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Map<String, Object> config) {
        return KafkaWriteStreamImpl.create(vertx, config);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Map<String, Object> config, Class<K> keyType, Class<V> valueType) {
        return KafkaWriteStreamImpl.create(vertx, config, keyType, valueType);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Producer<K, V> producer) {
        return new KafkaWriteStreamImpl<K, V>(vertx.getOrCreateContext(), producer);
    }

    public KafkaWriteStream<K, V> write(ProducerRecord<K, V> var1, Handler<AsyncResult<RecordMetadata>> var2);

    public KafkaWriteStream<K, V> partitionsFor(String var1, Handler<AsyncResult<List<PartitionInfo>>> var2);

    public KafkaWriteStream<K, V> flush(Handler<Void> var1);

    public void close();

    public void close(long var1, Handler<Void> var3);

    public Producer<K, V> producer();
}

