/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.kafka.client.common.impl.Helper;
import io.vertx.kafka.client.producer.KafkaProducer;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import io.vertx.kafka.client.producer.KafkaWriteStream;
import io.vertx.kafka.client.producer.RecordMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.PartitionInfo;

public class KafkaProducerImpl<K, V>
implements KafkaProducer<K, V> {
    private final KafkaWriteStream<K, V> stream;

    public KafkaProducerImpl(KafkaWriteStream<K, V> stream) {
        this.stream = stream;
    }

    @Override
    public KafkaProducer<K, V> exceptionHandler(Handler<Throwable> handler) {
        this.stream.exceptionHandler(handler);
        return this;
    }

    @Override
    public KafkaProducer<K, V> write(KafkaProducerRecord<K, V> kafkaProducerRecord) {
        this.stream.write(kafkaProducerRecord.record());
        return this;
    }

    @Override
    public KafkaProducer<K, V> write(KafkaProducerRecord<K, V> record, Handler<AsyncResult<RecordMetadata>> handler) {
        this.stream.write(record.record(), (Handler<AsyncResult<org.apache.kafka.clients.producer.RecordMetadata>>)((Handler)done -> {
            if (done.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)Helper.from((org.apache.kafka.clients.producer.RecordMetadata)done.result())));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)done.cause()));
            }
        }));
        return this;
    }

    @Override
    public KafkaProducer<K, V> partitionsFor(String topic, Handler<AsyncResult<List<io.vertx.kafka.client.common.PartitionInfo>>> handler) {
        this.stream.partitionsFor(topic, (Handler<AsyncResult<List<PartitionInfo>>>)((Handler)done -> {
            if (done.succeeded()) {
                ArrayList<io.vertx.kafka.client.common.PartitionInfo> partitions = new ArrayList<io.vertx.kafka.client.common.PartitionInfo>();
                for (PartitionInfo kafkaPartitionInfo : (List)done.result()) {
                    io.vertx.kafka.client.common.PartitionInfo partitionInfo = new io.vertx.kafka.client.common.PartitionInfo();
                    partitionInfo.setInSyncReplicas(Stream.of(kafkaPartitionInfo.inSyncReplicas()).map(Helper::from).collect(Collectors.toList())).setLeader(Helper.from(kafkaPartitionInfo.leader())).setPartition(kafkaPartitionInfo.partition()).setReplicas(Stream.of(kafkaPartitionInfo.replicas()).map(Helper::from).collect(Collectors.toList())).setTopic(kafkaPartitionInfo.topic());
                    partitions.add(partitionInfo);
                }
                handler.handle((Object)Future.succeededFuture(partitions));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)done.cause()));
            }
        }));
        return this;
    }

    @Override
    public void end() {
        this.stream.end();
    }

    @Override
    public void end(KafkaProducerRecord<K, V> kafkaProducerRecord) {
        this.stream.end(kafkaProducerRecord.record());
    }

    @Override
    public KafkaProducer<K, V> setWriteQueueMaxSize(int size) {
        this.stream.setWriteQueueMaxSize(size);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.stream.writeQueueFull();
    }

    @Override
    public KafkaProducer<K, V> drainHandler(Handler<Void> handler) {
        this.stream.drainHandler(handler);
        return this;
    }

    @Override
    public KafkaProducer<K, V> flush(Handler<Void> completionHandler) {
        this.stream.flush(completionHandler);
        return this;
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public void close(long timeout, Handler<Void> completionHandler) {
        this.stream.close(timeout, completionHandler);
    }

    @Override
    public KafkaWriteStream<K, V> asStream() {
        return this.stream;
    }

    @Override
    public Producer<K, V> producer() {
        return this.stream.producer();
    }
}

