/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.consumer;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.ReadStream;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import io.vertx.kafka.client.consumer.KafkaReadStream;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import io.vertx.kafka.client.consumer.impl.KafkaConsumerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;

@VertxGen
public interface KafkaConsumer<K, V>
extends ReadStream<KafkaConsumerRecord<K, V>> {
    @GenIgnore
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Consumer<K, V> consumer) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, consumer);
        return new KafkaConsumerImpl<K, V>(stream);
    }

    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Map<String, String> config) {
        KafkaReadStream stream = KafkaReadStream.create(vertx, new HashMap<String, Object>(config));
        return new KafkaConsumerImpl(stream).registerCloseHook();
    }

    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Map<String, String> config, Class<K> keyType, Class<V> valueType) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, new HashMap<String, Object>(config), keyType, valueType);
        return new KafkaConsumerImpl<K, V>(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Properties config) {
        KafkaReadStream stream = KafkaReadStream.create(vertx, config);
        return new KafkaConsumerImpl(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, config, keyType, valueType);
        return new KafkaConsumerImpl<K, V>(stream).registerCloseHook();
    }

    @Fluent
    public KafkaConsumer<K, V> exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public KafkaConsumer<K, V> handler(Handler<KafkaConsumerRecord<K, V>> var1);

    @Fluent
    public KafkaConsumer<K, V> pause();

    @Fluent
    public KafkaConsumer<K, V> resume();

    @Fluent
    public KafkaConsumer<K, V> endHandler(Handler<Void> var1);

    @Fluent
    public KafkaConsumer<K, V> subscribe(String var1);

    @Fluent
    public KafkaConsumer<K, V> subscribe(Set<String> var1);

    @Fluent
    public KafkaConsumer<K, V> subscribe(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> subscribe(Set<String> var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> assign(TopicPartition var1);

    @Fluent
    public KafkaConsumer<K, V> assign(Set<TopicPartition> var1);

    @Fluent
    public KafkaConsumer<K, V> assign(TopicPartition var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> assign(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> assignment(Handler<AsyncResult<Set<TopicPartition>>> var1);

    @Fluent
    @GenIgnore
    public KafkaConsumer<K, V> listTopics(Handler<AsyncResult<Map<String, List<PartitionInfo>>>> var1);

    @Fluent
    public KafkaConsumer<K, V> unsubscribe();

    @Fluent
    public KafkaConsumer<K, V> unsubscribe(Handler<AsyncResult<Void>> var1);

    @Fluent
    public KafkaConsumer<K, V> subscription(Handler<AsyncResult<Set<String>>> var1);

    @Fluent
    public KafkaConsumer<K, V> pause(TopicPartition var1);

    @Fluent
    public KafkaConsumer<K, V> pause(Set<TopicPartition> var1);

    @Fluent
    public KafkaConsumer<K, V> pause(TopicPartition var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> pause(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public void paused(Handler<AsyncResult<Set<TopicPartition>>> var1);

    @Fluent
    public KafkaConsumer<K, V> resume(TopicPartition var1);

    @Fluent
    public KafkaConsumer<K, V> resume(Set<TopicPartition> var1);

    @Fluent
    public KafkaConsumer<K, V> resume(TopicPartition var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> resume(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> partitionsRevokedHandler(Handler<Set<TopicPartition>> var1);

    @Fluent
    public KafkaConsumer<K, V> partitionsAssignedHandler(Handler<Set<TopicPartition>> var1);

    @Fluent
    public KafkaConsumer<K, V> seek(TopicPartition var1, long var2);

    @Fluent
    public KafkaConsumer<K, V> seek(TopicPartition var1, long var2, Handler<AsyncResult<Void>> var4);

    @Fluent
    public KafkaConsumer<K, V> seekToBeginning(TopicPartition var1);

    @Fluent
    public KafkaConsumer<K, V> seekToBeginning(Set<TopicPartition> var1);

    @Fluent
    public KafkaConsumer<K, V> seekToBeginning(TopicPartition var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> seekToBeginning(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> seekToEnd(TopicPartition var1);

    @Fluent
    public KafkaConsumer<K, V> seekToEnd(Set<TopicPartition> var1);

    @Fluent
    public KafkaConsumer<K, V> seekToEnd(TopicPartition var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public KafkaConsumer<K, V> seekToEnd(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public void commit();

    public void commit(Handler<AsyncResult<Void>> var1);

    @GenIgnore
    public void commit(Map<TopicPartition, OffsetAndMetadata> var1);

    @GenIgnore
    public void commit(Map<TopicPartition, OffsetAndMetadata> var1, Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> var2);

    public void committed(TopicPartition var1, Handler<AsyncResult<OffsetAndMetadata>> var2);

    @Fluent
    public KafkaConsumer<K, V> partitionsFor(String var1, Handler<AsyncResult<List<PartitionInfo>>> var2);

    default public void close() {
        this.close(null);
    }

    public void close(Handler<AsyncResult<Void>> var1);

    public void position(TopicPartition var1, Handler<AsyncResult<Long>> var2);

    @GenIgnore
    public KafkaReadStream<K, V> asStream();

    @GenIgnore
    public Consumer<K, V> consumer();
}

