/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.consumer;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.ReadStream;
import io.vertx.kafka.client.KafkaCodecs;
import io.vertx.kafka.client.consumer.impl.KafkaReadStreamImpl;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;

public interface KafkaReadStream<K, V>
extends ReadStream<ConsumerRecord<K, V>> {
    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Properties config) {
        return KafkaReadStream.create(vertx, new KafkaConsumer(config));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        Deserializer<K> keyDeserializer = KafkaCodecs.deserializer(keyType);
        Deserializer<V> valueDeserializer = KafkaCodecs.deserializer(valueType);
        return KafkaReadStream.create(vertx, new KafkaConsumer(config, keyDeserializer, valueDeserializer));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Map<String, Object> config) {
        return KafkaReadStream.create(vertx, new KafkaConsumer(config));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Map<String, Object> config, Class<K> keyType, Class<V> valueType) {
        Deserializer<K> keyDeserializer = KafkaCodecs.deserializer(keyType);
        Deserializer<V> valueDeserializer = KafkaCodecs.deserializer(valueType);
        return KafkaReadStream.create(vertx, new KafkaConsumer(config, keyDeserializer, valueDeserializer));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Consumer<K, V> consumer) {
        return new KafkaReadStreamImpl<K, V>(vertx.getOrCreateContext(), consumer);
    }

    public void committed(TopicPartition var1, Handler<AsyncResult<OffsetAndMetadata>> var2);

    public KafkaReadStream<K, V> pause(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> pause(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public void paused(Handler<AsyncResult<Set<TopicPartition>>> var1);

    public KafkaReadStream<K, V> resume(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> resume(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public KafkaReadStream<K, V> seekToEnd(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> seekToEnd(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public KafkaReadStream<K, V> seekToBeginning(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> seekToBeginning(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public KafkaReadStream<K, V> seek(TopicPartition var1, long var2);

    public KafkaReadStream<K, V> seek(TopicPartition var1, long var2, Handler<AsyncResult<Void>> var4);

    public KafkaReadStream<K, V> partitionsRevokedHandler(Handler<Set<TopicPartition>> var1);

    public KafkaReadStream<K, V> partitionsAssignedHandler(Handler<Set<TopicPartition>> var1);

    public KafkaReadStream<K, V> subscribe(Set<String> var1);

    public KafkaReadStream<K, V> subscribe(Set<String> var1, Handler<AsyncResult<Void>> var2);

    public KafkaReadStream<K, V> unsubscribe();

    public KafkaReadStream<K, V> unsubscribe(Handler<AsyncResult<Void>> var1);

    public KafkaReadStream<K, V> subscription(Handler<AsyncResult<Set<String>>> var1);

    public KafkaReadStream<K, V> assign(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> assign(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public KafkaReadStream<K, V> assignment(Handler<AsyncResult<Set<TopicPartition>>> var1);

    public KafkaReadStream<K, V> listTopics(Handler<AsyncResult<Map<String, List<PartitionInfo>>>> var1);

    public void commit();

    public void commit(Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> var1);

    public void commit(Map<TopicPartition, OffsetAndMetadata> var1);

    public void commit(Map<TopicPartition, OffsetAndMetadata> var1, Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> var2);

    public KafkaReadStream<K, V> partitionsFor(String var1, Handler<AsyncResult<List<PartitionInfo>>> var2);

    default public void close() {
        this.close(null);
    }

    public void close(Handler<AsyncResult<Void>> var1);

    public void position(TopicPartition var1, Handler<AsyncResult<Long>> var2);

    public Consumer<K, V> consumer();
}

