/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.kafka.client.producer;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.kafka.client.producer.RecordMetadata;
import io.vertx.rxjava.core.Vertx;
import io.vertx.kafka.client.common.PartitionInfo;
import java.util.List;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Vert.x Kafka producer.
 * <p>
 * The  provides global control over writing a record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.kafka.client.producer.KafkaProducer.class)
public class KafkaProducer<K,V> implements WriteStream<KafkaProducerRecord<K,V>> {

  public static final io.vertx.lang.rxjava.TypeArg<KafkaProducer> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new KafkaProducer((io.vertx.kafka.client.producer.KafkaProducer) obj),
    KafkaProducer::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducer delegate;
  public final io.vertx.lang.rxjava.TypeArg<K> __typeArg_0;
  public final io.vertx.lang.rxjava.TypeArg<V> __typeArg_1;
  
  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
    this.__typeArg_1 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate, io.vertx.lang.rxjava.TypeArg<K> typeArg_0, io.vertx.lang.rxjava.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.producer.KafkaProducer getDelegate() {
    return delegate;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> KafkaProducer<K,V> createShared(Vertx vertx, String name, Map<String,String> config) { 
    KafkaProducer<K,V> ret = KafkaProducer.newInstance(io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config), io.vertx.lang.rxjava.TypeArg.unknown(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> KafkaProducer<K,V> createShared(Vertx vertx, String name, Map<String,String> config, Class<K> keyType, Class<V> valueType) { 
    KafkaProducer<K,V> ret = KafkaProducer.newInstance(io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config, io.vertx.lang.rxjava.Helper.unwrap(keyType), io.vertx.lang.rxjava.Helper.unwrap(valueType)), io.vertx.lang.rxjava.TypeArg.of(keyType), io.vertx.lang.rxjava.TypeArg.of(valueType));
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> KafkaProducer<K,V> create(Vertx vertx, Map<String,String> config) { 
    KafkaProducer<K,V> ret = KafkaProducer.newInstance(io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config), io.vertx.lang.rxjava.TypeArg.unknown(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> KafkaProducer<K,V> create(Vertx vertx, Map<String,String> config, Class<K> keyType, Class<V> valueType) { 
    KafkaProducer<K,V> ret = KafkaProducer.newInstance(io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config, io.vertx.lang.rxjava.Helper.unwrap(keyType), io.vertx.lang.rxjava.Helper.unwrap(valueType)), io.vertx.lang.rxjava.TypeArg.of(keyType), io.vertx.lang.rxjava.TypeArg.of(valueType));
    return ret;
  }

  public KafkaProducer<K,V> exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public KafkaProducer<K,V> write(KafkaProducerRecord<K,V> kafkaProducerRecord) { 
    delegate.write(kafkaProducerRecord.getDelegate());
    return this;
  }

  public void end() { 
    delegate.end();
  }

  public void end(KafkaProducerRecord<K,V> kafkaProducerRecord) { 
    delegate.end(kafkaProducerRecord.getDelegate());
  }

  public KafkaProducer<K,V> setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public KafkaProducer<K,V> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @param handler handler called on operation completed
   * @return current KafkaWriteStream instance
   */
  public KafkaProducer<K,V> write(KafkaProducerRecord<K,V> record, Handler<AsyncResult<RecordMetadata>> handler) { 
    delegate.write(record.getDelegate(), handler);
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return 
   */
  public Single<RecordMetadata> rxWrite(KafkaProducerRecord<K,V> record) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      write(record, fut);
    }));
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @param handler handler called on operation completed
   * @return current KafkaProducer instance
   */
  public KafkaProducer<K,V> partitionsFor(String topic, Handler<AsyncResult<List<PartitionInfo>>> handler) { 
    delegate.partitionsFor(topic, handler);
    return this;
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @return 
   */
  public Single<List<PartitionInfo>> rxPartitionsFor(String topic) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      partitionsFor(topic, fut);
    }));
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * @param completionHandler handler called on operation completed
   * @return current KafkaProducer instance
   */
  public KafkaProducer<K,V> flush(Handler<Void> completionHandler) { 
    delegate.flush(completionHandler);
    return this;
  }

  /**
   * Close the producer
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close the producer
   * @param completionHandler handler called on operation completed
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the producer
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Close the producer
   * @param timeout timeout to wait for closing
   * @param completionHandler handler called on operation completed
   */
  public void close(long timeout, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(timeout, completionHandler);
  }

  /**
   * Close the producer
   * @param timeout timeout to wait for closing
   * @return 
   */
  public Single<Void> rxClose(long timeout) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(timeout, fut);
    }));
  }


  public static <K, V> KafkaProducer newInstance(io.vertx.kafka.client.producer.KafkaProducer arg) {
    return arg != null ? new KafkaProducer<K, V> (arg) : null;
  }

  public static <K, V> KafkaProducer newInstance(io.vertx.kafka.client.producer.KafkaProducer arg, io.vertx.lang.rxjava.TypeArg<K> __typeArg_K, io.vertx.lang.rxjava.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducer<K, V> (arg, __typeArg_K, __typeArg_V) : null;
  }
}
