/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.kafka.admin;

import java.util.Map;
import rx.Observable;
import rx.Single;
import java.util.Map;
import io.vertx.rxjava.core.Vertx;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Provides a wrapper around important methods in Kafka's AdminUtils, namely
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.admin.AdminUtils original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.kafka.admin.AdminUtils.class)
public class AdminUtils {

  public static final io.vertx.lang.rxjava.TypeArg<AdminUtils> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new AdminUtils((io.vertx.kafka.admin.AdminUtils) obj),
    AdminUtils::getDelegate
  );

  private final io.vertx.kafka.admin.AdminUtils delegate;
  
  public AdminUtils(io.vertx.kafka.admin.AdminUtils delegate) {
    this.delegate = delegate;
  }

  public io.vertx.kafka.admin.AdminUtils getDelegate() {
    return delegate;
  }

  /**
   * Create a new AdminUtils instance
   * @param vertx Vert.x instance to use
   * @param zookeeperHosts comma-separated list of Zookeeper server, e.g. localhost:2181,localhost:2182
   * @return an instance of the AdminUtilWrapper
   */
  public static AdminUtils create(Vertx vertx, String zookeeperHosts) { 
    AdminUtils ret = AdminUtils.newInstance(io.vertx.kafka.admin.AdminUtils.create(vertx.getDelegate(), zookeeperHosts));
    return ret;
  }

  /**
   * Create a new AdminUtils instance
   * @param vertx Vert.x instance to use
   * @param zookeeperHosts comma-separated list of Zookeeper server, e.g. localhost:2181,localhost:2182
   * @param autoClose If set to true, the client will auto-close the connection after a command
   * @return an instance of the AdminUtilWrapper
   */
  public static AdminUtils create(Vertx vertx, String zookeeperHosts, boolean autoClose) { 
    AdminUtils ret = AdminUtils.newInstance(io.vertx.kafka.admin.AdminUtils.create(vertx.getDelegate(), zookeeperHosts, autoClose));
    return ret;
  }

  /**
   * Create a new AdminUtils instance
   * @param vertx Vert.x instance to use
   * @param zookeeperHosts comma-separated list of Zookeeper server, e.g. localhost:2181,localhost:2182
   * @param connectionTimeoutMs Maximum time in ms to wait for the client to connect to Zookeeper
   * @param isSecure If set to true, ZkUtils will perform security checks, i.e. ACL checks
   * @param autoClose If set to true, the client will auto-close the connection after a command
   * @return an instance of the AdminUtilWrapper
   */
  public static AdminUtils create(Vertx vertx, String zookeeperHosts, int connectionTimeoutMs, boolean isSecure, boolean autoClose) { 
    AdminUtils ret = AdminUtils.newInstance(io.vertx.kafka.admin.AdminUtils.create(vertx.getDelegate(), zookeeperHosts, connectionTimeoutMs, isSecure, autoClose));
    return ret;
  }

  /**
   * Creates a new Kafka topic on all Brokers managed by the given Zookeeper instance(s)
   * @param topicName Name of the to-be-created topic
   * @param partitionCount Number of partitions
   * @param replicationFactor Number of replicates. Must be lower or equal to the number of available Brokers
   * @param completionHandler vert.x callback
   */
  public void createTopic(String topicName, int partitionCount, int replicationFactor, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.createTopic(topicName, partitionCount, replicationFactor, completionHandler);
  }

  /**
   * Creates a new Kafka topic on all Brokers managed by the given Zookeeper instance(s)
   * @param topicName Name of the to-be-created topic
   * @param partitionCount Number of partitions
   * @param replicationFactor Number of replicates. Must be lower or equal to the number of available Brokers
   * @return 
   */
  public Single<Void> rxCreateTopic(String topicName, int partitionCount, int replicationFactor) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createTopic(topicName, partitionCount, replicationFactor, fut);
    }));
  }

  /**
   * Creates a new Kafka topic on all Brokers managed by the given Zookeeper instance(s). In contrast
   * to @see {@link io.vertx.rxjava.kafka.admin.AdminUtils#createTopic}, one can pass in additional configuration
   * parameters as a map (String -> String).
   * @param topicName Name of the to-be-created topic
   * @param partitionCount Number of partitions
   * @param replicationFactor Number of replicates. Must be lower or equal to the number of available Brokers
   * @param topicConfig map with additional topic configuration parameters
   * @param completionHandler vert.x callback
   */
  public void createTopic(String topicName, int partitionCount, int replicationFactor, Map<String,String> topicConfig, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.createTopic(topicName, partitionCount, replicationFactor, topicConfig, completionHandler);
  }

  /**
   * Creates a new Kafka topic on all Brokers managed by the given Zookeeper instance(s). In contrast
   * to @see {@link io.vertx.rxjava.kafka.admin.AdminUtils#createTopic}, one can pass in additional configuration
   * parameters as a map (String -> String).
   * @param topicName Name of the to-be-created topic
   * @param partitionCount Number of partitions
   * @param replicationFactor Number of replicates. Must be lower or equal to the number of available Brokers
   * @param topicConfig map with additional topic configuration parameters
   * @return 
   */
  public Single<Void> rxCreateTopic(String topicName, int partitionCount, int replicationFactor, Map<String,String> topicConfig) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createTopic(topicName, partitionCount, replicationFactor, topicConfig, fut);
    }));
  }

  /**
   * Delete the Kafka topic given by the topicName.
   * @param topicName Name of the topic to be deleted
   * @param completionHandler vert.x callback
   */
  public void deleteTopic(String topicName, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.deleteTopic(topicName, completionHandler);
  }

  /**
   * Delete the Kafka topic given by the topicName.
   * @param topicName Name of the topic to be deleted
   * @return 
   */
  public Single<Void> rxDeleteTopic(String topicName) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deleteTopic(topicName, fut);
    }));
  }

  /**
   * Checks if the Kafka topic given by topicName does exist.
   * @param topicName Name of the topic
   * @param completionHandler vert.x callback
   */
  public void topicExists(String topicName, Handler<AsyncResult<Boolean>> completionHandler) { 
    delegate.topicExists(topicName, completionHandler);
  }

  /**
   * Checks if the Kafka topic given by topicName does exist.
   * @param topicName Name of the topic
   * @return 
   */
  public Single<Boolean> rxTopicExists(String topicName) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      topicExists(topicName, fut);
    }));
  }

  /**
   * Updates the configuration of the topic given by topicName. Configuration parameters
   * are passed in as a Map (Key -> Value) of Strings.
   * @param topicName topic to be configured
   * @param topicConfig Map with configuration items
   * @param completionHandler vert.x callback
   */
  public void changeTopicConfig(String topicName, Map<String,String> topicConfig, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.changeTopicConfig(topicName, topicConfig, completionHandler);
  }

  /**
   * Updates the configuration of the topic given by topicName. Configuration parameters
   * are passed in as a Map (Key -> Value) of Strings.
   * @param topicName topic to be configured
   * @param topicConfig Map with configuration items
   * @return 
   */
  public Single<Void> rxChangeTopicConfig(String topicName, Map<String,String> topicConfig) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      changeTopicConfig(topicName, topicConfig, fut);
    }));
  }

  /**
   * Closes the underlying connection to Zookeeper. It is required to call the method for cleanup
   * purposes if AdminUtils was not created with autoClose set to true.
   * @param completionHandler vert.x callback
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Closes the underlying connection to Zookeeper. It is required to call the method for cleanup
   * purposes if AdminUtils was not created with autoClose set to true.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }


  public static  AdminUtils newInstance(io.vertx.kafka.admin.AdminUtils arg) {
    return arg != null ? new AdminUtils(arg) : null;
  }
}
