/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.kafka.client.producer;

import java.util.Map;
import rx.Observable;
import rx.Single;

/**
 * Vert.x Kafka producer record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducerRecord original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.kafka.client.producer.KafkaProducerRecord.class)
public class KafkaProducerRecord<K,V> {

  public static final io.vertx.lang.rxjava.TypeArg<KafkaProducerRecord> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new KafkaProducerRecord((io.vertx.kafka.client.producer.KafkaProducerRecord) obj),
    KafkaProducerRecord::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducerRecord delegate;
  public final io.vertx.lang.rxjava.TypeArg<K> __typeArg_0;
  public final io.vertx.lang.rxjava.TypeArg<V> __typeArg_1;
  
  public KafkaProducerRecord(io.vertx.kafka.client.producer.KafkaProducerRecord delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
    this.__typeArg_1 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public KafkaProducerRecord(io.vertx.kafka.client.producer.KafkaProducerRecord delegate, io.vertx.lang.rxjava.TypeArg<K> typeArg_0, io.vertx.lang.rxjava.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.producer.KafkaProducerRecord getDelegate() {
    return delegate;
  }

  /**
   * Create a concrete instance of a Vert.x producer record
   * @param topic the topic this record is being sent to
   * @param key the key (or null if no key is specified)
   * @param value the value
   * @param timestamp the timestamp of this record
   * @param partition the partition to which the record will be sent (or null if no partition was specified)
   * @return Vert.x producer record
   */
  public static <K, V> KafkaProducerRecord<K,V> create(String topic, K key, V value, Long timestamp, Integer partition) { 
    KafkaProducerRecord<K,V> ret = KafkaProducerRecord.newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, key, value, timestamp, partition), io.vertx.lang.rxjava.TypeArg.unknown(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a concrete instance of a Vert.x producer record
   * @param topic the topic this record is being sent to
   * @param key the key (or null if no key is specified)
   * @param value the value
   * @return Vert.x producer record
   */
  public static <K, V> KafkaProducerRecord<K,V> create(String topic, K key, V value) { 
    KafkaProducerRecord<K,V> ret = KafkaProducerRecord.newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, key, value), io.vertx.lang.rxjava.TypeArg.unknown(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a concrete instance of a Vert.x producer record
   * @param topic the topic this record is being sent to
   * @param value the value
   * @return Vert.x producer record
   */
  public static <K, V> KafkaProducerRecord<K,V> create(String topic, V value) { 
    KafkaProducerRecord<K,V> ret = KafkaProducerRecord.newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord.create(topic, value), io.vertx.lang.rxjava.TypeArg.unknown(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * @return the topic this record is being sent to
   */
  public String topic() { 
    String ret = delegate.topic();
    return ret;
  }

  /**
   * @return the key (or null if no key is specified)
   */
  public K key() { 
    K ret = (K)__typeArg_0.wrap(delegate.key());
    return ret;
  }

  /**
   * @return the value
   */
  public V value() { 
    V ret = (V)__typeArg_1.wrap(delegate.value());
    return ret;
  }

  /**
   * @return the timestamp of this record
   */
  public Long timestamp() { 
    Long ret = delegate.timestamp();
    return ret;
  }

  /**
   * @return the partition to which the record will be sent (or null if no partition was specified)
   */
  public Integer partition() { 
    Integer ret = delegate.partition();
    return ret;
  }


  public static <K,V>KafkaProducerRecord<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord arg) {
    return arg != null ? new KafkaProducerRecord<K,V>(arg) : null;
  }

  public static <K,V>KafkaProducerRecord<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducerRecord arg, io.vertx.lang.rxjava.TypeArg<K> __typeArg_K, io.vertx.lang.rxjava.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducerRecord<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }
}
