/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.kafka.admin;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import java.util.Map;

@RxGen(value=io.vertx.kafka.admin.AdminUtils.class)
public class AdminUtils {
    public static final TypeArg<AdminUtils> __TYPE_ARG = new TypeArg(obj -> new AdminUtils((io.vertx.kafka.admin.AdminUtils)obj), AdminUtils::getDelegate);
    private final io.vertx.kafka.admin.AdminUtils delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminUtils that = (AdminUtils)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AdminUtils(io.vertx.kafka.admin.AdminUtils delegate) {
        this.delegate = delegate;
    }

    public io.vertx.kafka.admin.AdminUtils getDelegate() {
        return this.delegate;
    }

    public static AdminUtils create(Vertx vertx, String zookeeperHosts) {
        AdminUtils ret = AdminUtils.newInstance(io.vertx.kafka.admin.AdminUtils.create(vertx.getDelegate(), zookeeperHosts));
        return ret;
    }

    public static AdminUtils create(Vertx vertx, String zookeeperHosts, boolean autoClose) {
        AdminUtils ret = AdminUtils.newInstance(io.vertx.kafka.admin.AdminUtils.create(vertx.getDelegate(), zookeeperHosts, autoClose));
        return ret;
    }

    public static AdminUtils create(Vertx vertx, String zookeeperHosts, int connectionTimeoutMs, boolean isSecure, boolean autoClose) {
        AdminUtils ret = AdminUtils.newInstance(io.vertx.kafka.admin.AdminUtils.create(vertx.getDelegate(), zookeeperHosts, connectionTimeoutMs, isSecure, autoClose));
        return ret;
    }

    public void createTopic(String topicName, int partitionCount, int replicationFactor, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.createTopic(topicName, partitionCount, replicationFactor, completionHandler);
    }

    public Completable rxCreateTopic(String topicName, int partitionCount, int replicationFactor) {
        return new AsyncResultCompletable(handler -> this.createTopic(topicName, partitionCount, replicationFactor, (Handler<AsyncResult<Void>>)handler));
    }

    public void createTopic(String topicName, int partitionCount, int replicationFactor, Map<String, String> topicConfig, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.createTopic(topicName, partitionCount, replicationFactor, topicConfig, completionHandler);
    }

    public Completable rxCreateTopic(String topicName, int partitionCount, int replicationFactor, Map<String, String> topicConfig) {
        return new AsyncResultCompletable(handler -> this.createTopic(topicName, partitionCount, replicationFactor, topicConfig, (Handler<AsyncResult<Void>>)handler));
    }

    public void deleteTopic(String topicName, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.deleteTopic(topicName, completionHandler);
    }

    public Completable rxDeleteTopic(String topicName) {
        return new AsyncResultCompletable(handler -> this.deleteTopic(topicName, (Handler<AsyncResult<Void>>)handler));
    }

    public void topicExists(String topicName, Handler<AsyncResult<Boolean>> completionHandler) {
        this.delegate.topicExists(topicName, completionHandler);
    }

    public Single<Boolean> rxTopicExists(String topicName) {
        return new AsyncResultSingle(handler -> this.topicExists(topicName, (Handler<AsyncResult<Boolean>>)handler));
    }

    public void changeTopicConfig(String topicName, Map<String, String> topicConfig, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.changeTopicConfig(topicName, topicConfig, completionHandler);
    }

    public Completable rxChangeTopicConfig(String topicName, Map<String, String> topicConfig) {
        return new AsyncResultCompletable(handler -> this.changeTopicConfig(topicName, topicConfig, (Handler<AsyncResult<Void>>)handler));
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Completable rxClose() {
        return new AsyncResultCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public static AdminUtils newInstance(io.vertx.kafka.admin.AdminUtils arg) {
        return arg != null ? new AdminUtils(arg) : null;
    }
}

