/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.kafka.client.consumer;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import io.vertx.rxjava.core.Vertx;
import java.util.Set;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.kafka.client.common.TopicPartition;
import java.util.List;
import java.util.Map;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.kafka.client.consumer.OffsetAndTimestamp;

/**
 * Vert.x Kafka consumer.
 * <p>
 * You receive Kafka records by providing a {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#handler}. As messages arrive the handler
 * will be called with the records.
 * <p>
 * The {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#resume} provides global control over reading the records from the consumer.
 * <p>
 * The {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#resume} provides finer grained control over reading records
 * for specific Topic/Partition, these are Kafka's specific operations.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.consumer.KafkaConsumer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.kafka.client.consumer.KafkaConsumer.class)
public class KafkaConsumer<K,V> implements ReadStream<KafkaConsumerRecord<K,V>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaConsumer that = (KafkaConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<KafkaConsumer> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new KafkaConsumer((io.vertx.kafka.client.consumer.KafkaConsumer) obj),
    KafkaConsumer::getDelegate
  );

  private final io.vertx.kafka.client.consumer.KafkaConsumer delegate;
  public final io.vertx.lang.rxjava.TypeArg<K> __typeArg_0;
  public final io.vertx.lang.rxjava.TypeArg<V> __typeArg_1;
  
  public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
    this.__typeArg_1 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate, io.vertx.lang.rxjava.TypeArg<K> typeArg_0, io.vertx.lang.rxjava.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.consumer.KafkaConsumer getDelegate() {
    return delegate;
  }

  private rx.Observable<KafkaConsumerRecord<K,V>> observable;

  public synchronized rx.Observable<KafkaConsumerRecord<K,V>> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord, KafkaConsumerRecord<K,V>> conv = KafkaConsumerRecord::newInstance;
      observable = io.vertx.rx.java.RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> KafkaConsumer<K,V> create(Vertx vertx, Map<String,String> config) { 
    KafkaConsumer<K,V> ret = KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config), io.vertx.lang.rxjava.TypeArg.unknown(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaConsumer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @param keyType class type for the key deserialization
   * @param valueType class type for the value deserialization
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> KafkaConsumer<K,V> create(Vertx vertx, Map<String,String> config, Class<K> keyType, Class<V> valueType) { 
    KafkaConsumer<K,V> ret = KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config, io.vertx.lang.rxjava.Helper.unwrap(keyType), io.vertx.lang.rxjava.Helper.unwrap(valueType)), io.vertx.lang.rxjava.TypeArg.of(keyType), io.vertx.lang.rxjava.TypeArg.of(valueType));
    return ret;
  }

  public KafkaConsumer<K,V> exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public KafkaConsumer<K,V> handler(Handler<KafkaConsumerRecord<K,V>> handler) { 
    delegate.handler(new Handler<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>>() {
      public void handle(io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V> event) {
        handler.handle(KafkaConsumerRecord.newInstance(event, __typeArg_0, __typeArg_1));
      }
    });
    return this;
  }

  public KafkaConsumer<K,V> pause() { 
    delegate.pause();
    return this;
  }

  public KafkaConsumer<K,V> resume() { 
    delegate.resume();
    return this;
  }

  public KafkaConsumer<K,V> endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * @param topic topic to subscribe to
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> subscribe(String topic) { 
    delegate.subscribe(topic);
    return this;
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * @param topics topics to subscribe to
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> subscribe(Set<String> topics) { 
    delegate.subscribe(topics);
    return this;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topic  
   * the old topic may remain in effect 
   * (as observed by the  record handler}) 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new topic.
   * @param topic topic to subscribe to
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> subscribe(String topic, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.subscribe(topic, completionHandler);
    return this;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topic  
   * the old topic may remain in effect 
   * (as observed by the  record handler}) 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new topic.
   * @param topic topic to subscribe to
   * @return 
   */
  public Single<Void> rxSubscribe(String topic) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      subscribe(topic, fut);
    }));
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics  
   * the old set of topics may remain in effect 
   * (as observed by the  record handler}) 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new set of topics.
   * @param topics topics to subscribe to
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> subscribe(Set<String> topics, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.subscribe(topics, completionHandler);
    return this;
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics  
   * the old set of topics may remain in effect 
   * (as observed by the  record handler}) 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new set of topics.
   * @param topics topics to subscribe to
   * @return 
   */
  public Single<Void> rxSubscribe(Set<String> topics) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      subscribe(topics, fut);
    }));
  }

  /**
   * Manually assign a partition to this consumer.
   * @param topicPartition partition which want assigned
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> assign(TopicPartition topicPartition) { 
    delegate.assign(topicPartition);
    return this;
  }

  /**
   * Manually assign a list of partition to this consumer.
   * @param topicPartitions partitions which want assigned
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> assign(Set<TopicPartition> topicPartitions) { 
    delegate.assign(topicPartitions);
    return this;
  }

  /**
   * Manually assign a partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old partition may remain in effect 
   * (as observed by the  record handler)} 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new partition.
   * @param topicPartition partition which want assigned
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> assign(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.assign(topicPartition, completionHandler);
    return this;
  }

  /**
   * Manually assign a partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old partition may remain in effect 
   * (as observed by the  record handler)} 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new partition.
   * @param topicPartition partition which want assigned
   * @return 
   */
  public Single<Void> rxAssign(TopicPartition topicPartition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      assign(topicPartition, fut);
    }));
  }

  /**
   * Manually assign a list of partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old set of partitions may remain in effect 
   * (as observed by the  record handler)} 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new set of partitions.
   * @param topicPartitions partitions which want assigned
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> assign(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.assign(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Manually assign a list of partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old set of partitions may remain in effect 
   * (as observed by the  record handler)} 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new set of partitions.
   * @param topicPartitions partitions which want assigned
   * @return 
   */
  public Single<Void> rxAssign(Set<TopicPartition> topicPartitions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      assign(topicPartitions, fut);
    }));
  }

  /**
   * Get the set of partitions currently assigned to this consumer.
   * @param handler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> assignment(Handler<AsyncResult<Set<TopicPartition>>> handler) { 
    delegate.assignment(handler);
    return this;
  }

  /**
   * Get the set of partitions currently assigned to this consumer.
   * @return 
   */
  public Single<Set<TopicPartition>> rxAssignment() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      assignment(fut);
    }));
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> unsubscribe() { 
    delegate.unsubscribe();
    return this;
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> unsubscribe(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.unsubscribe(completionHandler);
    return this;
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * @return 
   */
  public Single<Void> rxUnsubscribe() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      unsubscribe(fut);
    }));
  }

  /**
   * Get the current subscription.
   * @param handler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> subscription(Handler<AsyncResult<Set<String>>> handler) { 
    delegate.subscription(handler);
    return this;
  }

  /**
   * Get the current subscription.
   * @return 
   */
  public Single<Set<String>> rxSubscription() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      subscription(fut);
    }));
  }

  /**
   * Suspend fetching from the requested partition.
   * @param topicPartition topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> pause(TopicPartition topicPartition) { 
    delegate.pause(topicPartition);
    return this;
  }

  /**
   * Suspend fetching from the requested partitions.
   * @param topicPartitions topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> pause(Set<TopicPartition> topicPartitions) { 
    delegate.pause(topicPartitions);
    return this;
  }

  /**
   * Suspend fetching from the requested partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages from the given <code>topicParation</code> 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages 
   * from the given <code>topicParation</code>.
   * @param topicPartition topic partition from which suspend fetching
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> pause(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.pause(topicPartition, completionHandler);
    return this;
  }

  /**
   * Suspend fetching from the requested partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages from the given <code>topicParation</code> 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages 
   * from the given <code>topicParation</code>.
   * @param topicPartition topic partition from which suspend fetching
   * @return 
   */
  public Single<Void> rxPause(TopicPartition topicPartition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pause(topicPartition, fut);
    }));
  }

  /**
   * Suspend fetching from the requested partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages from the given <code>topicParations</code> 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages 
   * from the given <code>topicParations</code>.
   * @param topicPartitions topic partition from which suspend fetching
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> pause(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.pause(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Suspend fetching from the requested partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages from the given <code>topicParations</code> 
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages 
   * from the given <code>topicParations</code>.
   * @param topicPartitions topic partition from which suspend fetching
   * @return 
   */
  public Single<Void> rxPause(Set<TopicPartition> topicPartitions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pause(topicPartitions, fut);
    }));
  }

  /**
   * Get the set of partitions that were previously paused by a call to pause(Set).
   * @param handler handler called on operation completed
   */
  public void paused(Handler<AsyncResult<Set<TopicPartition>>> handler) { 
    delegate.paused(handler);
  }

  /**
   * Get the set of partitions that were previously paused by a call to pause(Set).
   * @return 
   */
  public Single<Set<TopicPartition>> rxPaused() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      paused(fut);
    }));
  }

  /**
   * Resume specified partition which have been paused with pause.
   * @param topicPartition topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> resume(TopicPartition topicPartition) { 
    delegate.resume(topicPartition);
    return this;
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * @param topicPartitions topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> resume(Set<TopicPartition> topicPartitions) { 
    delegate.resume(topicPartitions);
    return this;
  }

  /**
   * Resume specified partition which have been paused with pause.
   * @param topicPartition topic partition from which resume fetching
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> resume(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.resume(topicPartition, completionHandler);
    return this;
  }

  /**
   * Resume specified partition which have been paused with pause.
   * @param topicPartition topic partition from which resume fetching
   * @return 
   */
  public Single<Void> rxResume(TopicPartition topicPartition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      resume(topicPartition, fut);
    }));
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * @param topicPartitions topic partition from which resume fetching
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> resume(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.resume(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * @param topicPartitions topic partition from which resume fetching
   * @return 
   */
  public Single<Void> rxResume(Set<TopicPartition> topicPartitions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      resume(topicPartitions, fut);
    }));
  }

  /**
   * Set the handler called when topic partitions are revoked to the consumer
   * @param handler handler called on revoked topic partitions
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> partitionsRevokedHandler(Handler<Set<TopicPartition>> handler) { 
    delegate.partitionsRevokedHandler(handler);
    return this;
  }

  /**
   * Set the handler called when topic partitions are assigned to the consumer
   * @param handler handler called on assigned topic partitions
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> partitionsAssignedHandler(Handler<Set<TopicPartition>> handler) { 
    delegate.partitionsAssignedHandler(handler);
    return this;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seek(TopicPartition topicPartition, long offset) { 
    delegate.seek(topicPartition, offset);
    return this;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seek(TopicPartition topicPartition, long offset, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seek(topicPartition, offset, completionHandler);
    return this;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return 
   */
  public Single<Void> rxSeek(TopicPartition topicPartition, long offset) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      seek(topicPartition, offset, fut);
    }));
  }

  /**
   * Seek to the first offset for each of the given partition.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seekToBeginning(TopicPartition topicPartition) { 
    delegate.seekToBeginning(topicPartition);
    return this;
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seekToBeginning(Set<TopicPartition> topicPartitions) { 
    delegate.seekToBeginning(topicPartitions);
    return this;
  }

  /**
   * Seek to the first offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seekToBeginning(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seekToBeginning(topicPartition, completionHandler);
    return this;
  }

  /**
   * Seek to the first offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return 
   */
  public Single<Void> rxSeekToBeginning(TopicPartition topicPartition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      seekToBeginning(topicPartition, fut);
    }));
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seekToBeginning(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seekToBeginning(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return 
   */
  public Single<Void> rxSeekToBeginning(Set<TopicPartition> topicPartitions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      seekToBeginning(topicPartitions, fut);
    }));
  }

  /**
   * Seek to the last offset for each of the given partition.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seekToEnd(TopicPartition topicPartition) { 
    delegate.seekToEnd(topicPartition);
    return this;
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seekToEnd(Set<TopicPartition> topicPartitions) { 
    delegate.seekToEnd(topicPartitions);
    return this;
  }

  /**
   * Seek to the last offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seekToEnd(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seekToEnd(topicPartition, completionHandler);
    return this;
  }

  /**
   * Seek to the last offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartition topic partition for which seek
   * @return 
   */
  public Single<Void> rxSeekToEnd(TopicPartition topicPartition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      seekToEnd(topicPartition, fut);
    }));
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> seekToEnd(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seekToEnd(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will 
   * continue to observe messages fetched with respect to the old offset  
   * until some time <em>after</em> the given <code>completionHandler</code> 
   * is called. In contrast, the once the given <code>completionHandler</code> 
   * is called the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages 
   * consistent with the new offset.
   * @param topicPartitions topic partition for which seek
   * @return 
   */
  public Single<Void> rxSeekToEnd(Set<TopicPartition> topicPartitions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      seekToEnd(topicPartitions, fut);
    }));
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   */
  public void commit() { 
    delegate.commit();
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   * @param completionHandler handler called on operation completed
   */
  public void commit(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.commit(completionHandler);
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   * @return 
   */
  public Single<Void> rxCommit() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      commit(fut);
    }));
  }

  /**
   * Get the last committed offset for the given partition (whether the commit happened by this process or another).
   * @param topicPartition topic partition for getting last committed offset
   * @param handler handler called on operation completed
   */
  public void committed(TopicPartition topicPartition, Handler<AsyncResult<OffsetAndMetadata>> handler) { 
    delegate.committed(topicPartition, handler);
  }

  /**
   * Get the last committed offset for the given partition (whether the commit happened by this process or another).
   * @param topicPartition topic partition for getting last committed offset
   * @return 
   */
  public Single<OffsetAndMetadata> rxCommitted(TopicPartition topicPartition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      committed(topicPartition, fut);
    }));
  }

  /**
   * Get metadata about the partitions for a given topic.
   * @param topic topic partition for which getting partitions info
   * @param handler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> partitionsFor(String topic, Handler<AsyncResult<List<PartitionInfo>>> handler) { 
    delegate.partitionsFor(topic, handler);
    return this;
  }

  /**
   * Get metadata about the partitions for a given topic.
   * @param topic topic partition for which getting partitions info
   * @return 
   */
  public Single<List<PartitionInfo>> rxPartitionsFor(String topic) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      partitionsFor(topic, fut);
    }));
  }

  /**
   * Set the handler to be used when batches of messages are fetched
   * from the Kafka server. Batch handlers need to take care not to block
   * the event loop when dealing with large batches. It is better to process
   * records individually using the {@link io.vertx.rxjava.kafka.client.consumer.KafkaConsumer #handler(Handler) record handler}.
   * @param handler handler called when batches of messages are fetched
   * @return current KafkaConsumer instance
   */
  public KafkaConsumer<K,V> batchHandler(Handler<KafkaConsumerRecords<K,V>> handler) { 
    delegate.batchHandler(new Handler<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>>() {
      public void handle(io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V> event) {
        handler.handle(KafkaConsumerRecords.newInstance(event, __typeArg_0, __typeArg_1));
      }
    });
    return this;
  }

  /**
   * Close the consumer
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close the consumer
   * @param completionHandler handler called on operation completed
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the consumer
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Get the offset of the next record that will be fetched (if a record with that offset exists).
   * @param partition The partition to get the position for
   * @param handler handler called on operation completed
   */
  public void position(TopicPartition partition, Handler<AsyncResult<Long>> handler) { 
    delegate.position(partition, handler);
  }

  /**
   * Get the offset of the next record that will be fetched (if a record with that offset exists).
   * @param partition The partition to get the position for
   * @return 
   */
  public Single<Long> rxPosition(TopicPartition partition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      position(partition, fut);
    }));
  }

  /**
   * Look up the offset for the given partition by timestamp. Note: the result might be null in case
   * for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @param handler handler called on operation completed
   */
  public void offsetsForTimes(TopicPartition topicPartition, Long timestamp, Handler<AsyncResult<OffsetAndTimestamp>> handler) { 
    delegate.offsetsForTimes(topicPartition, timestamp, handler);
  }

  /**
   * Look up the offset for the given partition by timestamp. Note: the result might be null in case
   * for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return 
   */
  public Single<OffsetAndTimestamp> rxOffsetsForTimes(TopicPartition topicPartition, Long timestamp) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      offsetsForTimes(topicPartition, timestamp, fut);
    }));
  }

  /**
   * Get the first offset for the given partitions.
   * @param topicPartition the partition to get the earliest offset.
   * @param handler handler called on operation completed. Returns the earliest available offset for the given partition
   */
  public void beginningOffsets(TopicPartition topicPartition, Handler<AsyncResult<Long>> handler) { 
    delegate.beginningOffsets(topicPartition, handler);
  }

  /**
   * Get the first offset for the given partitions.
   * @param topicPartition the partition to get the earliest offset.
   * @return 
   */
  public Single<Long> rxBeginningOffsets(TopicPartition topicPartition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      beginningOffsets(topicPartition, fut);
    }));
  }

  /**
   * Get the last offset for the given partition. The last offset of a partition is the offset
   * of the upcoming message, i.e. the offset of the last available message + 1.
   * @param topicPartition the partition to get the end offset.
   * @param handler handler called on operation completed. The end offset for the given partition.
   */
  public void endOffsets(TopicPartition topicPartition, Handler<AsyncResult<Long>> handler) { 
    delegate.endOffsets(topicPartition, handler);
  }

  /**
   * Get the last offset for the given partition. The last offset of a partition is the offset
   * of the upcoming message, i.e. the offset of the last available message + 1.
   * @param topicPartition the partition to get the end offset.
   * @return 
   */
  public Single<Long> rxEndOffsets(TopicPartition topicPartition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      endOffsets(topicPartition, fut);
    }));
  }

  /**
   * Sets the poll timeout (in ms) for the underlying native Kafka Consumer. Defaults to 1000.
   * Setting timeout to a lower value results in a more 'responsive' client, because it will block for a shorter period
   * if no data is available in the assigned partition and therefore allows subsequent actions to be executed with a shorter
   * delay. At the same time, the client will poll more frequently and thus will potentially create a higher load on the Kafka Broker.
   * @param timeout The time, in milliseconds, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
   * @return 
   */
  public KafkaConsumer<K,V> pollTimeout(long timeout) { 
    KafkaConsumer<K,V> ret = KafkaConsumer.newInstance(delegate.pollTimeout(timeout), __typeArg_0, __typeArg_1);
    return ret;
  }


  public static <K,V>KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg) {
    return arg != null ? new KafkaConsumer<K,V>(arg) : null;
  }

  public static <K,V>KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg, io.vertx.lang.rxjava.TypeArg<K> __typeArg_K, io.vertx.lang.rxjava.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaConsumer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }
}
