package io.vertx.groovy.kafka.client;
import groovy.lang.MetaMethod;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import org.codehaus.groovy.runtime.m12n.MetaInfExtensionModule;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
public class VertxExtensionModule extends ExtensionModule {
  private static final String extensionClasses = "io.vertx.groovy.kafka.client.consumer.KafkaConsumer_GroovyExtension, io.vertx.groovy.kafka.client.consumer.KafkaConsumerRecord_GroovyExtension, io.vertx.groovy.kafka.client.producer.KafkaProducer_GroovyExtension, io.vertx.groovy.kafka.client.producer.KafkaProducerRecord_GroovyExtension";
  private static final String staticExtensionClasses = "io.vertx.groovy.kafka.client.producer.KafkaProducerRecord_GroovyStaticExtension";
  private final ExtensionModule delegate;  public VertxExtensionModule() {
    super("io.vertx.kafka.client", "3.5.0");
    Properties props = new Properties();
    props.put("moduleName", "io.vertx.kafka.client");
    props.put("moduleVersion", "3.5.0");
    props.put("extensionClasses", extensionClasses);
    props.put("staticExtensionClasses", staticExtensionClasses);
    delegate = MetaInfExtensionModule.newModule(props, getClass().getClassLoader());
  }
  public List<MetaMethod> getMetaMethods() {
    return delegate.getMetaMethods();
  }
}